/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.signers.xades.EscapeHelper;
import es.gob.afirma.signers.xml.dereference.CustomUriDereferencer;
import es.gob.afirma.signers.xml.style.XmlStyle;
import es.uji.crypto.xades.jxades.security.xml.WrappedKeyStorePlace;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_BES;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XMLAdvancedSignature;
import es.uji.crypto.xades.jxades.security.xml.XmlWrappedKeyInfo;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class AOXMLAdvancedSignature
extends XMLAdvancedSignature {
    static final Logger LOGGER = Logger.getLogger("es.agob.afirma");
    private String canonicalizationMethod = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private Element styleElement = null;
    private String styleType = "text/xsl";
    private String styleEncoding = null;
    private String styleId = null;

    private AOXMLAdvancedSignature(XAdES_BES xAdES_BES) {
        super(xAdES_BES);
    }

    void addStyleSheetEnvelopingOntoSignature(XmlStyle xmlStyle, String string) {
        this.styleElement = xmlStyle.getStyleElement();
        if (xmlStyle.getStyleType() != null) {
            this.styleType = xmlStyle.getStyleType();
        }
        this.styleId = string;
        this.styleEncoding = xmlStyle.getStyleEncoding();
    }

    void setCanonicalizationMethod(String string) {
        if (string != null) {
            this.canonicalizationMethod = string;
        }
    }

    private KeyInfo newKeyInfo(List<Certificate> list, String string, boolean bl, boolean bl2, boolean bl3) throws KeyException {
        List<Certificate> list2 = EscapeHelper.getEscapedCertificates(list);
        KeyInfoFactory keyInfoFactory = this.getXMLSignatureFactory().getKeyInfoFactory();
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        if (!XmlWrappedKeyInfo.PUBLIC_KEY.equals((Object)this.getXmlWrappedKeyInfo())) {
            for (Certificate certificate : list2) {
                arrayList.add(certificate);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(keyInfoFactory.newX509Data(arrayList));
        if (bl) {
            arrayList2.add(keyInfoFactory.newKeyValue(list2.get(0).getPublicKey()));
        }
        if (bl2) {
            arrayList2.add(keyInfoFactory.newKeyName(EscapeHelper.escapeLdapName(((X509Certificate)list2.get(0)).getSubjectX500Principal().toString())));
        }
        if (bl3) {
            arrayList2.add(keyInfoFactory.newX509IssuerSerial(EscapeHelper.escapeLdapName(((X509Certificate)list2.get(0)).getIssuerX500Principal().toString()), ((X509Certificate)list2.get(0)).getSerialNumber()));
        }
        return keyInfoFactory.newKeyInfo(arrayList2, string);
    }

    void sign(List<Certificate> list, PrivateKey privateKey, String string, List<?> list2, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws MarshalException, GeneralSecurityException, XMLSignatureException {
        ArrayList arrayList = new ArrayList(list2);
        if (WrappedKeyStorePlace.SIGNING_CERTIFICATE_PROPERTY.equals((Object)this.getWrappedKeyStorePlace()) && list != null && list.size() > 0) {
            this.xades.setSigningCertificate((X509Certificate)list.get(0));
        }
        this.addXMLObject(this.marshalXMLSignature(this.xadesNamespace, this.signedPropertiesTypeUrl, string2, arrayList));
        XMLSignatureFactory xMLSignatureFactory = this.getXMLSignatureFactory();
        if (this.styleElement != null && this.styleId != null) {
            this.addXMLObject(xMLSignatureFactory.newXMLObject(Collections.singletonList(new DOMStructure(this.styleElement)), this.styleId, this.styleType, this.styleEncoding));
        }
        List list3 = this.getReferences(arrayList);
        String string3 = this.getKeyInfoId(string2);
        if (!bl4) {
            list3.add(xMLSignatureFactory.newReference("#" + string3, this.getDigestMethod()));
        }
        this.signature = xMLSignatureFactory.newXMLSignature(xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod(this.canonicalizationMethod, (C14NMethodParameterSpec)null), xMLSignatureFactory.newSignatureMethod(string, null), list3), this.newKeyInfo(list, string3, bl, bl2, bl3), this.getXMLObjects(), this.getSignatureId(string2), this.getSignatureValueId(string2));
        this.signContext = new DOMSignContext(privateKey, (Node)this.baseElement);
        this.signContext.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", this.xades.getXmlSignaturePrefix());
        this.signContext.putNamespacePrefix(this.xadesNamespace, this.xades.getXadesPrefix());
        try {
            this.signContext.setURIDereferencer((URIDereferencer)new CustomUriDereferencer());
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, "No se ha podido instalar un dereferenciador a medida, es posible que fallen las firmas de nodos concretos: " + exception, exception);
        }
        this.signature.sign(this.signContext);
    }

    public static AOXMLAdvancedSignature newInstance(XAdES_BES xAdES_BES) throws GeneralSecurityException {
        AOXMLAdvancedSignature aOXMLAdvancedSignature = new AOXMLAdvancedSignature(xAdES_BES);
        aOXMLAdvancedSignature.setDigestMethod(xAdES_BES.getDigestMethod());
        aOXMLAdvancedSignature.setXadesNamespace(xAdES_BES.getXadesNamespace());
        return aOXMLAdvancedSignature;
    }
}

