/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.signers.xades.XAdESUtil;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignaturePolicyIdentifier;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignaturePolicyIdentifierImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignatureProductionPlace;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignatureProductionPlaceImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignerRole;
import es.uji.crypto.xades.jxades.security.xml.XAdES.SignerRoleImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_EPES;
import java.security.NoSuchAlgorithmException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.ietf.jgss.Oid;

final class XAdESCommonMetadataUtil {
    private XAdESCommonMetadataUtil() {
    }

    static void addCommonMetadata(XAdES_EPES xAdES_EPES, Properties properties) throws AOException {
        SignerRole signerRole;
        SignatureProductionPlace signatureProductionPlace;
        SignaturePolicyIdentifier signaturePolicyIdentifier;
        try {
            signaturePolicyIdentifier = XAdESCommonMetadataUtil.getPolicy(properties);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AOException("El algoritmo indicado para la politica (" + properties.getProperty("policyIdentifierHashAlgorithm") + ") no esta soportado: " + noSuchAlgorithmException, (Throwable)noSuchAlgorithmException);
        }
        if (signaturePolicyIdentifier != null) {
            xAdES_EPES.setSignaturePolicyIdentifier(signaturePolicyIdentifier);
        }
        if ((signatureProductionPlace = XAdESCommonMetadataUtil.getSignatureProductionPlace(properties)) != null) {
            xAdES_EPES.setSignatureProductionPlace(signatureProductionPlace);
        }
        if ((signerRole = XAdESCommonMetadataUtil.parseSignerRole(properties)) != null) {
            xAdES_EPES.setSignerRole(signerRole);
        }
    }

    private static SignerRole parseSignerRole(Properties properties) {
        if (properties == null) {
            return null;
        }
        SignerRoleImpl signerRoleImpl = null;
        try {
            String string = properties.getProperty("signerClaimedRoles");
            signerRoleImpl = new SignerRoleImpl();
            if (string != null) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(Pattern.quote("|"))) {
                    signerRoleImpl.addClaimedRole(string2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return signerRoleImpl;
    }

    private static SignatureProductionPlace getSignatureProductionPlace(Properties properties) {
        if (properties == null) {
            return null;
        }
        return XAdESCommonMetadataUtil.getSignatureProductionPlace(properties.getProperty("signatureProductionCity"), properties.getProperty("signatureProductionProvince"), properties.getProperty("signatureProductionPostalCode"), properties.getProperty("signatureProductionCountry"));
    }

    private static SignatureProductionPlace getSignatureProductionPlace(String string, String string2, String string3, String string4) {
        if (string == null && string2 == null && string3 == null && string4 == null) {
            return null;
        }
        return new SignatureProductionPlaceImpl(string, string2, string3, string4);
    }

    private static SignaturePolicyIdentifier getPolicy(Properties properties) throws NoSuchAlgorithmException {
        if (properties == null) {
            return null;
        }
        return XAdESCommonMetadataUtil.getPolicy(properties.getProperty("policyIdentifier"), properties.getProperty("policyIdentifierHash"), properties.getProperty("policyIdentifierHashAlgorithm"), properties.getProperty("policyDescription"), properties.getProperty("policyQualifier"));
    }

    private static SignaturePolicyIdentifier getPolicy(String string, String string2, String string3, String string4, String string5) throws NoSuchAlgorithmException {
        String string6;
        if (string == null) {
            return null;
        }
        Logger logger = Logger.getLogger("es.gob.afirma");
        try {
            logger.warning("Se proporciono directamente un OID como identificador de politica (" + new Oid(string) + "), se tranformara en URN con el prefijo 'urn:oid:'");
            string6 = "urn:oid:" + string;
        }
        catch (Exception exception) {
            string6 = string;
        }
        String string7 = string3 != null ? XAdESUtil.getDigestMethodByCommonName(string3) : null;
        SignaturePolicyIdentifierImpl signaturePolicyIdentifierImpl = new SignaturePolicyIdentifierImpl(false);
        try {
            signaturePolicyIdentifierImpl.setIdentifier(string6, string7 != null ? string2 : null, string7);
        }
        catch (Exception exception) {
            logger.warning("No se ha podido acceder al identificador ('" + string6 + "') de la politica de firma, no se anadira este campo: " + exception);
            return null;
        }
        String string8 = string4 != null ? string4 : "";
        signaturePolicyIdentifierImpl.setDescription(string8);
        if (string5 != null) {
            signaturePolicyIdentifierImpl.setQualifier(string5);
        }
        return signaturePolicyIdentifierImpl;
    }
}

