/*
 * Decompiled with CFR 0.152.
 */
package es.gob.afirma.signers.xades;

import es.gob.afirma.core.AOException;
import es.gob.afirma.core.signers.AOSignConstants;
import es.gob.afirma.signers.xades.AOXMLAdvancedSignature;
import es.gob.afirma.signers.xades.XAdESExtraParams;
import es.gob.afirma.signers.xml.Utils;
import es.uji.crypto.xades.jxades.security.xml.XAdES.CommitmentTypeId;
import es.uji.crypto.xades.jxades.security.xml.XAdES.CommitmentTypeIdImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.CommitmentTypeIndication;
import es.uji.crypto.xades.jxades.security.xml.XAdES.CommitmentTypeIndicationImpl;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_BES;
import es.uji.crypto.xades.jxades.security.xml.XAdES.XAdES_EPES;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XAdESUtil {
    private static final Logger LOGGER = Logger.getLogger("es.gob.afirma");
    private static final String[] SUPPORTED_XADES_NAMESPACE_URIS = new String[]{"http://uri.etsi.org/01903#", "http://uri.etsi.org/01903/v1.2.2#", "http://uri.etsi.org/01903/v1.3.2#", "http://uri.etsi.org/01903/v1.4.1#"};

    private XAdESUtil() {
    }

    static boolean checkSignNodes(List<Node> list) {
        for (Node node : list) {
            int n = 0;
            for (String string : SUPPORTED_XADES_NAMESPACE_URIS) {
                n += ((Element)node).getElementsByTagNameNS(string, "QualifyingProperties").getLength();
            }
            if (n != 0) continue;
            return false;
        }
        return true;
    }

    static AOXMLAdvancedSignature getXmlAdvancedSignature(XAdES_EPES xAdES_EPES, String string, String string2, String string3) throws AOException {
        AOXMLAdvancedSignature aOXMLAdvancedSignature;
        try {
            aOXMLAdvancedSignature = AOXMLAdvancedSignature.newInstance((XAdES_BES)xAdES_EPES);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido instanciar la firma XML Avanzada de JXAdES: " + exception, (Throwable)exception);
        }
        aOXMLAdvancedSignature.setSignedPropertiesTypeUrl(string);
        try {
            aOXMLAdvancedSignature.setDigestMethod(string2);
        }
        catch (Exception exception) {
            throw new AOException("No se ha podido establecer el algoritmo de huella digital: " + exception, (Throwable)exception);
        }
        aOXMLAdvancedSignature.setCanonicalizationMethod(string3);
        return aOXMLAdvancedSignature;
    }

    static Element getFirstElmentFromXPath(String string, Element element) throws AOException {
        NodeList nodeList;
        try {
            nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate(string, element, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new AOException("No se ha podido evaluar la expresion indicada para la insercion de la firma Enveloped ('" + string + "'): " + xPathExpressionException, (Throwable)xPathExpressionException);
        }
        if (nodeList.getLength() < 1) {
            throw new AOException("La expresion indicada para la insercion de la firma Enveloped ('" + string + "') no ha devuelto ningun nodo");
        }
        if (nodeList.getLength() > 1) {
            LOGGER.warning("La expresion indicada para la insercion de la firma Enveloped ('" + string + "') ha devuelto varios nodos, se usara el primero");
        }
        return (Element)nodeList.item(0);
    }

    public static List<CommitmentTypeIndication> parseCommitmentTypeIndications(Properties properties, String string) {
        int n;
        ArrayList<CommitmentTypeIndication> arrayList = new ArrayList<CommitmentTypeIndication>();
        if (properties == null) {
            return arrayList;
        }
        String string2 = properties.getProperty("commitmentTypeIndications");
        if (string2 == null) {
            return arrayList;
        }
        try {
            n = Integer.parseInt(string2);
            if (n < 1) {
                throw new NumberFormatException();
            }
        }
        catch (Exception exception) {
            LOGGER.severe("El parametro adicional 'CommitmentTypeIndications' debe contener un valor numerico entero (el valor actual es " + string2 + "), no se anadira el CommitmentTypeIndication: " + exception);
            return arrayList;
        }
        for (int i = 0; i <= n; ++i) {
            ArrayList<String> arrayList2;
            String[] stringArray;
            ArrayList<String> arrayList3;
            string2 = properties.getProperty("commitmentTypeIndication" + Integer.toString(i) + "Identifier");
            if (string2 == null) continue;
            String string3 = XAdESExtraParams.COMMITMENT_TYPE_IDENTIFIERS.get(string2);
            if (string3 == null) {
                LOGGER.severe("El identificador del CommitmentTypeIndication " + i + " no es un tipo soportado (" + string2 + "), se omitira y se continuara con el siguiente");
                continue;
            }
            String string4 = properties.getProperty("commitmentTypeIndication" + Integer.toString(i) + "Description");
            string2 = properties.getProperty("commitmentTypeIndication" + Integer.toString(i) + "DocumentationReferences");
            if (string2 == null) {
                arrayList3 = new ArrayList(0);
            } else {
                arrayList3 = new ArrayList<String>();
                for (String string5 : stringArray = string2.split(Pattern.quote("|"))) {
                    try {
                        arrayList3.add(new URL(string5).toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        LOGGER.severe("La referencia documental '" + string5 + "' del CommitmentTypeIndication " + i + " no es una URL, se omitira y se continuara con la siguiente referencia documental: " + malformedURLException);
                    }
                }
            }
            string2 = properties.getProperty("commitmentTypeIndication" + Integer.toString(i) + "CommitmentTypeQualifiers");
            if (string2 == null) {
                arrayList2 = new ArrayList(0);
            } else {
                arrayList2 = new ArrayList<String>();
                for (String string5 : stringArray = string2.split(Pattern.quote("|"))) {
                    arrayList2.add(string5);
                }
            }
            arrayList.add((CommitmentTypeIndication)new CommitmentTypeIndicationImpl((CommitmentTypeId)new CommitmentTypeIdImpl(string3.startsWith("urn:oid:") ? "OIDAsURN" : null, string3, string4, arrayList3), string != null ? "#" + string : null, arrayList2));
        }
        return arrayList;
    }

    static String getDigestMethodByCommonName(String string) throws NoSuchAlgorithmException {
        String string2 = AOSignConstants.getDigestAlgorithmName((String)string);
        if ("SHA1".equalsIgnoreCase(string2)) {
            return "http://www.w3.org/2000/09/xmldsig#sha1";
        }
        if ("SHA-256".equalsIgnoreCase(string2)) {
            return "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        if ("SHA-512".equalsIgnoreCase(string2)) {
            return "http://www.w3.org/2001/04/xmlenc#sha512";
        }
        throw new NoSuchAlgorithmException("No se soporta el algoritmo: " + string2);
    }

    static Element getRootElement(Document document, Properties properties) {
        Element element;
        Properties properties2 = properties != null ? properties : new Properties();
        String string = properties2.getProperty("RootXmlNodeName", "AFIRMA");
        String string2 = properties2.getProperty("RootXmlNodeNamespace");
        String string3 = properties2.getProperty("RootXmlNodeNamespacePrefix");
        if (string2 == null) {
            element = document.createElement(string);
        } else {
            element = document.createElementNS(string2, string);
            if (string3 != null) {
                element.setAttribute(string3.startsWith("xmlns:") ? string3 : "xmlns:" + string3, string2);
            }
        }
        element.setAttributeNS(null, "Id", string + "-Root-" + UUID.randomUUID().toString());
        return element;
    }

    static List<Reference> createManifest(List<Reference> list, XMLSignatureFactory xMLSignatureFactory, AOXMLAdvancedSignature aOXMLAdvancedSignature, DigestMethod digestMethod, Transform transform, String string) {
        LinkedList<Manifest> linkedList = new LinkedList<Manifest>();
        String string2 = "Manifest-" + UUID.randomUUID().toString();
        linkedList.add(xMLSignatureFactory.newManifest(new ArrayList<Reference>(list), string2));
        String string3 = "ManifestObject-" + UUID.nameUUIDFromBytes(string.getBytes()).toString();
        aOXMLAdvancedSignature.addXMLObject(xMLSignatureFactory.newXMLObject(linkedList, string3, null, null));
        list.clear();
        list.add(xMLSignatureFactory.newReference("#" + string2, digestMethod, transform != null ? Collections.singletonList(transform) : new ArrayList(0), "http://www.w3.org/2000/09/xmldsig#Manifest", "Manifest" + string));
        return list;
    }

    static Map<String, String> getOriginalXMLProperties(Document document, String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (document != null) {
            DocumentType documentType;
            if (string != null) {
                hashtable.put("encoding", string);
            } else if (document.getXmlEncoding() != null) {
                hashtable.put("encoding", document.getXmlEncoding());
            }
            String string2 = document.getXmlVersion();
            if (string2 != null) {
                hashtable.put("version", string2);
            }
            if ((documentType = document.getDoctype()) != null && (string2 = documentType.getSystemId()) != null) {
                hashtable.put("doctype-system", string2);
            }
        }
        return hashtable;
    }

    static String guessXAdESNamespacePrefix(Element element) {
        String string = new String(Utils.writeXML((Node)element, null, null, null));
        int n = 0;
        String string2 = null;
        while (string2 == null && (n = string.indexOf(" xmlns:", n)) != -1) {
            String string3;
            int n2 = string.indexOf("=", n);
            if (n2 != -1 && "=\"http://uri.etsi.org/".equals(string3 = string.substring(n2, Math.min(n2 + "=\"http://uri.etsi.org/".length(), string.length())))) {
                string2 = string.substring(n + " xmlns:".length(), n2);
            }
            ++n;
        }
        return string2;
    }

    static String guessXAdESNamespaceURL(Node node) {
        String string = new String(Utils.writeXML((Node)node, null, null, null));
        int n = Utils.countSubstring((String)string, (String)"\"http://uri.etsi.org/01903#\"");
        int n2 = Utils.countSubstring((String)string, (String)"\"http://uri.etsi.org/01903/v1.2.2#\"");
        int n3 = Utils.countSubstring((String)string, (String)"\"http://uri.etsi.org/01903/v1.3.2#\"");
        int n4 = Utils.countSubstring((String)string, (String)"\"http://uri.etsi.org/01903/v1.4.1#\"");
        if (n3 >= n && n3 >= n4 && n3 >= n2) {
            return "\"http://uri.etsi.org/01903/v1.3.2#\"".replace("\"", "");
        }
        if (n >= n3 && n >= n4 && n >= n2) {
            return "\"http://uri.etsi.org/01903#\"".replace("\"", "");
        }
        if (n4 >= n && n4 >= n3 && n4 >= n2) {
            return "\"http://uri.etsi.org/01903/v1.4.1#\"".replace("\"", "");
        }
        if (n2 >= n3 && n2 >= n && n2 >= n4) {
            return "\"http://uri.etsi.org/01903/v1.2.2#\"".replace("\"", "");
        }
        return "\"http://uri.etsi.org/01903/v1.3.2#\"".replace("\"", "");
    }
}

