/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.ExceptionConverter;
import com.aowagie.text.pdf.TSAClient;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Set;
import org.spongycastle.asn1.ASN1Encodable;
import org.spongycastle.asn1.ASN1EncodableVector;
import org.spongycastle.asn1.ASN1Enumerated;
import org.spongycastle.asn1.ASN1InputStream;
import org.spongycastle.asn1.ASN1Integer;
import org.spongycastle.asn1.ASN1ObjectIdentifier;
import org.spongycastle.asn1.ASN1OctetString;
import org.spongycastle.asn1.ASN1OutputStream;
import org.spongycastle.asn1.ASN1Primitive;
import org.spongycastle.asn1.ASN1Sequence;
import org.spongycastle.asn1.ASN1Set;
import org.spongycastle.asn1.ASN1String;
import org.spongycastle.asn1.ASN1TaggedObject;
import org.spongycastle.asn1.BERTaggedObject;
import org.spongycastle.asn1.DERNull;
import org.spongycastle.asn1.DEROctetString;
import org.spongycastle.asn1.DERSequence;
import org.spongycastle.asn1.DERSet;
import org.spongycastle.asn1.DERTaggedObject;
import org.spongycastle.asn1.DERUTCTime;
import org.spongycastle.asn1.cms.Attribute;
import org.spongycastle.asn1.cms.AttributeTable;
import org.spongycastle.asn1.cms.ContentInfo;
import org.spongycastle.asn1.ocsp.BasicOCSPResponse;
import org.spongycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.spongycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.spongycastle.cert.X509CertificateHolder;
import org.spongycastle.cert.ocsp.BasicOCSPResp;
import org.spongycastle.cert.ocsp.CertificateID;
import org.spongycastle.cert.ocsp.SingleResp;
import org.spongycastle.jce.provider.X509CRLParser;
import org.spongycastle.jce.provider.X509CertParser;
import org.spongycastle.operator.bc.BcDigestCalculatorProvider;
import org.spongycastle.tsp.TimeStampToken;

public final class PdfPKCS7 {
    private byte[] sigAttr;
    private byte[] digestAttr;
    private int version;
    private int signerversion;
    private Set<String> digestalgos;
    private Collection<Certificate> certs;
    private Collection<CRL> crls;
    private Collection<Certificate> signCerts;
    private X509Certificate signCert;
    private byte[] digest;
    private MessageDigest messageDigest;
    private String digestAlgorithm;
    private String digestEncryptionAlgorithm;
    private Signature sig;
    private byte[] RSAdata;
    private boolean verified;
    private boolean verifyResult;
    private byte[] externalDigest;
    private byte[] externalRSAdata;
    private String provider;
    private static final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    private static final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    private static final String ID_RSA = "1.2.840.113549.1.1.1";
    private static final String ID_DSA = "1.2.840.10040.4.1";
    private static final String ID_CONTENT_TYPE = "1.2.840.113549.1.9.3";
    private static final String ID_MESSAGE_DIGEST = "1.2.840.113549.1.9.4";
    private static final String ID_SIGNING_TIME = "1.2.840.113549.1.9.5";
    private static final String ID_ADBE_REVOCATION = "1.2.840.113583.1.1.8";
    private String reason;
    private String location;
    private Calendar signDate;
    private String signName;
    private TimeStampToken timeStampToken;
    private static final HashMap<String, String> DIGEST_NAMES = new LinkedHashMap<String, String>();
    private static final HashMap<String, String> ALGORITHM_NAMES = new LinkedHashMap<String, String>();
    private static final HashMap<String, String> ALLOWED_DIGESTS = new LinkedHashMap<String, String>();
    private BasicOCSPResp basicResp;
    private static final String OID_ECDSA_SHA1 = "1.2.840.10045.4.1";
    private static final String OID_ECDSA_SHA224 = "1.2.840.10045.4.3.1";
    private static final String OID_ECDSA_SHA256 = "1.2.840.10045.4.3.2";
    private static final String OID_ECDSA_SHA384 = "1.2.840.10045.4.3.3";
    private static final String OID_ECDSA_SHA512 = "1.2.840.10045.4.3.4";
    private static final String OID_RSA_SHA3_224 = "2.16.840.1.101.3.4.3.13";
    private static final String OID_RSA_SHA3_256 = "2.16.840.1.101.3.4.3.14";
    private static final String OID_RSA_SHA3_384 = "2.16.840.1.101.3.4.3.15";
    private static final String OID_RSA_SHA3_512 = "2.16.840.1.101.3.4.3.16";
    private static final String OID_ECDSA_SHA3_224 = "2.16.840.1.101.3.4.3.9";
    private static final String OID_ECDSA_SHA3_256 = "2.16.840.1.101.3.4.3.10";
    private static final String OID_ECDSA_SHA3_384 = "2.16.840.1.101.3.4.3.11";
    private static final String OID_ECDSA_SHA3_512 = "2.16.840.1.101.3.4.3.12";
    private static final Dictionary<String, String> OIDS;

    public byte[] getPkcs1() {
        return this.digest != null ? (byte[])this.digest.clone() : null;
    }

    private static String getDigest(String oid) {
        String ret = DIGEST_NAMES.get(oid);
        if (ret == null) {
            return oid;
        }
        return ret;
    }

    private static String getAlgorithm(String oid) {
        String ret = ALGORITHM_NAMES.get(oid);
        if (ret == null) {
            return oid;
        }
        return ret;
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public Calendar getTimeStampDate() {
        if (this.timeStampToken == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        Date date = this.timeStampToken.getTimeStampInfo().getGenTime();
        cal.setTime(date);
        return cal;
    }

    PdfPKCS7(byte[] contentsKey, byte[] certsKey, String provider) {
        try {
            this.provider = provider;
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.certs = cf.generateCertificates(new ByteArrayInputStream(certsKey));
            this.signCerts = this.certs;
            this.signCert = (X509Certificate)this.certs.iterator().next();
            this.crls = new ArrayList<CRL>();
            ASN1InputStream in = new ASN1InputStream((InputStream)new ByteArrayInputStream(contentsKey));
            this.digest = ((DEROctetString)in.readObject()).getOctets();
            this.sig = provider == null ? Signature.getInstance("SHA1withRSA") : Signature.getInstance("SHA1withRSA", provider);
            PublicKey publicKey = this.signCert.getPublicKey();
            if (publicKey == null) {
                publicKey = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(this.signCert.getEncoded())).getPublicKey();
            }
            if (publicKey == null) {
                throw new CertificateEncodingException("El certificado no contiene una clave publica adecuada");
            }
            this.sig.initVerify(publicKey);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public BasicOCSPResp getOcsp() {
        return this.basicResp;
    }

    private void findOcsp(ASN1Sequence seq) throws IOException {
        this.basicResp = null;
        boolean ret = false;
        while (!(seq.getObjectAt(0) instanceof ASN1ObjectIdentifier) || !((ASN1ObjectIdentifier)seq.getObjectAt(0)).getId().equals(OCSPObjectIdentifiers.id_pkix_ocsp_basic.getId())) {
            ret = true;
            for (int k = 0; k < seq.size(); ++k) {
                if (seq.getObjectAt(k) instanceof ASN1Sequence) {
                    seq = (ASN1Sequence)seq.getObjectAt(0);
                    ret = false;
                    break;
                }
                if (!(seq.getObjectAt(k) instanceof ASN1TaggedObject)) continue;
                ASN1TaggedObject tag = (ASN1TaggedObject)seq.getObjectAt(k);
                if (tag.getObject() instanceof ASN1Sequence) {
                    seq = (ASN1Sequence)tag.getObject();
                    ret = false;
                    break;
                }
                return;
            }
            if (!ret) continue;
            return;
        }
        DEROctetString os = (DEROctetString)seq.getObjectAt(1);
        ASN1InputStream inp = new ASN1InputStream(os.getOctets());
        BasicOCSPResponse resp = BasicOCSPResponse.getInstance((Object)inp.readObject());
        this.basicResp = new BasicOCSPResp(resp);
    }

    PdfPKCS7(byte[] contentsKey, String provider) {
        try {
            DERTaggedObject taggedObject;
            ASN1Set unat;
            AttributeTable attble;
            Attribute ts;
            ASN1Primitive pkcs;
            this.provider = provider;
            ASN1InputStream din = new ASN1InputStream((InputStream)new ByteArrayInputStream(contentsKey));
            try {
                pkcs = din.readObject();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("can't decode PKCS7SignedData object", e);
            }
            if (!(pkcs instanceof ASN1Sequence)) {
                throw new IllegalArgumentException("Not a valid PKCS#7 object - not a sequence");
            }
            ASN1Sequence signedData = (ASN1Sequence)pkcs;
            ASN1ObjectIdentifier objId = (ASN1ObjectIdentifier)signedData.getObjectAt(0);
            if (!objId.getId().equals(ID_PKCS7_SIGNED_DATA)) {
                throw new IllegalArgumentException("Not a valid PKCS#7 object - not signed data");
            }
            ASN1Sequence content = (ASN1Sequence)((ASN1TaggedObject)signedData.getObjectAt(1)).getObject();
            this.version = ((ASN1Integer)content.getObjectAt(0)).getValue().intValue();
            this.digestalgos = new HashSet<String>();
            Enumeration e = ((ASN1Set)content.getObjectAt(1)).getObjects();
            while (e.hasMoreElements()) {
                ASN1Sequence s = (ASN1Sequence)e.nextElement();
                ASN1ObjectIdentifier o = (ASN1ObjectIdentifier)s.getObjectAt(0);
                this.digestalgos.add(o.getId());
            }
            X509CertParser cr = new X509CertParser();
            cr.engineInit((InputStream)new ByteArrayInputStream(contentsKey));
            this.certs = cr.engineReadAll();
            X509CRLParser cl = new X509CRLParser();
            cl.engineInit((InputStream)new ByteArrayInputStream(contentsKey));
            this.crls = cl.engineReadAll();
            ASN1Sequence rsaData = (ASN1Sequence)content.getObjectAt(2);
            if (rsaData.size() > 1) {
                ASN1OctetString rsaDataContent;
                ASN1Encodable encodable = rsaData.getObjectAt(1);
                if (encodable instanceof DERTaggedObject) {
                    rsaDataContent = (ASN1OctetString)((DERTaggedObject)encodable).getObject();
                } else if (encodable instanceof BERTaggedObject) {
                    rsaDataContent = (ASN1OctetString)((BERTaggedObject)encodable).getObject();
                } else {
                    throw new IllegalArgumentException("El objeto ASN.1 no es ni BER ni BER ni DER: " + encodable.getClass().getName());
                }
                this.RSAdata = rsaDataContent.getOctets();
            }
            int next = 3;
            while (content.getObjectAt(next) instanceof ASN1TaggedObject) {
                ++next;
            }
            ASN1Set signerInfos = (ASN1Set)content.getObjectAt(next);
            if (signerInfos.size() != 1) {
                throw new IllegalArgumentException("This PKCS#7 object has multiple SignerInfos - only one is supported at this time");
            }
            ASN1Sequence signerInfo = (ASN1Sequence)signerInfos.getObjectAt(0);
            this.signerversion = ((ASN1Integer)signerInfo.getObjectAt(0)).getValue().intValue();
            ASN1Sequence issuerAndSerialNumber = (ASN1Sequence)signerInfo.getObjectAt(1);
            BigInteger serialNumber = ((ASN1Integer)issuerAndSerialNumber.getObjectAt(1)).getValue();
            for (Certificate element : this.certs) {
                X509Certificate cert = (X509Certificate)element;
                if (!serialNumber.equals(cert.getSerialNumber())) continue;
                this.signCert = cert;
                break;
            }
            if (this.signCert == null) {
                throw new IllegalArgumentException("Can't find signing certificate with serial " + serialNumber.toString(16));
            }
            this.signCertificateChain();
            this.digestAlgorithm = ((ASN1ObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(2)).getObjectAt(0)).getId();
            next = 3;
            if (signerInfo.getObjectAt(next) instanceof ASN1TaggedObject) {
                ASN1TaggedObject tagsig = (ASN1TaggedObject)signerInfo.getObjectAt(next);
                ASN1Set sseq = ASN1Set.getInstance((ASN1TaggedObject)tagsig, (boolean)false);
                this.sigAttr = sseq.getEncoded();
                for (int k = 0; k < sseq.size(); ++k) {
                    ASN1Sequence seq2 = (ASN1Sequence)sseq.getObjectAt(k);
                    if (((ASN1ObjectIdentifier)seq2.getObjectAt(0)).getId().equals(ID_MESSAGE_DIGEST)) {
                        ASN1Set set = (ASN1Set)seq2.getObjectAt(1);
                        this.digestAttr = ((DEROctetString)set.getObjectAt(0)).getOctets();
                        continue;
                    }
                    if (!((ASN1ObjectIdentifier)seq2.getObjectAt(0)).getId().equals(ID_ADBE_REVOCATION)) continue;
                    ASN1Set setout = (ASN1Set)seq2.getObjectAt(1);
                    ASN1Sequence seqout = (ASN1Sequence)setout.getObjectAt(0);
                    for (int j = 0; j < seqout.size(); ++j) {
                        ASN1TaggedObject tg = (ASN1TaggedObject)seqout.getObjectAt(j);
                        if (tg.getTagNo() != 1) continue;
                        ASN1Sequence seqin = (ASN1Sequence)tg.getObject();
                        this.findOcsp(seqin);
                    }
                }
                if (this.digestAttr == null) {
                    throw new IllegalArgumentException("Authenticated attribute is missing the digest.");
                }
            }
            int n = ++next;
            this.digestEncryptionAlgorithm = ((ASN1ObjectIdentifier)((ASN1Sequence)signerInfo.getObjectAt(n)).getObjectAt(0)).getId();
            int n2 = ++next;
            this.digest = ((DEROctetString)signerInfo.getObjectAt(n2)).getOctets();
            if (++next < signerInfo.size() && signerInfo.getObjectAt(next) instanceof DERTaggedObject && (ts = (attble = new AttributeTable(unat = ASN1Set.getInstance((ASN1TaggedObject)(taggedObject = (DERTaggedObject)signerInfo.getObjectAt(next)), (boolean)false))).get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken)) != null) {
                ASN1Set attributeValues = ts.getAttrValues();
                ASN1Sequence tokenSequence = ASN1Sequence.getInstance((Object)attributeValues.getObjectAt(0));
                ContentInfo contentInfo = ContentInfo.getInstance((Object)tokenSequence);
                this.timeStampToken = new TimeStampToken(contentInfo);
            }
            if (this.RSAdata != null || this.digestAttr != null) {
                this.messageDigest = provider == null || provider.startsWith("SunPKCS11") ? MessageDigest.getInstance(PdfPKCS7.getDigestAlgorithmName(this.getHashAlgorithm())) : MessageDigest.getInstance(PdfPKCS7.getDigestAlgorithmName(this.getHashAlgorithm()), provider);
            }
            this.sig = provider == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), provider);
            PublicKey publicKey = this.signCert.getPublicKey();
            if (publicKey == null) {
                publicKey = CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(this.signCert.getEncoded())).getPublicKey();
            }
            if (publicKey == null) {
                throw new CertificateEncodingException("El certificado no contiene una clave publica adecuada");
            }
            this.sig.initVerify(publicKey);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    PdfPKCS7(PrivateKey privKey, Certificate[] certChain, CRL[] crlList, String hashAlgorithm, String provider, boolean hasRSAdata) throws InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this.provider = provider;
        this.digestAlgorithm = ALLOWED_DIGESTS.get(hashAlgorithm.toUpperCase());
        if (this.digestAlgorithm == null) {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + hashAlgorithm);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList<Certificate>();
        this.crls = new ArrayList<CRL>();
        this.digestalgos = new HashSet<String>();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certChain[0];
        for (Certificate certificate : certChain) {
            this.certs.add(certificate);
        }
        if (crlList != null) {
            for (CRL cRL : crlList) {
                this.crls.add(cRL);
            }
        }
        if (privKey != null) {
            this.digestEncryptionAlgorithm = privKey.getAlgorithm();
            if (this.digestEncryptionAlgorithm.equals("RSA")) {
                this.digestEncryptionAlgorithm = ID_RSA;
            } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
                this.digestEncryptionAlgorithm = ID_DSA;
            } else {
                throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
            }
        }
        if (hasRSAdata) {
            this.RSAdata = new byte[0];
            this.messageDigest = provider == null || provider.startsWith("SunPKCS11") ? MessageDigest.getInstance(this.getHashAlgorithm()) : MessageDigest.getInstance(this.getHashAlgorithm(), provider);
        }
        if (privKey != null) {
            this.sig = provider == null ? Signature.getInstance(this.getDigestAlgorithm()) : Signature.getInstance(this.getDigestAlgorithm(), provider);
            this.sig.initSign(privKey);
        }
    }

    void update(byte[] buf, int off, int len) throws SignatureException {
        if (this.RSAdata != null || this.digestAttr != null) {
            this.messageDigest.update(buf, off, len);
        } else {
            this.sig.update(buf, off, len);
        }
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[this.certs.size()]);
    }

    public Certificate[] getSignCertificateChain() {
        return this.signCerts.toArray(new X509Certificate[this.signCerts.size()]);
    }

    private void signCertificateChain() {
        ArrayList<Certificate> cc = new ArrayList<Certificate>();
        cc.add(this.signCert);
        ArrayList<Certificate> oc = new ArrayList<Certificate>(this.certs);
        for (int k = 0; k < oc.size(); ++k) {
            if (!this.signCert.getSerialNumber().equals(((X509Certificate)oc.get(k)).getSerialNumber())) continue;
            oc.remove(k);
            --k;
        }
        boolean found = true;
        block3: while (found) {
            X509Certificate v = (X509Certificate)cc.get(cc.size() - 1);
            found = false;
            for (int k = 0; k < oc.size(); ++k) {
                try {
                    if (this.provider == null) {
                        v.verify(((X509Certificate)oc.get(k)).getPublicKey());
                    } else {
                        v.verify(((X509Certificate)oc.get(k)).getPublicKey(), this.provider);
                    }
                    found = true;
                    cc.add(oc.get(k));
                    oc.remove(k);
                    continue block3;
                }
                catch (Exception exception) {
                    continue;
                }
            }
        }
        this.signCerts = cc;
    }

    public Collection<CRL> getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public String getDigestAlgorithm() {
        String algo;
        if (this.digestEncryptionAlgorithm == null) {
            return null;
        }
        String dea = PdfPKCS7.getAlgorithm(this.digestEncryptionAlgorithm);
        if (dea == null) {
            dea = this.digestEncryptionAlgorithm;
        }
        return (algo = OIDS.get(dea)) != null ? algo : this.getHashAlgorithm() + "with" + dea;
    }

    public String getHashAlgorithm() {
        return PdfPKCS7.getDigest(this.digestAlgorithm);
    }

    public boolean isRevocationValid() {
        if (this.basicResp == null) {
            return false;
        }
        if (this.signCerts.size() < 2) {
            return false;
        }
        try {
            X509Certificate[] cs = (X509Certificate[])this.getSignCertificateChain();
            SingleResp sr = this.basicResp.getResponses()[0];
            CertificateID cid = sr.getCertID();
            X509Certificate sigcer = this.getSigningCertificate();
            X509Certificate isscer = cs[1];
            CertificateID tis = new CertificateID(new BcDigestCalculatorProvider().get(CertificateID.HASH_SHA1), new X509CertificateHolder(isscer.getEncoded()), sigcer.getSerialNumber());
            return tis.equals((Object)cid);
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ASN1Primitive getIssuer(byte[] enc) {
        try (ASN1InputStream in = new ASN1InputStream((InputStream)new ByteArrayInputStream(enc));){
            ASN1Sequence seq = (ASN1Sequence)in.readObject();
            ASN1Primitive aSN1Primitive = (ASN1Primitive)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
            return aSN1Primitive;
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    private static ASN1Primitive getSubject(byte[] enc) {
        try {
            ASN1InputStream in = new ASN1InputStream((InputStream)new ByteArrayInputStream(enc));
            ASN1Sequence seq = (ASN1Sequence)in.readObject();
            return (ASN1Primitive)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 5 : 4);
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    public static X509Name getSubjectFields(X509Certificate cert) {
        try {
            return new X509Name((ASN1Sequence)PdfPKCS7.getSubject(cert.getTBSCertificate()));
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public byte[] getEncodedPKCS1() {
        try {
            this.digest = this.externalDigest != null ? this.externalDigest : this.sig.sign();
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream dout = new ASN1OutputStream((OutputStream)bOut);
            dout.writeObject((ASN1Encodable)new DEROctetString(this.digest));
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public void setExternalDigest(byte[] digest, byte[] RSAdata, String digestEncryptionAlgorithm) {
        this.externalDigest = digest;
        this.externalRSAdata = RSAdata;
        if (digestEncryptionAlgorithm != null) {
            if (digestEncryptionAlgorithm.equals("RSA")) {
                this.digestEncryptionAlgorithm = ID_RSA;
            } else if (digestEncryptionAlgorithm.equals("DSA")) {
                this.digestEncryptionAlgorithm = ID_DSA;
            } else {
                throw new ExceptionConverter(new NoSuchAlgorithmException("Unknown Key Algorithm " + digestEncryptionAlgorithm));
            }
        }
    }

    public byte[] getEncodedPKCS7() {
        return this.getEncodedPKCS7(null, null, null, null);
    }

    private byte[] getEncodedPKCS7(byte[] secondDigest, Calendar signingTime, TSAClient tsaClient, byte[] ocsp) {
        try {
            ASN1EncodableVector unauthAttributes;
            byte[] tsImprint;
            Object tsToken;
            if (this.externalDigest != null) {
                this.digest = this.externalDigest;
                if (this.RSAdata != null) {
                    this.RSAdata = this.externalRSAdata;
                }
            } else if (this.externalRSAdata != null && this.RSAdata != null) {
                this.RSAdata = this.externalRSAdata;
                this.sig.update(this.RSAdata);
                try {
                    this.digest = this.sig.sign();
                }
                catch (Exception exception) {}
            } else {
                if (this.RSAdata != null) {
                    this.RSAdata = this.messageDigest.digest();
                    this.sig.update(this.RSAdata);
                }
                try {
                    this.digest = this.sig.sign();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ASN1EncodableVector digestAlgorithms = new ASN1EncodableVector();
            for (String string : this.digestalgos) {
                ASN1EncodableVector algos = new ASN1EncodableVector();
                algos.add((ASN1Encodable)new ASN1ObjectIdentifier(string));
                algos.add((ASN1Encodable)DERNull.INSTANCE);
                digestAlgorithms.add((ASN1Encodable)new DERSequence(algos));
            }
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_PKCS7_DATA));
            if (this.RSAdata != null) {
                v.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DEROctetString(this.RSAdata)));
            }
            DERSequence contentinfo = new DERSequence(v);
            v = new ASN1EncodableVector();
            for (Object e : this.certs) {
                ASN1InputStream tempstream = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509Certificate)e).getEncoded()));
                v.add((ASN1Encodable)tempstream.readObject());
            }
            DERSet dercertificates = new DERSet(v);
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            aSN1EncodableVector.add((ASN1Encodable)new ASN1Integer((long)this.signerversion));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)PdfPKCS7.getIssuer(this.signCert.getTBSCertificate()));
            v.add((ASN1Encodable)new ASN1Integer(this.signCert.getSerialNumber()));
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(this.digestAlgorithm));
            v.add((ASN1Encodable)DERNull.INSTANCE);
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(v));
            if (secondDigest != null && signingTime != null) {
                aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)this.getAuthenticatedAttributeSet(secondDigest, signingTime, ocsp)));
            }
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(this.digestEncryptionAlgorithm));
            v.add((ASN1Encodable)DERNull.INSTANCE);
            aSN1EncodableVector.add((ASN1Encodable)new DERSequence(v));
            aSN1EncodableVector.add((ASN1Encodable)new DEROctetString(this.digest));
            if (tsaClient != null && (tsToken = tsaClient.getTimeStampToken(this, tsImprint = MessageDigest.getInstance("SHA-1").digest(this.digest))) != null && (unauthAttributes = PdfPKCS7.buildUnauthenticatedAttributes((byte[])tsToken)) != null) {
                aSN1EncodableVector.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)new DERSet(unauthAttributes)));
            }
            ASN1EncodableVector body = new ASN1EncodableVector();
            body.add((ASN1Encodable)new ASN1Integer((long)this.version));
            body.add((ASN1Encodable)new DERSet(digestAlgorithms));
            body.add((ASN1Encodable)contentinfo);
            body.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)dercertificates));
            if (!this.crls.isEmpty()) {
                v = new ASN1EncodableVector();
                tsToken = this.crls.iterator();
                while (tsToken.hasNext()) {
                    Object element = tsToken.next();
                    ASN1InputStream t = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509CRL)element).getEncoded()));
                    v.add((ASN1Encodable)t.readObject());
                }
                DERSet dercrls = new DERSet(v);
                body.add((ASN1Encodable)new DERTaggedObject(false, 1, (ASN1Encodable)dercrls));
            }
            body.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence(aSN1EncodableVector)));
            ASN1EncodableVector whole = new ASN1EncodableVector();
            whole.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_PKCS7_SIGNED_DATA));
            whole.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DERSequence(body)));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream dout = new ASN1OutputStream((OutputStream)bOut);
            dout.writeObject((ASN1Encodable)new DERSequence(whole));
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    private static ASN1EncodableVector buildUnauthenticatedAttributes(byte[] timeStampToken) throws IOException {
        if (timeStampToken == null) {
            return null;
        }
        String ID_TIME_STAMP_TOKEN = "1.2.840.113549.1.9.16.2.14";
        ASN1InputStream tempstream = new ASN1InputStream((InputStream)new ByteArrayInputStream(timeStampToken));
        ASN1EncodableVector unauthAttributes = new ASN1EncodableVector();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1ObjectIdentifier("1.2.840.113549.1.9.16.2.14"));
        ASN1Sequence seq = (ASN1Sequence)tempstream.readObject();
        v.add((ASN1Encodable)new DERSet((ASN1Encodable)seq));
        unauthAttributes.add((ASN1Encodable)new DERSequence(v));
        return unauthAttributes;
    }

    private DERSet getAuthenticatedAttributeSet(byte[] secondDigest, Calendar signingTime, byte[] ocsp) {
        try {
            ASN1EncodableVector attribute = new ASN1EncodableVector();
            ASN1EncodableVector v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_CONTENT_TYPE));
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)new ASN1ObjectIdentifier(ID_PKCS7_DATA)));
            attribute.add((ASN1Encodable)new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_SIGNING_TIME));
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERUTCTime(signingTime.getTime())));
            attribute.add((ASN1Encodable)new DERSequence(v));
            v = new ASN1EncodableVector();
            v.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_MESSAGE_DIGEST));
            v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DEROctetString(secondDigest)));
            attribute.add((ASN1Encodable)new DERSequence(v));
            if (ocsp != null) {
                v = new ASN1EncodableVector();
                v.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_ADBE_REVOCATION));
                DEROctetString doctet = new DEROctetString(ocsp);
                ASN1EncodableVector vo1 = new ASN1EncodableVector();
                ASN1EncodableVector v2 = new ASN1EncodableVector();
                v2.add((ASN1Encodable)OCSPObjectIdentifiers.id_pkix_ocsp_basic);
                v2.add((ASN1Encodable)doctet);
                ASN1Enumerated den = new ASN1Enumerated(0);
                ASN1EncodableVector v3 = new ASN1EncodableVector();
                v3.add((ASN1Encodable)den);
                v3.add((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(v2)));
                vo1.add((ASN1Encodable)new DERSequence(v3));
                v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence((ASN1Encodable)new DERTaggedObject(true, 1, (ASN1Encodable)new DERSequence(vo1)))));
                attribute.add((ASN1Encodable)new DERSequence(v));
            } else if (!this.crls.isEmpty()) {
                v = new ASN1EncodableVector();
                v.add((ASN1Encodable)new ASN1ObjectIdentifier(ID_ADBE_REVOCATION));
                ASN1EncodableVector v2 = new ASN1EncodableVector();
                for (CRL element : this.crls) {
                    ASN1InputStream t = new ASN1InputStream((InputStream)new ByteArrayInputStream(((X509CRL)element).getEncoded()));
                    v2.add((ASN1Encodable)t.readObject());
                }
                v.add((ASN1Encodable)new DERSet((ASN1Encodable)new DERSequence((ASN1Encodable)new DERTaggedObject(true, 0, (ASN1Encodable)new DERSequence(v2)))));
                attribute.add((ASN1Encodable)new DERSequence(v));
            }
            return new DERSet(attribute);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Calendar getSignDate() {
        return this.signDate;
    }

    public void setSignDate(Calendar signDate) {
        this.signDate = signDate;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    private static String getDigestAlgorithmName(String pseudoName) {
        String upperPseudoName = pseudoName.toUpperCase();
        if (upperPseudoName.equals("SHA") || upperPseudoName.equals("http://www.w3.org/2000/09/xmldsig#sha1".toUpperCase()) || upperPseudoName.equals("1.3.14.3.2.26") || upperPseudoName.startsWith("SHA1") || upperPseudoName.startsWith("SHA-1")) {
            return "SHA1";
        }
        if (upperPseudoName.equals("http://www.w3.org/2001/04/xmlenc#sha256".toUpperCase()) || upperPseudoName.equals("2.16.840.1.101.3.4.2.1") || upperPseudoName.startsWith("SHA256") || upperPseudoName.startsWith("SHA-256")) {
            return "SHA-256";
        }
        if (upperPseudoName.startsWith("SHA384") || upperPseudoName.equals("2.16.840.1.101.3.4.2.2") || upperPseudoName.startsWith("SHA-384")) {
            return "SHA-384";
        }
        if (upperPseudoName.equals("http://www.w3.org/2001/04/xmlenc#sha512".toUpperCase()) || upperPseudoName.equals("2.16.840.1.101.3.4.2.3") || upperPseudoName.startsWith("SHA512") || upperPseudoName.startsWith("SHA-512")) {
            return "SHA-512";
        }
        if (upperPseudoName.equals("http://www.w3.org/2001/04/xmlenc#ripemd160".toUpperCase()) || upperPseudoName.startsWith("RIPEMD160") || upperPseudoName.startsWith("RIPEMD-160")) {
            return "RIPEMD160";
        }
        if (upperPseudoName.equals("MD5") || upperPseudoName.equals("1.2.840.113549.2.5") || upperPseudoName.startsWith("MD5")) {
            return "MD5";
        }
        if (upperPseudoName.equals("MD2") || upperPseudoName.equals("1.2.840.113549.2.2") || upperPseudoName.startsWith("MD2")) {
            return "MD2";
        }
        throw new IllegalArgumentException("Algoritmo de huella digital no soportado: " + pseudoName);
    }

    public boolean verify() throws SignatureException {
        if (this.verified) {
            return this.verifyResult;
        }
        if (this.sigAttr != null) {
            this.sig.update(this.sigAttr);
            if (this.RSAdata != null) {
                byte[] msd = this.messageDigest.digest();
                this.messageDigest.update(msd);
            }
            this.verifyResult = Arrays.equals(this.messageDigest.digest(), this.digestAttr) && this.sig.verify(this.digest);
        } else {
            if (this.RSAdata != null) {
                this.sig.update(this.messageDigest.digest());
            }
            this.verifyResult = this.sig.verify(this.digest);
        }
        this.verified = true;
        return this.verifyResult;
    }

    static {
        DIGEST_NAMES.put("1.2.840.113549.2.5", "MD5");
        DIGEST_NAMES.put("1.2.840.113549.2.2", "MD2");
        DIGEST_NAMES.put("1.3.14.3.2.26", "SHA1");
        DIGEST_NAMES.put("2.16.840.1.101.3.4.2.4", "SHA224");
        DIGEST_NAMES.put("2.16.840.1.101.3.4.2.1", "SHA256");
        DIGEST_NAMES.put("2.16.840.1.101.3.4.2.2", "SHA384");
        DIGEST_NAMES.put("2.16.840.1.101.3.4.2.3", "SHA512");
        DIGEST_NAMES.put("1.3.36.3.2.2", "RIPEMD128");
        DIGEST_NAMES.put("1.3.36.3.2.1", "RIPEMD160");
        DIGEST_NAMES.put("1.3.36.3.2.3", "RIPEMD256");
        DIGEST_NAMES.put("1.2.840.113549.1.1.4", "MD5");
        DIGEST_NAMES.put("1.2.840.113549.1.1.2", "MD2");
        DIGEST_NAMES.put("1.2.840.113549.1.1.5", "SHA1");
        DIGEST_NAMES.put("1.2.840.113549.1.1.14", "SHA224");
        DIGEST_NAMES.put("1.2.840.113549.1.1.11", "SHA256");
        DIGEST_NAMES.put("1.2.840.113549.1.1.12", "SHA384");
        DIGEST_NAMES.put("1.2.840.113549.1.1.13", "SHA512");
        DIGEST_NAMES.put("1.2.840.113549.2.5", "MD5");
        DIGEST_NAMES.put("1.2.840.113549.2.2", "MD2");
        DIGEST_NAMES.put("1.2.840.10040.4.3", "SHA1");
        DIGEST_NAMES.put("2.16.840.1.101.3.4.3.1", "SHA224");
        DIGEST_NAMES.put("2.16.840.1.101.3.4.3.2", "SHA256");
        DIGEST_NAMES.put("2.16.840.1.101.3.4.3.3", "SHA384");
        DIGEST_NAMES.put("2.16.840.1.101.3.4.3.4", "SHA512");
        DIGEST_NAMES.put("1.3.36.3.3.1.3", "RIPEMD128");
        DIGEST_NAMES.put("1.3.36.3.3.1.2", "RIPEMD160");
        DIGEST_NAMES.put("1.3.36.3.3.1.4", "RIPEMD256");
        ALGORITHM_NAMES.put(ID_RSA, "RSA");
        ALGORITHM_NAMES.put(ID_DSA, "DSA");
        ALGORITHM_NAMES.put("1.2.840.113549.1.1.2", "RSA");
        ALGORITHM_NAMES.put("1.2.840.113549.1.1.4", "RSA");
        ALGORITHM_NAMES.put("1.2.840.113549.1.1.5", "RSA");
        ALGORITHM_NAMES.put("1.2.840.113549.1.1.14", "RSA");
        ALGORITHM_NAMES.put("1.2.840.113549.1.1.11", "RSA");
        ALGORITHM_NAMES.put("1.2.840.113549.1.1.12", "RSA");
        ALGORITHM_NAMES.put("1.2.840.113549.1.1.13", "RSA");
        ALGORITHM_NAMES.put("1.2.840.10040.4.3", "DSA");
        ALGORITHM_NAMES.put("2.16.840.1.101.3.4.3.1", "DSA");
        ALGORITHM_NAMES.put("2.16.840.1.101.3.4.3.2", "DSA");
        ALGORITHM_NAMES.put("1.3.36.3.3.1.3", "RSA");
        ALGORITHM_NAMES.put("1.3.36.3.3.1.2", "RSA");
        ALGORITHM_NAMES.put("1.3.36.3.3.1.4", "RSA");
        ALLOWED_DIGESTS.put("MD5", "1.2.840.113549.2.5");
        ALLOWED_DIGESTS.put("MD2", "1.2.840.113549.2.2");
        ALLOWED_DIGESTS.put("SHA1", "1.3.14.3.2.26");
        ALLOWED_DIGESTS.put("SHA224", "2.16.840.1.101.3.4.2.4");
        ALLOWED_DIGESTS.put("SHA256", "2.16.840.1.101.3.4.2.1");
        ALLOWED_DIGESTS.put("SHA384", "2.16.840.1.101.3.4.2.2");
        ALLOWED_DIGESTS.put("SHA512", "2.16.840.1.101.3.4.2.3");
        ALLOWED_DIGESTS.put("MD-5", "1.2.840.113549.2.5");
        ALLOWED_DIGESTS.put("MD-2", "1.2.840.113549.2.2");
        ALLOWED_DIGESTS.put("SHA-1", "1.3.14.3.2.26");
        ALLOWED_DIGESTS.put("SHA-224", "2.16.840.1.101.3.4.2.4");
        ALLOWED_DIGESTS.put("SHA-256", "2.16.840.1.101.3.4.2.1");
        ALLOWED_DIGESTS.put("SHA-384", "2.16.840.1.101.3.4.2.2");
        ALLOWED_DIGESTS.put("SHA-512", "2.16.840.1.101.3.4.2.3");
        ALLOWED_DIGESTS.put("RIPEMD128", "1.3.36.3.2.2");
        ALLOWED_DIGESTS.put("RIPEMD-128", "1.3.36.3.2.2");
        ALLOWED_DIGESTS.put("RIPEMD160", "1.3.36.3.2.1");
        ALLOWED_DIGESTS.put("RIPEMD-160", "1.3.36.3.2.1");
        ALLOWED_DIGESTS.put("RIPEMD256", "1.3.36.3.2.3");
        ALLOWED_DIGESTS.put("RIPEMD-256", "1.3.36.3.2.3");
        OIDS = new Hashtable<String, String>();
        OIDS.put(OID_ECDSA_SHA1, "SHA1withECDSA");
        OIDS.put(OID_ECDSA_SHA224, "SHA224withECDSA");
        OIDS.put(OID_ECDSA_SHA256, "SHA256withECDSA");
        OIDS.put(OID_ECDSA_SHA384, "SHA384withECDSA");
        OIDS.put(OID_ECDSA_SHA512, "SHA512withECDSA");
        OIDS.put(OID_RSA_SHA3_224, "SHA3-224withRSA");
        OIDS.put(OID_RSA_SHA3_256, "SHA3-256withRSA");
        OIDS.put(OID_RSA_SHA3_384, "SHA3-384withRSA");
        OIDS.put(OID_RSA_SHA3_512, "SHA3-512withRSA");
        OIDS.put(OID_ECDSA_SHA3_224, "SHA3-224withECDSA");
        OIDS.put(OID_ECDSA_SHA3_256, "SHA3-256withECDSA");
        OIDS.put(OID_ECDSA_SHA3_384, "SHA3-384withECDSA");
        OIDS.put(OID_ECDSA_SHA3_512, "SHA3-512withECDSA");
    }

    public static class X509Name {
        private static final ASN1ObjectIdentifier C = new ASN1ObjectIdentifier("2.5.4.6");
        private static final ASN1ObjectIdentifier O = new ASN1ObjectIdentifier("2.5.4.10");
        private static final ASN1ObjectIdentifier OU = new ASN1ObjectIdentifier("2.5.4.11");
        private static final ASN1ObjectIdentifier T = new ASN1ObjectIdentifier("2.5.4.12");
        private static final ASN1ObjectIdentifier CN = new ASN1ObjectIdentifier("2.5.4.3");
        private static final ASN1ObjectIdentifier SN = new ASN1ObjectIdentifier("2.5.4.5");
        private static final ASN1ObjectIdentifier L = new ASN1ObjectIdentifier("2.5.4.7");
        private static final ASN1ObjectIdentifier ST = new ASN1ObjectIdentifier("2.5.4.8");
        private static final ASN1ObjectIdentifier SURNAME = new ASN1ObjectIdentifier("2.5.4.4");
        private static final ASN1ObjectIdentifier GIVENNAME = new ASN1ObjectIdentifier("2.5.4.42");
        private static final ASN1ObjectIdentifier INITIALS = new ASN1ObjectIdentifier("2.5.4.43");
        private static final ASN1ObjectIdentifier GENERATION = new ASN1ObjectIdentifier("2.5.4.44");
        private static final ASN1ObjectIdentifier EmailAddress = new ASN1ObjectIdentifier("1.2.840.113549.1.9.1");
        private static final ASN1ObjectIdentifier DC = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.25");
        private static final ASN1ObjectIdentifier UID = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.1");
        private static HashMap<ASN1ObjectIdentifier, String> DefaultSymbols = new LinkedHashMap<ASN1ObjectIdentifier, String>();
        private final HashMap<String, ArrayList<String>> values = new LinkedHashMap<String, ArrayList<String>>();

        X509Name(ASN1Sequence seq) {
            Enumeration e = seq.getObjects();
            while (e.hasMoreElements()) {
                ASN1Set set = (ASN1Set)e.nextElement();
                for (int i = 0; i < set.size(); ++i) {
                    ASN1Sequence s = (ASN1Sequence)set.getObjectAt(i);
                    String id = DefaultSymbols.get(s.getObjectAt(0));
                    if (id == null) continue;
                    ArrayList<String> vs = this.values.get(id);
                    if (vs == null) {
                        vs = new ArrayList();
                        this.values.put(id, vs);
                    }
                    vs.add(((ASN1String)s.getObjectAt(1)).getString());
                }
            }
        }

        public String getField(String name) {
            ArrayList<String> vs = this.values.get(name);
            return vs == null ? null : vs.get(0);
        }

        public HashMap<String, ArrayList<String>> getFields() {
            return this.values;
        }

        public String toString() {
            return this.values.toString();
        }

        static {
            DefaultSymbols.put(C, "C");
            DefaultSymbols.put(O, "O");
            DefaultSymbols.put(T, "T");
            DefaultSymbols.put(OU, "OU");
            DefaultSymbols.put(CN, "CN");
            DefaultSymbols.put(L, "L");
            DefaultSymbols.put(ST, "ST");
            DefaultSymbols.put(SN, "SN");
            DefaultSymbols.put(EmailAddress, "E");
            DefaultSymbols.put(DC, "DC");
            DefaultSymbols.put(UID, "UID");
            DefaultSymbols.put(SURNAME, "SURNAME");
            DefaultSymbols.put(GIVENNAME, "GIVENNAME");
            DefaultSymbols.put(INITIALS, "INITIALS");
            DefaultSymbols.put(GENERATION, "GENERATION");
        }
    }
}

