/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.ExceptionConverter;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfNumber;
import com.aowagie.text.pdf.PdfNumberTree;
import com.aowagie.text.pdf.PdfString;
import com.aowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;

class PdfPageLabels {
    private static final int DECIMAL_ARABIC_NUMERALS = 0;
    private static PdfName[] numberingStyle = new PdfName[]{PdfName.D, PdfName.R, new PdfName("r"), PdfName.A, new PdfName("a")};
    private final HashMap map = new LinkedHashMap();

    public PdfPageLabels() {
        this.addPageLabel(1, 0, null, 1);
    }

    private void addPageLabel(int page, int numberStyle, String text, int firstPage) {
        if (page < 1 || firstPage < 1) {
            throw new IllegalArgumentException("In a page label the page numbers must be greater or equal to 1.");
        }
        PdfDictionary dic = new PdfDictionary();
        if (numberStyle >= 0 && numberStyle < numberingStyle.length) {
            dic.put(PdfName.S, numberingStyle[numberStyle]);
        }
        if (text != null) {
            dic.put(PdfName.P, new PdfString(text, "UnicodeBig"));
        }
        if (firstPage != 1) {
            dic.put(PdfName.ST, new PdfNumber(firstPage));
        }
        this.map.put(page - 1, dic);
    }

    PdfDictionary getDictionary(PdfWriter writer) {
        try {
            return PdfNumberTree.writeTree(this.map, writer);
        }
        catch (IOException e) {
            throw new ExceptionConverter(e);
        }
    }

    private static class PdfPageLabelFormat {
        private final int physicalPage;
        private final int numberStyle;
        private final String prefix;
        private final int logicalPage;

        private PdfPageLabelFormat(int physicalPage, int numberStyle, String prefix, int logicalPage) {
            this.physicalPage = physicalPage;
            this.numberStyle = numberStyle;
            this.prefix = prefix;
            this.logicalPage = logicalPage;
        }
    }
}

