/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf;

import com.aowagie.text.xml.simpleparser.SimpleXMLDocHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

class XfdfReader
implements SimpleXMLDocHandler {
    private boolean foundRoot = false;
    private final Stack fieldNames = new Stack();
    private final Stack fieldValues = new Stack();
    private HashMap fields;
    private HashMap listFields;
    private String fileSpec;

    XfdfReader() {
    }

    public HashMap getFields() {
        return this.fields;
    }

    String getFieldValue(String name) {
        String field = (String)this.fields.get(name);
        if (field == null) {
            return null;
        }
        return field;
    }

    List getListValues(String name) {
        return (List)this.listFields.get(name);
    }

    public String getFileSpec() {
        return this.fileSpec;
    }

    @Override
    public void startElement(String tag, HashMap h) {
        if (!this.foundRoot) {
            if (!tag.equals("xfdf")) {
                throw new RuntimeException("Root element is not Bookmark.");
            }
            this.foundRoot = true;
        }
        if (!tag.equals("xfdf")) {
            if (tag.equals("f")) {
                this.fileSpec = (String)h.get("href");
            } else if (tag.equals("fields")) {
                this.fields = new HashMap();
                this.listFields = new HashMap();
            } else if (tag.equals("field")) {
                String fName = (String)h.get("name");
                this.fieldNames.push(fName);
            } else if (tag.equals("value")) {
                this.fieldValues.push("");
            }
        }
    }

    @Override
    public void endElement(String tag) {
        if (tag.equals("value")) {
            String fVal;
            String old;
            String fName = "";
            for (int k = 0; k < this.fieldNames.size(); ++k) {
                fName = fName + "." + (String)this.fieldNames.elementAt(k);
            }
            if (fName.startsWith(".")) {
                fName = fName.substring(1);
            }
            if ((old = this.fields.put(fName, fVal = (String)this.fieldValues.pop())) != null) {
                ArrayList<String> l = (ArrayList<String>)this.listFields.get(fName);
                if (l == null) {
                    l = new ArrayList<String>();
                    l.add(old);
                }
                l.add(fVal);
                this.listFields.put(fName, l);
            }
        } else if (tag.equals("field") && !this.fieldNames.isEmpty()) {
            this.fieldNames.pop();
        }
    }

    @Override
    public void startDocument() {
        this.fileSpec = "";
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void text(String str) {
        if (this.fieldNames.isEmpty() || this.fieldValues.isEmpty()) {
            return;
        }
        String val = (String)this.fieldValues.pop();
        val = val + str;
        this.fieldValues.push(val);
    }
}

