/*
 * Decompiled with CFR 0.152.
 */
package com.aowagie.text.pdf.collection;

import com.aowagie.text.pdf.PdfBoolean;
import com.aowagie.text.pdf.PdfDate;
import com.aowagie.text.pdf.PdfDictionary;
import com.aowagie.text.pdf.PdfName;
import com.aowagie.text.pdf.PdfNumber;
import com.aowagie.text.pdf.PdfObject;
import com.aowagie.text.pdf.PdfString;

class PdfCollectionField
extends PdfDictionary {
    private static final int TEXT = 0;
    public static final int DATE = 1;
    public static final int NUMBER = 2;
    protected int fieldType;

    PdfCollectionField() {
    }

    public void setOrder(int i) {
        this.put(PdfName.O, new PdfNumber(i));
    }

    public void setVisible(boolean visible) {
        this.put(PdfName.V, new PdfBoolean(visible));
    }

    public void setEditable(boolean editable) {
        this.put(PdfName.E, new PdfBoolean(editable));
    }

    public boolean isCollectionItem() {
        switch (this.fieldType) {
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public PdfObject getValue(String v) {
        switch (this.fieldType) {
            case 0: {
                return new PdfString(v, "UnicodeBig");
            }
            case 1: {
                return new PdfDate(PdfDate.decode(v));
            }
            case 2: {
                return new PdfNumber(v);
            }
        }
        throw new IllegalArgumentException(v + " is not an acceptable value for the field " + this.get(PdfName.N).toString());
    }
}

