/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Leu/europa/ec/eudi/openid4vci/EncryptionSpec;", "Ljava/io/Serializable;", "recipientKey", "Lcom/nimbusds/jose/jwk/JWK;", "encryptionMethod", "Lcom/nimbusds/jose/EncryptionMethod;", "compressionAlgorithm", "Lcom/nimbusds/jose/CompressionAlgorithm;", "<init>", "(Lcom/nimbusds/jose/jwk/JWK;Lcom/nimbusds/jose/EncryptionMethod;Lcom/nimbusds/jose/CompressionAlgorithm;)V", "getRecipientKey", "()Lcom/nimbusds/jose/jwk/JWK;", "getEncryptionMethod", "()Lcom/nimbusds/jose/EncryptionMethod;", "getCompressionAlgorithm", "()Lcom/nimbusds/jose/CompressionAlgorithm;", "algorithm", "Lcom/nimbusds/jose/JWEAlgorithm;", "getAlgorithm", "()Lcom/nimbusds/jose/JWEAlgorithm;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "eudi-lib-jvm-openid4vci-kt"})
public final class EncryptionSpec
implements Serializable {
    @NotNull
    private final JWK recipientKey;
    @NotNull
    private final EncryptionMethod encryptionMethod;
    @Nullable
    private final CompressionAlgorithm compressionAlgorithm;

    public EncryptionSpec(@NotNull JWK recipientKey, @NotNull EncryptionMethod encryptionMethod, @Nullable CompressionAlgorithm compressionAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)recipientKey, (String)"recipientKey");
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        this.recipientKey = recipientKey;
        this.encryptionMethod = encryptionMethod;
        this.compressionAlgorithm = compressionAlgorithm;
        KeyUse keyUse = this.recipientKey.getKeyUse();
        if (keyUse != null && !Intrinsics.areEqual((Object)keyUse, (Object)KeyUse.ENCRYPTION)) {
            boolean $i$a$-require-EncryptionSpec$22 = false;
            String $i$a$-require-EncryptionSpec$22 = "Provided key use is not encryption";
            throw new IllegalArgumentException($i$a$-require-EncryptionSpec$22.toString());
        }
        Algorithm keyAlgorithm = this.recipientKey.getAlgorithm();
        if (keyAlgorithm == null) {
            boolean bl = false;
            String string = "Provided key does not contain an algorithm";
            throw new IllegalArgumentException(string.toString());
        }
        JWEAlgorithm.Family family = JWEAlgorithm.Family.ASYMMETRIC;
        Intrinsics.checkNotNullExpressionValue((Object)family, (String)"ASYMMETRIC");
        if (!CollectionsKt.contains((Iterable)((Iterable)family), (Object)keyAlgorithm)) {
            boolean $i$a$-require-EncryptionSpec$52 = false;
            String $i$a$-require-EncryptionSpec$52 = "Provided encryption algorithm is not an asymmetric encryption algorithm";
            throw new IllegalArgumentException($i$a$-require-EncryptionSpec$52.toString());
        }
        if (!Intrinsics.areEqual((Object)this.recipientKey.getKeyType(), (Object)KeyType.forAlgorithm((Algorithm)keyAlgorithm))) {
            boolean bl = false;
            String string = "Encryption key and encryption algorithm do not match";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ EncryptionSpec(JWK jWK, EncryptionMethod encryptionMethod, CompressionAlgorithm compressionAlgorithm, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            compressionAlgorithm = null;
        }
        this(jWK, encryptionMethod, compressionAlgorithm);
    }

    @NotNull
    public final JWK getRecipientKey() {
        return this.recipientKey;
    }

    @NotNull
    public final EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    @Nullable
    public final CompressionAlgorithm getCompressionAlgorithm() {
        return this.compressionAlgorithm;
    }

    @NotNull
    public final JWEAlgorithm getAlgorithm() {
        JWEAlgorithm jWEAlgorithm = JWEAlgorithm.parse((String)this.recipientKey.getAlgorithm().getName());
        Intrinsics.checkNotNullExpressionValue((Object)jWEAlgorithm, (String)"parse(...)");
        return jWEAlgorithm;
    }

    @NotNull
    public final JWK component1() {
        return this.recipientKey;
    }

    @NotNull
    public final EncryptionMethod component2() {
        return this.encryptionMethod;
    }

    @Nullable
    public final CompressionAlgorithm component3() {
        return this.compressionAlgorithm;
    }

    @NotNull
    public final EncryptionSpec copy(@NotNull JWK recipientKey, @NotNull EncryptionMethod encryptionMethod, @Nullable CompressionAlgorithm compressionAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)recipientKey, (String)"recipientKey");
        Intrinsics.checkNotNullParameter((Object)encryptionMethod, (String)"encryptionMethod");
        return new EncryptionSpec(recipientKey, encryptionMethod, compressionAlgorithm);
    }

    public static /* synthetic */ EncryptionSpec copy$default(EncryptionSpec encryptionSpec, JWK jWK, EncryptionMethod encryptionMethod, CompressionAlgorithm compressionAlgorithm, int n, Object object) {
        if ((n & 1) != 0) {
            jWK = encryptionSpec.recipientKey;
        }
        if ((n & 2) != 0) {
            encryptionMethod = encryptionSpec.encryptionMethod;
        }
        if ((n & 4) != 0) {
            compressionAlgorithm = encryptionSpec.compressionAlgorithm;
        }
        return encryptionSpec.copy(jWK, encryptionMethod, compressionAlgorithm);
    }

    @NotNull
    public String toString() {
        return "EncryptionSpec(recipientKey=" + this.recipientKey + ", encryptionMethod=" + this.encryptionMethod + ", compressionAlgorithm=" + this.compressionAlgorithm + ")";
    }

    public int hashCode() {
        int result = this.recipientKey.hashCode();
        result = result * 31 + this.encryptionMethod.hashCode();
        result = result * 31 + (this.compressionAlgorithm == null ? 0 : this.compressionAlgorithm.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EncryptionSpec)) {
            return false;
        }
        EncryptionSpec encryptionSpec = (EncryptionSpec)other;
        if (!Intrinsics.areEqual((Object)this.recipientKey, (Object)encryptionSpec.recipientKey)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.encryptionMethod, (Object)encryptionSpec.encryptionMethod)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.compressionAlgorithm, (Object)encryptionSpec.compressionAlgorithm);
    }
}

