/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.as.ReadOnlyAuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import eu.europa.ec.eudi.openid4vci.ClientAuthentication;
import eu.europa.ec.eudi.openid4vci.TypesKt;
import eu.europa.ec.eudi.openid4vci.internal.SigningOpsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005H\u0000\u00a8\u0006\u0006"}, d2={"ensureSupportedByAuthorizationServer", "", "Leu/europa/ec/eudi/openid4vci/ClientAuthentication;", "authorizationServerMetadata", "Lcom/nimbusds/oauth2/sdk/as/ReadOnlyAuthorizationServerMetadata;", "Leu/europa/ec/eudi/openid4vci/CIAuthorizationServerMetadata;", "eudi-lib-jvm-openid4vci-kt"})
public final class IssuerKt {
    public static final void ensureSupportedByAuthorizationServer(@NotNull ClientAuthentication $this$ensureSupportedByAuthorizationServer, @NotNull ReadOnlyAuthorizationServerMetadata authorizationServerMetadata) {
        Intrinsics.checkNotNullParameter((Object)$this$ensureSupportedByAuthorizationServer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)authorizationServerMetadata, (String)"authorizationServerMetadata");
        if ($this$ensureSupportedByAuthorizationServer instanceof ClientAuthentication.AttestationBased) {
            JWSAlgorithm clientAttestationPOPJWSAlg;
            List supportedClientAttestationPOPJWSAlgs;
            JWSAlgorithm clientAttestationJWSAlg;
            List supportedClientAttestationJWSAlgs;
            ClientAuthenticationMethod authenticationMethod;
            List supportedAuthenticationMethods;
            List list = authorizationServerMetadata.getTokenEndpointAuthMethods();
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            if (!(supportedAuthenticationMethods = list).contains(authenticationMethod = new ClientAuthenticationMethod("attest_jwt_client_auth"))) {
                boolean $i$a$-require-IssuerKt$ensureSupportedByAuthorizationServer$42 = false;
                String $i$a$-require-IssuerKt$ensureSupportedByAuthorizationServer$42 = authenticationMethod.getValue() + " Authentication Method not supported by Authorization Server";
                throw new IllegalArgumentException($i$a$-require-IssuerKt$ensureSupportedByAuthorizationServer$42.toString());
            }
            List list2 = TypesKt.getClientAttestationJWSAlgs(authorizationServerMetadata);
            if (list2 == null) {
                list2 = CollectionsKt.emptyList();
            }
            if (!(supportedClientAttestationJWSAlgs = list2).contains(clientAttestationJWSAlg = ((ClientAuthentication.AttestationBased)$this$ensureSupportedByAuthorizationServer).getAttestationJWT-JKpmwrk().getHeader().getAlgorithm())) {
                boolean $i$a$-require-IssuerKt$ensureSupportedByAuthorizationServer$52 = false;
                String $i$a$-require-IssuerKt$ensureSupportedByAuthorizationServer$52 = clientAttestationJWSAlg.getName() + " Client Attestation JWS Algorithm not supported by Authorization Server";
                throw new IllegalArgumentException($i$a$-require-IssuerKt$ensureSupportedByAuthorizationServer$52.toString());
            }
            List list3 = TypesKt.getClientAttestationPOPJWSAlgs(authorizationServerMetadata);
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            if (!(supportedClientAttestationPOPJWSAlgs = list3).contains(clientAttestationPOPJWSAlg = SigningOpsKt.toJoseAlg(((ClientAuthentication.AttestationBased)$this$ensureSupportedByAuthorizationServer).getPopJwtSpec().getSigner().getJavaAlgorithm()))) {
                boolean bl = false;
                String string = clientAttestationPOPJWSAlg.getName() + " Client Attestation POP JWS Algorithm not supported by Authorization Server";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }
}

