/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import eu.europa.ec.eudi.openid4vci.CredentialIssuerMetadataValidationError;
import eu.europa.ec.eudi.openid4vci.PayloadCompression;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\bH\u00c6\u0003J-\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Leu/europa/ec/eudi/openid4vci/SupportedRequestEncryptionParameters;", "", "encryptionKeys", "Lcom/nimbusds/jose/jwk/JWKSet;", "encryptionMethods", "", "Lcom/nimbusds/jose/EncryptionMethod;", "payloadCompression", "Leu/europa/ec/eudi/openid4vci/PayloadCompression;", "<init>", "(Lcom/nimbusds/jose/jwk/JWKSet;Ljava/util/List;Leu/europa/ec/eudi/openid4vci/PayloadCompression;)V", "getEncryptionKeys", "()Lcom/nimbusds/jose/jwk/JWKSet;", "getEncryptionMethods", "()Ljava/util/List;", "getPayloadCompression", "()Leu/europa/ec/eudi/openid4vci/PayloadCompression;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "eudi-lib-jvm-openid4vci-kt"})
@SourceDebugExtension(value={"SMAP\nCredentialIssuerMetadataResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CredentialIssuerMetadataResolver.kt\neu/europa/ec/eudi/openid4vci/SupportedRequestEncryptionParameters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ResultOps.kt\neu/europa/ec/eudi/openid4vci/internal/ResultOpsKt\n*L\n1#1,366:1\n1#2:367\n1869#3:368\n1870#3:381\n39#4,2:369\n39#4,2:371\n39#4,2:373\n39#4,2:375\n39#4,2:377\n39#4,2:379\n*S KotlinDebug\n*F\n+ 1 CredentialIssuerMetadataResolver.kt\neu/europa/ec/eudi/openid4vci/SupportedRequestEncryptionParameters\n*L\n112#1:368\n112#1:381\n113#1:369,2\n116#1:371,2\n119#1:373,2\n122#1:375,2\n125#1:377,2\n128#1:379,2\n*E\n"})
public final class SupportedRequestEncryptionParameters {
    @NotNull
    private final JWKSet encryptionKeys;
    @NotNull
    private final List<EncryptionMethod> encryptionMethods;
    @NotNull
    private final PayloadCompression payloadCompression;

    public SupportedRequestEncryptionParameters(@NotNull JWKSet encryptionKeys, @NotNull List<EncryptionMethod> encryptionMethods, @NotNull PayloadCompression payloadCompression) {
        Intrinsics.checkNotNullParameter((Object)encryptionKeys, (String)"encryptionKeys");
        Intrinsics.checkNotNullParameter(encryptionMethods, (String)"encryptionMethods");
        Intrinsics.checkNotNullParameter((Object)payloadCompression, (String)"payloadCompression");
        this.encryptionKeys = encryptionKeys;
        this.encryptionMethods = encryptionMethods;
        this.payloadCompression = payloadCompression;
        if (!(!((Collection)this.encryptionMethods).isEmpty())) {
            boolean $i$a$-require-SupportedRequestEncryptionParameters$22 = false;
            String $i$a$-require-SupportedRequestEncryptionParameters$22 = "encryptionMethods cannot be empty";
            throw new IllegalArgumentException($i$a$-require-SupportedRequestEncryptionParameters$22.toString());
        }
        if (this.encryptionKeys.isEmpty()) {
            throw new CredentialIssuerMetadataValidationError.CredentialRequestEncryptionKeysRequired();
        }
        List list = this.encryptionKeys.getKeys();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JWK it = (JWK)element$iv;
            boolean bl = false;
            boolean value$iv = it.getKeyID() != null;
            boolean $i$f$ensure = false;
            if (!value$iv) {
                boolean bl2 = false;
                throw (Throwable)new CredentialIssuerMetadataValidationError.CredentialRequestEncryptionKeysMustHaveKeyId();
            }
            value$iv = it.getAlgorithm() != null;
            $i$f$ensure = false;
            if (!value$iv) {
                boolean bl3 = false;
                throw (Throwable)new CredentialIssuerMetadataValidationError.CredentialRequestEncryptionKeysMustHaveAlgorithm();
            }
            JWEAlgorithm.Family family = JWEAlgorithm.Family.ASYMMETRIC;
            Intrinsics.checkNotNullExpressionValue((Object)family, (String)"ASYMMETRIC");
            value$iv = CollectionsKt.contains((Iterable)((Iterable)family), (Object)it.getAlgorithm());
            $i$f$ensure = false;
            if (!value$iv) {
                boolean bl4 = false;
                throw (Throwable)new CredentialIssuerMetadataValidationError.CredentialRequestEncryptionKeysMustHaveAsymmetricAlgorithm();
            }
            value$iv = !it.isPrivate();
            $i$f$ensure = false;
            if (!value$iv) {
                boolean bl5 = false;
                throw (Throwable)new CredentialIssuerMetadataValidationError.CredentialRequestEncryptionKeysMustBePublic();
            }
            value$iv = Intrinsics.areEqual((Object)it.getKeyType(), (Object)KeyType.forAlgorithm((Algorithm)it.getAlgorithm()));
            $i$f$ensure = false;
            if (!value$iv) {
                boolean bl6 = false;
                throw (Throwable)new CredentialIssuerMetadataValidationError.CredentialRequestEncryptionKeyWrongKeyType();
            }
            value$iv = Intrinsics.areEqual((Object)it.getKeyUse(), (Object)KeyUse.ENCRYPTION);
            $i$f$ensure = false;
            if (value$iv) continue;
            boolean bl7 = false;
            throw (Throwable)new CredentialIssuerMetadataValidationError.CredentialRequestEncryptionKeysMustHaveEncryptionUsage();
        }
    }

    public /* synthetic */ SupportedRequestEncryptionParameters(JWKSet jWKSet, List list, PayloadCompression payloadCompression, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            payloadCompression = PayloadCompression.NotSupported.INSTANCE;
        }
        this(jWKSet, list, payloadCompression);
    }

    @NotNull
    public final JWKSet getEncryptionKeys() {
        return this.encryptionKeys;
    }

    @NotNull
    public final List<EncryptionMethod> getEncryptionMethods() {
        return this.encryptionMethods;
    }

    @NotNull
    public final PayloadCompression getPayloadCompression() {
        return this.payloadCompression;
    }

    @NotNull
    public final JWKSet component1() {
        return this.encryptionKeys;
    }

    @NotNull
    public final List<EncryptionMethod> component2() {
        return this.encryptionMethods;
    }

    @NotNull
    public final PayloadCompression component3() {
        return this.payloadCompression;
    }

    @NotNull
    public final SupportedRequestEncryptionParameters copy(@NotNull JWKSet encryptionKeys, @NotNull List<EncryptionMethod> encryptionMethods, @NotNull PayloadCompression payloadCompression) {
        Intrinsics.checkNotNullParameter((Object)encryptionKeys, (String)"encryptionKeys");
        Intrinsics.checkNotNullParameter(encryptionMethods, (String)"encryptionMethods");
        Intrinsics.checkNotNullParameter((Object)payloadCompression, (String)"payloadCompression");
        return new SupportedRequestEncryptionParameters(encryptionKeys, encryptionMethods, payloadCompression);
    }

    public static /* synthetic */ SupportedRequestEncryptionParameters copy$default(SupportedRequestEncryptionParameters supportedRequestEncryptionParameters, JWKSet jWKSet, List list, PayloadCompression payloadCompression, int n, Object object) {
        if ((n & 1) != 0) {
            jWKSet = supportedRequestEncryptionParameters.encryptionKeys;
        }
        if ((n & 2) != 0) {
            list = supportedRequestEncryptionParameters.encryptionMethods;
        }
        if ((n & 4) != 0) {
            payloadCompression = supportedRequestEncryptionParameters.payloadCompression;
        }
        return supportedRequestEncryptionParameters.copy(jWKSet, list, payloadCompression);
    }

    @NotNull
    public String toString() {
        return "SupportedRequestEncryptionParameters(encryptionKeys=" + this.encryptionKeys + ", encryptionMethods=" + this.encryptionMethods + ", payloadCompression=" + this.payloadCompression + ")";
    }

    public int hashCode() {
        int result = this.encryptionKeys.hashCode();
        result = result * 31 + ((Object)this.encryptionMethods).hashCode();
        result = result * 31 + this.payloadCompression.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SupportedRequestEncryptionParameters)) {
            return false;
        }
        SupportedRequestEncryptionParameters supportedRequestEncryptionParameters = (SupportedRequestEncryptionParameters)other;
        if (!Intrinsics.areEqual((Object)this.encryptionKeys, (Object)supportedRequestEncryptionParameters.encryptionKeys)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.encryptionMethods, supportedRequestEncryptionParameters.encryptionMethods)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.payloadCompression, (Object)supportedRequestEncryptionParameters.payloadCompression);
    }
}

