/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import eu.europa.ec.eudi.openid4vci.CredentialIssuerMetadataValidationError;
import eu.europa.ec.eudi.openid4vci.PayloadCompression;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Leu/europa/ec/eudi/openid4vci/SupportedResponseEncryptionParameters;", "", "algorithms", "", "Lcom/nimbusds/jose/JWEAlgorithm;", "encryptionMethods", "Lcom/nimbusds/jose/EncryptionMethod;", "payloadCompression", "Leu/europa/ec/eudi/openid4vci/PayloadCompression;", "<init>", "(Ljava/util/List;Ljava/util/List;Leu/europa/ec/eudi/openid4vci/PayloadCompression;)V", "getAlgorithms", "()Ljava/util/List;", "getEncryptionMethods", "getPayloadCompression", "()Leu/europa/ec/eudi/openid4vci/PayloadCompression;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "eudi-lib-jvm-openid4vci-kt"})
@SourceDebugExtension(value={"SMAP\nCredentialIssuerMetadataResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CredentialIssuerMetadataResolver.kt\neu/europa/ec/eudi/openid4vci/SupportedResponseEncryptionParameters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,366:1\n1#2:367\n1740#3,3:368\n*S KotlinDebug\n*F\n+ 1 CredentialIssuerMetadataResolver.kt\neu/europa/ec/eudi/openid4vci/SupportedResponseEncryptionParameters\n*L\n93#1:368,3\n*E\n"})
public final class SupportedResponseEncryptionParameters {
    @NotNull
    private final List<JWEAlgorithm> algorithms;
    @NotNull
    private final List<EncryptionMethod> encryptionMethods;
    @NotNull
    private final PayloadCompression payloadCompression;

    public SupportedResponseEncryptionParameters(@NotNull List<JWEAlgorithm> algorithms, @NotNull List<EncryptionMethod> encryptionMethods, @NotNull PayloadCompression payloadCompression) {
        boolean allAreAsymmetricAlgorithms;
        block6: {
            Intrinsics.checkNotNullParameter(algorithms, (String)"algorithms");
            Intrinsics.checkNotNullParameter(encryptionMethods, (String)"encryptionMethods");
            Intrinsics.checkNotNullParameter((Object)payloadCompression, (String)"payloadCompression");
            this.algorithms = algorithms;
            this.encryptionMethods = encryptionMethods;
            this.payloadCompression = payloadCompression;
            if (!(!((Collection)this.encryptionMethods).isEmpty())) {
                boolean $i$a$-require-SupportedResponseEncryptionParameters$22 = false;
                String $i$a$-require-SupportedResponseEncryptionParameters$22 = "encryptionMethods cannot be empty";
                throw new IllegalArgumentException($i$a$-require-SupportedResponseEncryptionParameters$22.toString());
            }
            if (this.algorithms.isEmpty()) {
                throw new CredentialIssuerMetadataValidationError.CredentialResponseEncryptionAlgorithmsRequired();
            }
            Iterable $this$all$iv = this.algorithms;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    JWEAlgorithm it = (JWEAlgorithm)element$iv;
                    boolean bl = false;
                    if (JWEAlgorithm.Family.ASYMMETRIC.contains((Object)it)) continue;
                    v0 = false;
                    break block6;
                }
                v0 = allAreAsymmetricAlgorithms = true;
            }
        }
        if (!allAreAsymmetricAlgorithms) {
            throw new CredentialIssuerMetadataValidationError.CredentialResponseAsymmetricEncryptionAlgorithmsRequired();
        }
    }

    public /* synthetic */ SupportedResponseEncryptionParameters(List list, List list2, PayloadCompression payloadCompression, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            payloadCompression = PayloadCompression.NotSupported.INSTANCE;
        }
        this(list, list2, payloadCompression);
    }

    @NotNull
    public final List<JWEAlgorithm> getAlgorithms() {
        return this.algorithms;
    }

    @NotNull
    public final List<EncryptionMethod> getEncryptionMethods() {
        return this.encryptionMethods;
    }

    @NotNull
    public final PayloadCompression getPayloadCompression() {
        return this.payloadCompression;
    }

    @NotNull
    public final List<JWEAlgorithm> component1() {
        return this.algorithms;
    }

    @NotNull
    public final List<EncryptionMethod> component2() {
        return this.encryptionMethods;
    }

    @NotNull
    public final PayloadCompression component3() {
        return this.payloadCompression;
    }

    @NotNull
    public final SupportedResponseEncryptionParameters copy(@NotNull List<JWEAlgorithm> algorithms, @NotNull List<EncryptionMethod> encryptionMethods, @NotNull PayloadCompression payloadCompression) {
        Intrinsics.checkNotNullParameter(algorithms, (String)"algorithms");
        Intrinsics.checkNotNullParameter(encryptionMethods, (String)"encryptionMethods");
        Intrinsics.checkNotNullParameter((Object)payloadCompression, (String)"payloadCompression");
        return new SupportedResponseEncryptionParameters(algorithms, encryptionMethods, payloadCompression);
    }

    public static /* synthetic */ SupportedResponseEncryptionParameters copy$default(SupportedResponseEncryptionParameters supportedResponseEncryptionParameters, List list, List list2, PayloadCompression payloadCompression, int n, Object object) {
        if ((n & 1) != 0) {
            list = supportedResponseEncryptionParameters.algorithms;
        }
        if ((n & 2) != 0) {
            list2 = supportedResponseEncryptionParameters.encryptionMethods;
        }
        if ((n & 4) != 0) {
            payloadCompression = supportedResponseEncryptionParameters.payloadCompression;
        }
        return supportedResponseEncryptionParameters.copy(list, list2, payloadCompression);
    }

    @NotNull
    public String toString() {
        return "SupportedResponseEncryptionParameters(algorithms=" + this.algorithms + ", encryptionMethods=" + this.encryptionMethods + ", payloadCompression=" + this.payloadCompression + ")";
    }

    public int hashCode() {
        int result = ((Object)this.algorithms).hashCode();
        result = result * 31 + ((Object)this.encryptionMethods).hashCode();
        result = result * 31 + this.payloadCompression.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SupportedResponseEncryptionParameters)) {
            return false;
        }
        SupportedResponseEncryptionParameters supportedResponseEncryptionParameters = (SupportedResponseEncryptionParameters)other;
        if (!Intrinsics.areEqual(this.algorithms, supportedResponseEncryptionParameters.algorithms)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.encryptionMethods, supportedResponseEncryptionParameters.encryptionMethods)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.payloadCompression, (Object)supportedResponseEncryptionParameters.payloadCompression);
    }
}

