/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vci.internal;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jose.jwk.gen.RSAKeyGenerator;
import eu.europa.ec.eudi.openid4vci.EcConfig;
import eu.europa.ec.eudi.openid4vci.EncryptionSupportConfig;
import eu.europa.ec.eudi.openid4vci.RsaConfig;
import java.util.Date;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\t\u00a8\u0006\u0013"}, d2={"Leu/europa/ec/eudi/openid4vci/internal/KeyGenerator;", "", "<init>", "()V", "genKeyIfSupported", "Lcom/nimbusds/jose/jwk/JWK;", "encryptionSupportConfig", "Leu/europa/ec/eudi/openid4vci/EncryptionSupportConfig;", "algorithm", "Lcom/nimbusds/jose/JWEAlgorithm;", "randomRSAEncryptionKey", "Lcom/nimbusds/jose/jwk/RSAKey;", "rsaConfig", "Leu/europa/ec/eudi/openid4vci/RsaConfig;", "alg", "randomECEncryptionKey", "Lcom/nimbusds/jose/jwk/ECKey;", "ecConfig", "Leu/europa/ec/eudi/openid4vci/EcConfig;", "eudi-lib-jvm-openid4vci-kt"})
public final class KeyGenerator {
    @NotNull
    public static final KeyGenerator INSTANCE = new KeyGenerator();

    private KeyGenerator() {
    }

    @Nullable
    public final JWK genKeyIfSupported(@NotNull EncryptionSupportConfig encryptionSupportConfig, @NotNull JWEAlgorithm algorithm) {
        Intrinsics.checkNotNullParameter((Object)encryptionSupportConfig, (String)"encryptionSupportConfig");
        Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
        return encryptionSupportConfig.getEcConfig() != null && encryptionSupportConfig.getEcConfig().getSupportedJWEAlgorithms().contains(algorithm) ? (JWK)this.randomECEncryptionKey(encryptionSupportConfig.getEcConfig(), algorithm) : (encryptionSupportConfig.getRsaConfig() != null && encryptionSupportConfig.getRsaConfig().getSupportedJWEAlgorithms().contains(algorithm) ? (JWK)this.randomRSAEncryptionKey(encryptionSupportConfig.getRsaConfig(), algorithm) : null);
    }

    @NotNull
    public final RSAKey randomRSAEncryptionKey(@NotNull RsaConfig rsaConfig, @NotNull JWEAlgorithm alg) {
        Intrinsics.checkNotNullParameter((Object)rsaConfig, (String)"rsaConfig");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        JWK jWK = new RSAKeyGenerator(rsaConfig.getRcaKeySize()).keyUse(KeyUse.ENCRYPTION).keyID(UUID.randomUUID().toString()).algorithm((Algorithm)alg).issueTime(new Date(System.currentTimeMillis())).generate();
        Intrinsics.checkNotNullExpressionValue((Object)jWK, (String)"generate(...)");
        return (RSAKey)jWK;
    }

    @NotNull
    public final ECKey randomECEncryptionKey(@NotNull EcConfig ecConfig, @NotNull JWEAlgorithm alg) {
        Intrinsics.checkNotNullParameter((Object)ecConfig, (String)"ecConfig");
        Intrinsics.checkNotNullParameter((Object)alg, (String)"alg");
        JWK jWK = new ECKeyGenerator(ecConfig.getEcKeyCurve()).keyUse(KeyUse.ENCRYPTION).keyID(UUID.randomUUID().toString()).algorithm((Algorithm)alg).issueTime(new Date(System.currentTimeMillis())).generate();
        Intrinsics.checkNotNullExpressionValue((Object)jWK, (String)"generate(...)");
        return (ECKey)jWK;
    }
}

