/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.sdjwt;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.source.ImmutableJWKSet;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.DefaultJOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.JOSEObjectTypeVerifier;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.nimbusds.jwt.proc.JWTProcessor;
import eu.europa.ec.eudi.sdjwt.HashAlgorithm;
import eu.europa.ec.eudi.sdjwt.JwkSourceJWTProcessor;
import eu.europa.ec.eudi.sdjwt.SdJwtPresentationOps;
import eu.europa.ec.eudi.sdjwt.SdJwtSerializationOps;
import eu.europa.ec.eudi.sdjwt.SdJwtVerifier;
import eu.europa.ec.eudi.sdjwt.dsl.values.SdJwtObjectBuilder;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a5\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\"\f\b\u0000\u0010\u0003*\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u0002H\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a\n\u0010\n\u001a\u00020\u000b*\u00020\b\u001a\f\u0010\f\u001a\u00020\u000b*\u00020\u0004H\u0002\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0004\u001aE\u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0019\b\u0002\u0010\u001f\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u000e0\u0019\u00a2\u0006\u0002\b!H\u0002\u001a\f\u0010\"\u001a\u00020#*\u00020#H\u0002\"\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"keyBindingJWTProcess", "Lcom/nimbusds/jwt/proc/JWTProcessor;", "Lcom/nimbusds/jose/proc/SecurityContext;", "PubKey", "Lcom/nimbusds/jose/jwk/JWK;", "Lcom/nimbusds/jose/jwk/AsymmetricJWK;", "holderPubKey", "challenge", "Lcom/nimbusds/jwt/JWTClaimsSet;", "(Lcom/nimbusds/jose/jwk/JWK;Lcom/nimbusds/jwt/JWTClaimsSet;)Lcom/nimbusds/jwt/proc/JWTProcessor;", "jsonObject", "Lkotlinx/serialization/json/JsonObject;", "asJsonObject", "cnf", "", "Leu/europa/ec/eudi/sdjwt/dsl/values/SdJwtObjectBuilder;", "jwk", "NimbusSerializationOps", "Leu/europa/ec/eudi/sdjwt/SdJwtSerializationOps;", "Lcom/nimbusds/jwt/SignedJWT;", "NimbusPresentationOps", "Leu/europa/ec/eudi/sdjwt/SdJwtPresentationOps;", "NimbusVerifier", "Leu/europa/ec/eudi/sdjwt/SdJwtVerifier;", "sign", "Lkotlin/Function1;", "Lkotlin/Result;", "signer", "Lcom/nimbusds/jose/JWSSigner;", "signAlgorithm", "Lcom/nimbusds/jose/JWSAlgorithm;", "jwsHeaderCustomization", "Lcom/nimbusds/jose/JWSHeader$Builder;", "Lkotlin/ExtensionFunctionType;", "withoutKeyId", "Lcom/nimbusds/jose/jwk/JWKMatcher;", "eudi-lib-jvm-sdjwt-kt"})
@SourceDebugExtension(value={"SMAP\nNimbusIntegration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NimbusIntegration.kt\neu/europa/ec/eudi/sdjwt/NimbusIntegrationKt\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Util.kt\neu/europa/ec/eudi/sdjwt/UtilKt\n*L\n1#1,427:1\n29#2,3:428\n1#3:431\n21#4,6:432\n*S KotlinDebug\n*F\n+ 1 NimbusIntegration.kt\neu/europa/ec/eudi/sdjwt/NimbusIntegrationKt\n*L\n124#1:428,3\n330#1:432,6\n*E\n"})
public final class NimbusIntegrationKt {
    @NotNull
    private static final SdJwtSerializationOps<SignedJWT> NimbusSerializationOps = SdJwtSerializationOps.Companion.invoke(NimbusIntegrationKt::NimbusSerializationOps$lambda$3, NimbusIntegrationKt::NimbusSerializationOps$lambda$6);
    @NotNull
    private static final SdJwtPresentationOps<SignedJWT> NimbusPresentationOps = SdJwtPresentationOps.Companion.invoke(NimbusIntegrationKt::NimbusPresentationOps$lambda$7);
    @NotNull
    private static final SdJwtVerifier<SignedJWT> NimbusVerifier = SdJwtVerifier.Companion.invoke(NimbusIntegrationKt::NimbusVerifier$lambda$8);

    @NotNull
    public static final <PubKey extends JWK> JWTProcessor<SecurityContext> keyBindingJWTProcess(@NotNull PubKey holderPubKey, @Nullable JWTClaimsSet challenge) {
        Intrinsics.checkNotNullParameter(holderPubKey, (String)"holderPubKey");
        Object[] objectArray = new JOSEObjectType[]{new JOSEObjectType("kb+jwt")};
        JOSEObjectTypeVerifier jOSEObjectTypeVerifier = (JOSEObjectTypeVerifier)new DefaultJOSEObjectTypeVerifier((JOSEObjectType[])objectArray);
        JWTClaimsSet jWTClaimsSet = challenge;
        if (jWTClaimsSet == null) {
            jWTClaimsSet = new JWTClaimsSet.Builder().build();
        }
        objectArray = new String[]{"aud", "iat", "nonce"};
        return new JwkSourceJWTProcessor(jOSEObjectTypeVerifier, (JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(jWTClaimsSet, SetsKt.setOf((Object[])objectArray)), (JWKSource)new ImmutableJWKSet(new JWKSet(CollectionsKt.listOf(holderPubKey))), true);
    }

    public static /* synthetic */ JWTProcessor keyBindingJWTProcess$default(JWK jWK, JWTClaimsSet jWTClaimsSet, int n, Object object) {
        if ((n & 2) != 0) {
            jWTClaimsSet = null;
        }
        return NimbusIntegrationKt.keyBindingJWTProcess(jWK, jWTClaimsSet);
    }

    @NotNull
    public static final JsonObject jsonObject(@NotNull JWTClaimsSet $this$jsonObject) {
        Intrinsics.checkNotNullParameter((Object)$this$jsonObject, (String)"<this>");
        byte[] $this$jsonObject_u24lambda_u240 = $this$jsonObject.toPayload().toBytes();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$jsonObject_u24lambda_u240);
        String s = StringsKt.decodeToString((byte[])$this$jsonObject_u24lambda_u240);
        return JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(s));
    }

    private static final JsonObject asJsonObject(JWK $this$asJsonObject) {
        String string = $this$asJsonObject.toJSONString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJSONString(...)");
        return JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(string));
    }

    /*
     * WARNING - void declaration
     */
    public static final void cnf(@NotNull SdJwtObjectBuilder $this$cnf, @NotNull JWK jwk) {
        void $this$cnf_u24lambda_u241;
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)$this$cnf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)jwk, (String)"jwk");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        String string = "cnf";
        SdJwtObjectBuilder sdJwtObjectBuilder = $this$cnf;
        boolean bl = false;
        $this$cnf_u24lambda_u241.put("jwk", (JsonElement)NimbusIntegrationKt.asJsonObject(jwk));
        Unit unit = Unit.INSTANCE;
        sdJwtObjectBuilder.claim(string, (JsonElement)builder$iv.build());
    }

    private static final Function1<JsonObject, Result<SignedJWT>> sign(JWSSigner signer, JWSAlgorithm signAlgorithm, Function1<? super JWSHeader.Builder, Unit> jwsHeaderCustomization) {
        return arg_0 -> NimbusIntegrationKt.sign$lambda$13(signAlgorithm, jwsHeaderCustomization, signer, arg_0);
    }

    static /* synthetic */ Function1 sign$default(JWSSigner jWSSigner, JWSAlgorithm jWSAlgorithm, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = NimbusIntegrationKt::sign$lambda$9;
        }
        return NimbusIntegrationKt.sign(jWSSigner, jWSAlgorithm, (Function1<? super JWSHeader.Builder, Unit>)function1);
    }

    private static final JWKMatcher withoutKeyId(JWKMatcher $this$withoutKeyId) {
        JWKMatcher jWKMatcher = new JWKMatcher.Builder($this$withoutKeyId).keyID(null).withKeyIDOnly(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)jWKMatcher, (String)"build(...)");
        return jWKMatcher;
    }

    private static final String NimbusSerializationOps$lambda$3(SignedJWT jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        if (!(jwt.getState() == JWSObject.State.SIGNED || jwt.getState() == JWSObject.State.VERIFIED)) {
            boolean bl = false;
            String string = "It seems that the jwt is not signed";
            throw new IllegalStateException(string.toString());
        }
        String string = jwt.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        return string;
    }

    private static final HashAlgorithm NimbusSerializationOps$lambda$6(SignedJWT jwt) {
        HashAlgorithm hashAlgorithm;
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        String string = jwt.getJWTClaimsSet().getStringClaim("_sd_alg");
        if (string != null) {
            String it = string;
            boolean bl = false;
            hashAlgorithm = HashAlgorithm.Companion.fromString(it);
            if (hashAlgorithm == null) {
                boolean bl2 = false;
                String string2 = "Unknown hash algorithm " + it;
                throw new IllegalStateException(string2.toString());
            }
        } else {
            hashAlgorithm = null;
        }
        return hashAlgorithm;
    }

    private static final JsonObject NimbusPresentationOps$lambda$7(SignedJWT jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        JWTClaimsSet jWTClaimsSet = jwt.getJWTClaimsSet();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"getJWTClaimsSet(...)");
        return NimbusIntegrationKt.jsonObject(jWTClaimsSet);
    }

    private static final JsonObject NimbusVerifier$lambda$8(SignedJWT jwt) {
        Intrinsics.checkNotNullParameter((Object)jwt, (String)"jwt");
        JWTClaimsSet jWTClaimsSet = jwt.getJWTClaimsSet();
        Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"getJWTClaimsSet(...)");
        return NimbusIntegrationKt.jsonObject(jWTClaimsSet);
    }

    private static final Unit sign$lambda$9(JWSHeader.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"<this>");
        return Unit.INSTANCE;
    }

    private static final Result sign$lambda$13(JWSAlgorithm $signAlgorithm, Function1 $jwsHeaderCustomization, JWSSigner $signer, JsonObject claims) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)claims, (String)"claims");
        boolean $i$f$runCatchingCancellable = false;
        try {
            SignedJWT signedJWT;
            boolean bl = false;
            JWSHeader.Builder $this$sign_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410 = new JWSHeader.Builder($signAlgorithm);
            boolean bl2 = false;
            $jwsHeaderCustomization.invoke((Object)$this$sign_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410);
            JWSHeader jwsHeader = $this$sign_u24lambda_u2413_u24lambda_u2412_u24lambda_u2410.build();
            JWTClaimsSet jwtClaimSet = JWTClaimsSet.parse((String)claims.toString());
            SignedJWT $this$sign_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411 = signedJWT = new SignedJWT(jwsHeader, jwtClaimSet);
            boolean bl3 = false;
            $this$sign_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.sign($signer);
            object = Result.constructor-impl((Object)signedJWT);
        }
        catch (CancellationException ce$iv) {
            throw ce$iv;
        }
        catch (Exception e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        return Result.box-impl((Object)object);
    }

    public static final /* synthetic */ Function1 access$sign(JWSSigner signer, JWSAlgorithm signAlgorithm, Function1 jwsHeaderCustomization) {
        return NimbusIntegrationKt.sign(signer, signAlgorithm, (Function1<? super JWSHeader.Builder, Unit>)jwsHeaderCustomization);
    }

    public static final /* synthetic */ SdJwtSerializationOps access$getNimbusSerializationOps$p() {
        return NimbusSerializationOps;
    }

    public static final /* synthetic */ SdJwtPresentationOps access$getNimbusPresentationOps$p() {
        return NimbusPresentationOps;
    }

    public static final /* synthetic */ SdJwtVerifier access$getNimbusVerifier$p() {
        return NimbusVerifier;
    }

    public static final /* synthetic */ JWKMatcher access$withoutKeyId(JWKMatcher $receiver) {
        return NimbusIntegrationKt.withoutKeyId($receiver);
    }
}

