/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.sdjwt;

import eu.europa.ec.eudi.sdjwt.ClaimVisitor;
import eu.europa.ec.eudi.sdjwt.DiscloseObject;
import eu.europa.ec.eudi.sdjwt.Disclosure;
import eu.europa.ec.eudi.sdjwt.DisclosureDigest;
import eu.europa.ec.eudi.sdjwt.HashAlgorithm;
import eu.europa.ec.eudi.sdjwt.RecreateClaimsKt;
import eu.europa.ec.eudi.sdjwt.SdJwtVerifierKt;
import eu.europa.ec.eudi.sdjwt.VerificationError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ&\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Leu/europa/ec/eudi/sdjwt/RecreateClaims;", "", "visitor", "Leu/europa/ec/eudi/sdjwt/ClaimVisitor;", "<init>", "(Leu/europa/ec/eudi/sdjwt/ClaimVisitor;)V", "recreateClaims", "Lkotlinx/serialization/json/JsonObject;", "jwtClaims", "disclosures", "", "Leu/europa/ec/eudi/sdjwt/Disclosure;", "discloseJwt", "hashAlgorithm", "Leu/europa/ec/eudi/sdjwt/HashAlgorithm;", "eudi-lib-jvm-sdjwt-kt"})
@SourceDebugExtension(value={"SMAP\nRecreateClaims.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecreateClaims.kt\neu/europa/ec/eudi/sdjwt/RecreateClaims\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,364:1\n1491#2:365\n1516#2,3:366\n1519#2,3:376\n1563#2:386\n1634#2,3:387\n1563#2:390\n1634#2,3:391\n1252#2,4:396\n384#3,7:369\n506#3,7:379\n465#3:394\n415#3:395\n*S KotlinDebug\n*F\n+ 1 RecreateClaims.kt\neu/europa/ec/eudi/sdjwt/RecreateClaims\n*L\n128#1:365\n128#1:366,3\n128#1:376,3\n133#1:386\n133#1:387,3\n135#1:390\n135#1:391,3\n138#1:396,4\n128#1:369,7\n133#1:379,7\n138#1:394\n138#1:395\n*E\n"})
final class RecreateClaims {
    @Nullable
    private final ClaimVisitor visitor;

    public RecreateClaims(@Nullable ClaimVisitor visitor) {
        this.visitor = visitor;
    }

    @NotNull
    public final JsonObject recreateClaims(@NotNull JsonObject jwtClaims, @NotNull List<? extends Disclosure> disclosures) {
        Intrinsics.checkNotNullParameter((Object)jwtClaims, (String)"jwtClaims");
        Intrinsics.checkNotNullParameter(disclosures, (String)"disclosures");
        HashAlgorithm hashAlgorithm = RecreateClaimsKt.hashAlgorithm(jwtClaims);
        return this.discloseJwt(hashAlgorithm, new JsonObject(MapsKt.minus((Map)((Map)jwtClaims), (Object)"_sd_alg")), disclosures);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonObject discloseJwt(HashAlgorithm hashAlgorithm, JsonObject jwtClaims, List<? extends Disclosure> disclosures) {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Map disclosuresByDigest;
        Object answer$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        Iterable $this$groupBy$iv = disclosures;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object2;
            Disclosure it = (Disclosure)element$iv$iv;
            boolean bl = false;
            Object object3 = DisclosureDigest.Companion.digest-gIAlu-s(hashAlgorithm, it.getValue());
            ResultKt.throwOnFailure((Object)object3);
            DisclosureDigest key$iv$iv = DisclosureDigest.box-impl(((DisclosureDigest)object3).unbox-impl());
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object2 = answer$iv$iv$iv;
            } else {
                object2 = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object2;
            list$iv$iv.add(element$iv$iv);
        }
        Map $this$filterValues$iv = disclosuresByDigest = destination$iv$iv;
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Iterator it = (List)entry$iv.getValue();
            boolean bl = false;
            if (!(it.size() > 1)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$map$iv = ((Map)result$iv).values();
        boolean $i$f$map = false;
        result$iv = $this$map$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            List bl = (List)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl3 = false;
            object.add((Disclosure)CollectionsKt.first((List)it));
        }
        List nonUniqueDisclosures = (List)destination$iv$iv2;
        if (!((Collection)nonUniqueDisclosures).isEmpty()) {
            $this$map$iv = nonUniqueDisclosures;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Disclosure it = (Disclosure)item$iv$iv;
                Object object4 = destination$iv$iv2;
                boolean bl = false;
                object4.add(it.getValue());
            }
            List list = (List)destination$iv$iv2;
            throw SdJwtVerifierKt.asException(new VerificationError.NonUniqueDisclosures(list));
        }
        Map $this$mapValues$iv = disclosuresByDigest;
        boolean $i$f$mapValues = false;
        destination$iv$iv2 = $this$mapValues$iv;
        Map destination$iv$iv3 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv3;
            boolean bl = false;
            answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map2;
            boolean bl4 = false;
            Disclosure disclosure = (Disclosure)CollectionsKt.first((List)((List)it.getValue()));
            object.put(k, disclosure);
        }
        Map disclosuresPerDigest = MapsKt.toMutableMap((Map)destination$iv$iv3);
        DiscloseObject discloseObject2 = new DiscloseObject(this.visitor, disclosuresPerDigest);
        JsonObject disclosedClaims = discloseObject2.invoke-HxKvVN4(null, jwtClaims);
        if (!disclosuresPerDigest.isEmpty()) {
            throw SdJwtVerifierKt.asException(new VerificationError.MissingDigests(CollectionsKt.toList((Iterable)disclosuresPerDigest.values())));
        }
        return disclosedClaims;
    }
}

