/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.sdjwt.vc;

import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Leu/europa/ec/eudi/sdjwt/vc/IssuerJwkSource;", "", "jwkSource", "Lcom/nimbusds/jose/jwk/source/JWKSource;", "Lcom/nimbusds/jose/proc/SecurityContext;", "useKeyId", "", "<init>", "(Lcom/nimbusds/jose/jwk/source/JWKSource;Z)V", "getJwkSource", "()Lcom/nimbusds/jose/jwk/source/JWKSource;", "getUseKeyId", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "eudi-lib-jvm-sdjwt-kt"})
final class IssuerJwkSource {
    @NotNull
    private final JWKSource<SecurityContext> jwkSource;
    private final boolean useKeyId;

    public IssuerJwkSource(@NotNull JWKSource<SecurityContext> jwkSource, boolean useKeyId) {
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        this.jwkSource = jwkSource;
        this.useKeyId = useKeyId;
    }

    @NotNull
    public final JWKSource<SecurityContext> getJwkSource() {
        return this.jwkSource;
    }

    public final boolean getUseKeyId() {
        return this.useKeyId;
    }

    @NotNull
    public final JWKSource<SecurityContext> component1() {
        return this.jwkSource;
    }

    public final boolean component2() {
        return this.useKeyId;
    }

    @NotNull
    public final IssuerJwkSource copy(@NotNull JWKSource<SecurityContext> jwkSource, boolean useKeyId) {
        Intrinsics.checkNotNullParameter(jwkSource, (String)"jwkSource");
        return new IssuerJwkSource(jwkSource, useKeyId);
    }

    public static /* synthetic */ IssuerJwkSource copy$default(IssuerJwkSource issuerJwkSource2, JWKSource jWKSource, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            jWKSource = issuerJwkSource2.jwkSource;
        }
        if ((n & 2) != 0) {
            bl = issuerJwkSource2.useKeyId;
        }
        return issuerJwkSource2.copy(jWKSource, bl);
    }

    @NotNull
    public String toString() {
        return "IssuerJwkSource(jwkSource=" + this.jwkSource + ", useKeyId=" + this.useKeyId + ")";
    }

    public int hashCode() {
        int result = this.jwkSource.hashCode();
        result = result * 31 + Boolean.hashCode(this.useKeyId);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IssuerJwkSource)) {
            return false;
        }
        IssuerJwkSource issuerJwkSource2 = (IssuerJwkSource)other;
        if (!Intrinsics.areEqual(this.jwkSource, issuerJwkSource2.jwkSource)) {
            return false;
        }
        return this.useKeyId == issuerJwkSource2.useKeyId;
    }
}

