/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.crypto.ECDHDecrypter;
import com.nimbusds.jose.jwk.Curve;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Leu/europa/ec/eudi/openid4vp/EncryptionRequirement;", "Ljava/io/Serializable;", "NotRequired", "Required", "Leu/europa/ec/eudi/openid4vp/EncryptionRequirement$NotRequired;", "Leu/europa/ec/eudi/openid4vp/EncryptionRequirement$Required;", "eudi-lib-jvm-siop-openid4vp-kt"})
public interface EncryptionRequirement
extends Serializable {

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0005H\u00d6\u0003J\t\u0010\t\u001a\u00020\nH\u00d6\u0001J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001\u00a8\u0006\r"}, d2={"Leu/europa/ec/eudi/openid4vp/EncryptionRequirement$NotRequired;", "Leu/europa/ec/eudi/openid4vp/EncryptionRequirement;", "<init>", "()V", "readResolve", "", "equals", "", "other", "hashCode", "", "toString", "", "eudi-lib-jvm-siop-openid4vp-kt"})
    public static final class NotRequired
    implements EncryptionRequirement {
        @NotNull
        public static final NotRequired INSTANCE = new NotRequired();

        private NotRequired() {
        }

        private final Object readResolve() {
            return INSTANCE;
        }

        @NotNull
        public String toString() {
            return "NotRequired";
        }

        public int hashCode() {
            return 468003108;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NotRequired)) {
                return false;
            }
            NotRequired cfr_ignored_0 = (NotRequired)other;
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J3\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Leu/europa/ec/eudi/openid4vp/EncryptionRequirement$Required;", "Leu/europa/ec/eudi/openid4vp/EncryptionRequirement;", "supportedEncryptionAlgorithms", "", "Lcom/nimbusds/jose/JWEAlgorithm;", "supportedEncryptionMethods", "Lcom/nimbusds/jose/EncryptionMethod;", "ephemeralEncryptionKeyCurve", "Lcom/nimbusds/jose/jwk/Curve;", "<init>", "(Ljava/util/List;Ljava/util/List;Lcom/nimbusds/jose/jwk/Curve;)V", "getSupportedEncryptionAlgorithms", "()Ljava/util/List;", "getSupportedEncryptionMethods", "getEphemeralEncryptionKeyCurve", "()Lcom/nimbusds/jose/jwk/Curve;", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "eudi-lib-jvm-siop-openid4vp-kt"})
    @SourceDebugExtension(value={"SMAP\nConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Config.kt\neu/europa/ec/eudi/openid4vp/EncryptionRequirement$Required\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,431:1\n1#2:432\n*E\n"})
    public static final class Required
    implements EncryptionRequirement {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<JWEAlgorithm> supportedEncryptionAlgorithms;
        @NotNull
        private final List<EncryptionMethod> supportedEncryptionMethods;
        @NotNull
        private final Curve ephemeralEncryptionKeyCurve;

        public Required(@NotNull List<JWEAlgorithm> supportedEncryptionAlgorithms, @NotNull List<EncryptionMethod> supportedEncryptionMethods, @NotNull Curve ephemeralEncryptionKeyCurve) {
            Intrinsics.checkNotNullParameter(supportedEncryptionAlgorithms, (String)"supportedEncryptionAlgorithms");
            Intrinsics.checkNotNullParameter(supportedEncryptionMethods, (String)"supportedEncryptionMethods");
            Intrinsics.checkNotNullParameter((Object)ephemeralEncryptionKeyCurve, (String)"ephemeralEncryptionKeyCurve");
            this.supportedEncryptionAlgorithms = supportedEncryptionAlgorithms;
            this.supportedEncryptionMethods = supportedEncryptionMethods;
            this.ephemeralEncryptionKeyCurve = ephemeralEncryptionKeyCurve;
            if (!(!((Collection)this.supportedEncryptionAlgorithms).isEmpty())) {
                boolean $i$a$-require-EncryptionRequirement$Required$62 = false;
                String $i$a$-require-EncryptionRequirement$Required$62 = "supportedEncryptionAlgorithms cannot be empty";
                throw new IllegalArgumentException($i$a$-require-EncryptionRequirement$Required$62.toString());
            }
            if (!Companion.getSUPPORTED_ENCRYPTION_ALGORITHMS().containsAll((Collection)this.supportedEncryptionAlgorithms)) {
                boolean $i$a$-require-EncryptionRequirement$Required$72 = false;
                String $i$a$-require-EncryptionRequirement$Required$72 = "only the following JWEAlgorithms are supported: " + Companion.getSUPPORTED_ENCRYPTION_ALGORITHMS();
                throw new IllegalArgumentException($i$a$-require-EncryptionRequirement$Required$72.toString());
            }
            if (!(!((Collection)this.supportedEncryptionMethods).isEmpty())) {
                boolean $i$a$-require-EncryptionRequirement$Required$82 = false;
                String $i$a$-require-EncryptionRequirement$Required$82 = "supportedEncryptionMethods cannot be empty";
                throw new IllegalArgumentException($i$a$-require-EncryptionRequirement$Required$82.toString());
            }
            if (!Companion.getSUPPORTED_ENCRYPTION_METHODS().containsAll((Collection)this.supportedEncryptionMethods)) {
                boolean $i$a$-require-EncryptionRequirement$Required$92 = false;
                String $i$a$-require-EncryptionRequirement$Required$92 = "only the following EncryptionMethods are supported: " + Companion.getSUPPORTED_ENCRYPTION_METHODS();
                throw new IllegalArgumentException($i$a$-require-EncryptionRequirement$Required$92.toString());
            }
            if (!Companion.getSUPPORTED_EPHEMERAL_ENCRYPTION_KEY_CURVES().contains(this.ephemeralEncryptionKeyCurve)) {
                boolean bl = false;
                String string = "only the following Curves are supported: " + Companion.getSUPPORTED_EPHEMERAL_ENCRYPTION_KEY_CURVES();
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final List<JWEAlgorithm> getSupportedEncryptionAlgorithms() {
            return this.supportedEncryptionAlgorithms;
        }

        @NotNull
        public final List<EncryptionMethod> getSupportedEncryptionMethods() {
            return this.supportedEncryptionMethods;
        }

        @NotNull
        public final Curve getEphemeralEncryptionKeyCurve() {
            return this.ephemeralEncryptionKeyCurve;
        }

        @NotNull
        public final List<JWEAlgorithm> component1() {
            return this.supportedEncryptionAlgorithms;
        }

        @NotNull
        public final List<EncryptionMethod> component2() {
            return this.supportedEncryptionMethods;
        }

        @NotNull
        public final Curve component3() {
            return this.ephemeralEncryptionKeyCurve;
        }

        @NotNull
        public final Required copy(@NotNull List<JWEAlgorithm> supportedEncryptionAlgorithms, @NotNull List<EncryptionMethod> supportedEncryptionMethods, @NotNull Curve ephemeralEncryptionKeyCurve) {
            Intrinsics.checkNotNullParameter(supportedEncryptionAlgorithms, (String)"supportedEncryptionAlgorithms");
            Intrinsics.checkNotNullParameter(supportedEncryptionMethods, (String)"supportedEncryptionMethods");
            Intrinsics.checkNotNullParameter((Object)ephemeralEncryptionKeyCurve, (String)"ephemeralEncryptionKeyCurve");
            return new Required(supportedEncryptionAlgorithms, supportedEncryptionMethods, ephemeralEncryptionKeyCurve);
        }

        public static /* synthetic */ Required copy$default(Required required, List list, List list2, Curve curve, int n, Object object) {
            if ((n & 1) != 0) {
                list = required.supportedEncryptionAlgorithms;
            }
            if ((n & 2) != 0) {
                list2 = required.supportedEncryptionMethods;
            }
            if ((n & 4) != 0) {
                curve = required.ephemeralEncryptionKeyCurve;
            }
            return required.copy(list, list2, curve);
        }

        @NotNull
        public String toString() {
            return "Required(supportedEncryptionAlgorithms=" + this.supportedEncryptionAlgorithms + ", supportedEncryptionMethods=" + this.supportedEncryptionMethods + ", ephemeralEncryptionKeyCurve=" + this.ephemeralEncryptionKeyCurve + ")";
        }

        public int hashCode() {
            int result = ((Object)this.supportedEncryptionAlgorithms).hashCode();
            result = result * 31 + ((Object)this.supportedEncryptionMethods).hashCode();
            result = result * 31 + this.ephemeralEncryptionKeyCurve.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Required)) {
                return false;
            }
            Required required = (Required)other;
            if (!Intrinsics.areEqual(this.supportedEncryptionAlgorithms, required.supportedEncryptionAlgorithms)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.supportedEncryptionMethods, required.supportedEncryptionMethods)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ephemeralEncryptionKeyCurve, (Object)required.ephemeralEncryptionKeyCurve);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u000f"}, d2={"Leu/europa/ec/eudi/openid4vp/EncryptionRequirement$Required$Companion;", "", "<init>", "()V", "SUPPORTED_ENCRYPTION_ALGORITHMS", "", "Lcom/nimbusds/jose/JWEAlgorithm;", "getSUPPORTED_ENCRYPTION_ALGORITHMS", "()Ljava/util/List;", "SUPPORTED_ENCRYPTION_METHODS", "Lcom/nimbusds/jose/EncryptionMethod;", "getSUPPORTED_ENCRYPTION_METHODS", "SUPPORTED_EPHEMERAL_ENCRYPTION_KEY_CURVES", "Lcom/nimbusds/jose/jwk/Curve;", "getSUPPORTED_EPHEMERAL_ENCRYPTION_KEY_CURVES", "eudi-lib-jvm-siop-openid4vp-kt"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final List<JWEAlgorithm> getSUPPORTED_ENCRYPTION_ALGORITHMS() {
                Set set = ECDHDecrypter.SUPPORTED_ALGORITHMS;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SUPPORTED_ALGORITHMS");
                return CollectionsKt.toList((Iterable)set);
            }

            @NotNull
            public final List<EncryptionMethod> getSUPPORTED_ENCRYPTION_METHODS() {
                Set set = ECDHDecrypter.SUPPORTED_ENCRYPTION_METHODS;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SUPPORTED_ENCRYPTION_METHODS");
                return CollectionsKt.toList((Iterable)set);
            }

            @NotNull
            public final List<Curve> getSUPPORTED_EPHEMERAL_ENCRYPTION_KEY_CURVES() {
                Set set = ECDHDecrypter.SUPPORTED_ELLIPTIC_CURVES;
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"SUPPORTED_ELLIPTIC_CURVES");
                return CollectionsKt.toList((Iterable)set);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

