/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.util.X509CertUtils;
import com.nimbusds.jwt.SignedJWT;
import eu.europa.ec.eudi.openid4vp.AuthorizationRequestResolverKt;
import eu.europa.ec.eudi.openid4vp.ConfigKt;
import eu.europa.ec.eudi.openid4vp.RequestValidationError;
import eu.europa.ec.eudi.openid4vp.SiopOpenId4VPConfig;
import eu.europa.ec.eudi.openid4vp.SupportedClientIdPrefix;
import eu.europa.ec.eudi.openid4vp.VerifierId;
import eu.europa.ec.eudi.openid4vp.X509CertificateTrust;
import eu.europa.ec.eudi.openid4vp.internal.Base64Kt;
import eu.europa.ec.eudi.openid4vp.internal.DID;
import eu.europa.ec.eudi.openid4vp.internal.X509SubjectAlternativeNameKt;
import eu.europa.ec.eudi.openid4vp.internal.request.AuthenticatedClient;
import eu.europa.ec.eudi.openid4vp.internal.request.ClientAuthenticator;
import eu.europa.ec.eudi.openid4vp.internal.request.ReceivedRequest;
import eu.europa.ec.eudi.openid4vp.internal.request.RequestAuthenticatorKt;
import eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequestObject;
import eu.europa.ec.eudi.openid4vp.internal.request.UriSupportKt;
import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.encoding.Base64;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0086@\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u0012\u0012\b\u0012\u00060\rj\u0002`\u000e\u0012\u0004\u0012\u00020\u000f0\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/ClientAuthenticator;", "", "siopOpenId4VPConfig", "Leu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig;", "<init>", "(Leu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig;)V", "authenticateClient", "Leu/europa/ec/eudi/openid4vp/internal/request/AuthenticatedClient;", "request", "Leu/europa/ec/eudi/openid4vp/internal/request/ReceivedRequest;", "(Leu/europa/ec/eudi/openid4vp/internal/request/ReceivedRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "originalClientIdAndPrefix", "Lkotlin/Pair;", "", "Leu/europa/ec/eudi/openid4vp/OriginalClientId;", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix;", "requestObject", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;", "x5c", "", "Ljava/security/cert/X509Certificate;", "Leu/europa/ec/eudi/openid4vp/internal/request/ReceivedRequest$Signed;", "trust", "Leu/europa/ec/eudi/openid4vp/X509CertificateTrust;", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nRequestAuthenticator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestAuthenticator.kt\neu/europa/ec/eudi/openid4vp/internal/request/ClientAuthenticator\n+ 2 ResultOps.kt\neu/europa/ec/eudi/openid4vp/internal/ResultOpsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Util.kt\neu/europa/ec/eudi/openid4vp/UtilKt\n*L\n1#1,407:1\n40#2,2:408\n40#2,2:410\n32#2,2:412\n32#2,2:414\n40#2,2:416\n32#2,2:418\n32#2,2:420\n40#2,2:422\n32#2,2:424\n32#2,2:426\n32#2,2:428\n40#2,2:430\n40#2,2:433\n40#2,2:435\n32#2,2:456\n32#2,2:458\n1#3:432\n1#3:453\n1617#4,9:437\n1869#4:446\n1870#4:454\n1626#4:455\n21#5,6:447\n*S KotlinDebug\n*F\n+ 1 RequestAuthenticator.kt\neu/europa/ec/eudi/openid4vp/internal/request/ClientAuthenticator\n*L\n102#1:408,2\n104#1:410,2\n112#1:412,2\n121#1:414,2\n124#1:416,2\n132#1:418,2\n141#1:420,2\n147#1:422,2\n148#1:424,2\n156#1:426,2\n164#1:428,2\n174#1:430,2\n178#1:433,2\n188#1:435,2\n190#1:456,2\n191#1:458,2\n189#1:453\n189#1:437,9\n189#1:446\n189#1:454\n189#1:455\n189#1:447,6\n*E\n"})
public final class ClientAuthenticator {
    @NotNull
    private final SiopOpenId4VPConfig siopOpenId4VPConfig;

    public ClientAuthenticator(@NotNull SiopOpenId4VPConfig siopOpenId4VPConfig) {
        Intrinsics.checkNotNullParameter((Object)siopOpenId4VPConfig, (String)"siopOpenId4VPConfig");
        this.siopOpenId4VPConfig = siopOpenId4VPConfig;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object authenticateClient(@NotNull ReceivedRequest var1_1, @NotNull Continuation<? super AuthenticatedClient> $completion) {
        block29: {
            if (!($completion instanceof authenticateClient.1)) ** GOTO lbl-1000
            var14_3 = $completion;
            if ((var14_3.label & -2147483648) != 0) {
                var14_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ ClientAuthenticator this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.authenticateClient(null, (Continuation<? super AuthenticatedClient>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var4_6 = request;
                    if (var4_6 instanceof ReceivedRequest.Signed) {
                        v0 = RequestAuthenticatorKt.requestObject(RequestAuthenticatorKt.access$ensureSingleSignedRequest((ReceivedRequest.Signed)request));
                    } else if (var4_6 instanceof ReceivedRequest.Unsigned) {
                        v0 = ((ReceivedRequest.Unsigned)request).getRequestObject();
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    requestObject = v0;
                    var4_6 = this.originalClientIdAndPrefix(requestObject);
                    originalClientId = (String)var4_6.component1();
                    var7_10 = clientIdPrefix = (SupportedClientIdPrefix)var4_6.component2();
                    if (!(var7_10 instanceof SupportedClientIdPrefix.Preregistered)) ** GOTO lbl38
                    registeredClient = ((SupportedClientIdPrefix.Preregistered)clientIdPrefix).getClients().get(originalClientId);
                    $i$f$ensureNotNull = false;
                    if (registeredClient == null) {
                        $i$a$-ensureNotNull-ClientAuthenticator$authenticateClient$2 = false;
                        throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.InvalidClientId.INSTANCE);
                    }
                    if (request instanceof ReceivedRequest.Signed) {
                        value$iv = registeredClient.getJarConfig();
                        $i$f$ensureNotNull = false;
                        if (value$iv == null) {
                            $i$a$-ensureNotNull-ClientAuthenticator$authenticateClient$3 = false;
                            throw (Throwable)RequestAuthenticatorKt.access$invalidPrefix(registeredClient + " cannot place signed request");
                        }
                    }
                    v1 = new AuthenticatedClient.Preregistered(registeredClient);
                    break block29;
lbl38:
                    // 1 sources

                    if (!Intrinsics.areEqual((Object)var7_10, (Object)SupportedClientIdPrefix.RedirectUri.INSTANCE)) ** GOTO lbl49
                    value$iv = request instanceof ReceivedRequest.Unsigned;
                    $i$f$ensure = false;
                    if (!value$iv) {
                        $i$a$-ensure-ClientAuthenticator$authenticateClient$4 = false;
                        throw (Throwable)RequestAuthenticatorKt.access$invalidPrefix(clientIdPrefix.prefix() + " cannot be used in signed request");
                    }
                    $i$f$ensure = UriSupportKt.asURI(originalClientId, (Function1<? super Throwable, ? extends Throwable>)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, authenticateClient$lambda$3(java.lang.Throwable ), (Ljava/lang/Throwable;)Ljava/lang/Throwable;)());
                    ResultKt.throwOnFailure((Object)$i$f$ensure);
                    originalClientIdAsUri = (URI)$i$f$ensure;
                    v1 = new AuthenticatedClient.RedirectUri(originalClientIdAsUri);
                    break block29;
lbl49:
                    // 1 sources

                    if (!(var7_10 instanceof SupportedClientIdPrefix.DecentralizedIdentifier)) break;
                    value$iv = request instanceof ReceivedRequest.Signed;
                    $i$f$ensure = false;
                    if (!value$iv) {
                        $i$a$-ensure-ClientAuthenticator$authenticateClient$5 = false;
                        throw (Throwable)RequestAuthenticatorKt.access$invalidPrefix(clientIdPrefix.prefix() + " cannot be used in unsigned request");
                    }
                    $i$f$ensure = DID.Companion.parse-IoAF18A(originalClientId);
                    value$iv = Result.isFailure-impl((Object)$i$f$ensure) != false ? null : $i$f$ensure;
                    $i$f$ensureNotNull = false;
                    if (value$iv == null) {
                        $i$a$-ensureNotNull-ClientAuthenticator$authenticateClient$originalClientIdAsDID$1 = false;
                        throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.InvalidClientId.INSTANCE);
                    }
                    originalClientIdAsDID = ((DID)value$iv).unbox-impl();
                    $continuation.L$0 = originalClientIdAsDID;
                    $continuation.label = 1;
                    v2 = RequestAuthenticatorKt.access$lookupKeyByDID-N7EJtrs((ReceivedRequest.Signed)request, originalClientIdAsDID, ((SupportedClientIdPrefix.DecentralizedIdentifier)clientIdPrefix).getLookup(), (Continuation)$continuation);
                    if (v2 == var15_5) {
                        return var15_5;
                    }
                    ** GOTO lbl72
                }
                case 1: {
                    originalClientIdAsDID = (URI)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl72:
                    // 2 sources

                    clientPubKey = (PublicKey)v2;
                    v1 = new AuthenticatedClient.DecentralizedIdentifier(originalClientIdAsDID, clientPubKey, null);
                    break block29;
                }
            }
            if (var7_10 instanceof SupportedClientIdPrefix.VerifierAttestation) {
                value$iv = request instanceof ReceivedRequest.Signed;
                $i$f$ensure = false;
                if (!value$iv) {
                    $i$a$-ensure-ClientAuthenticator$authenticateClient$6 = false;
                    throw (Throwable)RequestAuthenticatorKt.access$invalidPrefix(clientIdPrefix.prefix() + " cannot be used in unsigned request");
                }
                attestedClaims = RequestAuthenticatorKt.access$verifierAttestation(this.siopOpenId4VPConfig.getClock(), (SupportedClientIdPrefix.VerifierAttestation)clientIdPrefix, (ReceivedRequest.Signed)request, originalClientId);
                v1 = new AuthenticatedClient.VerifierAttestation(originalClientId, attestedClaims);
            } else if (var7_10 instanceof SupportedClientIdPrefix.X509SanDns) {
                value$iv = request instanceof ReceivedRequest.Signed;
                $i$f$ensure = false;
                if (!value$iv) {
                    $i$a$-ensure-ClientAuthenticator$authenticateClient$7 = false;
                    throw (Throwable)RequestAuthenticatorKt.access$invalidPrefix(clientIdPrefix.prefix() + " cannot be used in unsigned request");
                }
                chain = this.x5c((ReceivedRequest.Signed)request, ((SupportedClientIdPrefix.X509SanDns)clientIdPrefix).getTrust());
                $i$a$-ensure-ClientAuthenticator$authenticateClient$7 = X509SubjectAlternativeNameKt.sanOfDNSName((X509Certificate)CollectionsKt.first(chain));
                alternativeNames = (List)(Result.isFailure-impl((Object)$i$a$-ensure-ClientAuthenticator$authenticateClient$7) != false ? null : $i$a$-ensure-ClientAuthenticator$authenticateClient$7);
                $i$f$ensureNotNull = false;
                if (alternativeNames == null) {
                    $i$a$-ensureNotNull-ClientAuthenticator$authenticateClient$8 = false;
                    throw (Throwable)RequestAuthenticatorKt.access$invalidJarJwt("Certificates misses DNS names");
                }
                value$iv = alternativeNames.contains(originalClientId);
                $i$f$ensure = false;
                if (!value$iv) {
                    $i$a$-ensure-ClientAuthenticator$authenticateClient$9 = false;
                    throw (Throwable)RequestAuthenticatorKt.access$invalidJarJwt("ClientId not found in certificate's subject alternative names");
                }
                v1 = new AuthenticatedClient.X509SanDns(originalClientId, chain);
            } else if (var7_10 instanceof SupportedClientIdPrefix.X509Hash) {
                value$iv = request instanceof ReceivedRequest.Signed;
                $i$f$ensure = false;
                if (!value$iv) {
                    $i$a$-ensure-ClientAuthenticator$authenticateClient$10 = false;
                    throw (Throwable)RequestAuthenticatorKt.access$invalidPrefix(clientIdPrefix.prefix() + " cannot be used in unsigned request");
                }
                chain = this.x5c((ReceivedRequest.Signed)request, ((SupportedClientIdPrefix.X509Hash)clientIdPrefix).getTrust());
                v3 = Base64Kt.getBase64UrlNoPadding();
                v4 = MessageDigest.getInstance("SHA-256").digest(((X509Certificate)CollectionsKt.first(chain)).getEncoded());
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"digest(...)");
                expectedHash = Base64.encode$default((Base64)v3, (byte[])v4, (int)0, (int)0, (int)6, null);
                value$iv = Intrinsics.areEqual((Object)expectedHash, (Object)originalClientId);
                $i$f$ensure = false;
                if (!value$iv) {
                    $i$a$-ensure-ClientAuthenticator$authenticateClient$11 = false;
                    throw (Throwable)RequestAuthenticatorKt.access$invalidJarJwt("ClientId does not match leaf certificate's SHA-256 hash");
                }
                v1 = new AuthenticatedClient.X509Hash(originalClientId, chain);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return v1;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Pair<String, SupportedClientIdPrefix> originalClientIdAndPrefix(UnvalidatedRequestObject requestObject) {
        String value$iv = requestObject.getClientId();
        boolean $i$f$ensureNotNull22 = false;
        if (value$iv == null) {
            boolean bl = false;
            throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.MissingClientId.INSTANCE);
        }
        String clientId = value$iv;
        Object $i$f$ensureNotNull22 = VerifierId.Companion.parse-IoAF18A(clientId);
        Throwable throwable = Result.exceptionOrNull-impl((Object)$i$f$ensureNotNull22);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw RequestAuthenticatorKt.access$invalidPrefix("Invalid client_id: " + it.getMessage());
        }
        VerifierId verifierId = (VerifierId)$i$f$ensureNotNull22;
        SupportedClientIdPrefix supportedClientIdPrefix = ConfigKt.supportedClientIdPrefix(this.siopOpenId4VPConfig, verifierId.getPrefix());
        boolean $i$f$ensureNotNull = false;
        if (supportedClientIdPrefix == null) {
            boolean bl = false;
            throw (Throwable)AuthorizationRequestResolverKt.asException(RequestValidationError.UnsupportedClientIdPrefix.INSTANCE);
        }
        return TuplesKt.to((Object)verifierId.getOriginalClientId(), (Object)supportedClientIdPrefix);
    }

    /*
     * WARNING - void declaration
     */
    private final List<X509Certificate> x5c(ReceivedRequest.Signed request, X509CertificateTrust trust) {
        boolean value$iv;
        void $this$mapNotNullTo$iv$iv;
        SignedJWT jwt = RequestAuthenticatorKt.access$ensureSingleSignedRequest(request);
        JWSHeader jWSHeader = jwt.getHeader();
        List x5c = jWSHeader != null ? jWSHeader.getX509CertChain() : null;
        boolean $i$f$ensureNotNull = false;
        if (x5c == null) {
            boolean bl = false;
            throw (Throwable)RequestAuthenticatorKt.access$invalidJarJwt("Missing x5c");
        }
        Iterable $this$mapNotNull$iv22 = x5c;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv22;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            X509Certificate it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            com.nimbusds.jose.util.Base64 it = (com.nimbusds.jose.util.Base64)element$iv$iv;
            boolean bl2 = false;
            boolean $i$f$runCatchingCancellable = false;
            try {
                boolean bl3 = false;
                object = Result.constructor-impl((Object)X509CertUtils.parse((byte[])it.decode()));
            }
            catch (CancellationException ce$iv) {
                throw ce$iv;
            }
            catch (Exception e$iv) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
            }
            Object object2 = object;
            if ((X509Certificate)(Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List pubCertChain = (List)destination$iv$iv;
        boolean $this$mapNotNull$iv22 = !((Collection)pubCertChain).isEmpty();
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)RequestAuthenticatorKt.access$invalidJarJwt("Invalid x5c");
        }
        value$iv = trust.isTrusted(pubCertChain);
        $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)RequestAuthenticatorKt.access$invalidJarJwt("Untrusted x5c");
        }
        return pubCertChain;
    }

    private static final Throwable authenticateClient$lambda$3(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return AuthorizationRequestResolverKt.asException(RequestValidationError.InvalidClientId.INSTANCE);
    }
}

