/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.jwk.JWK;
import eu.europa.ec.eudi.openid4vp.AuthorizationRequestException;
import eu.europa.ec.eudi.openid4vp.AuthorizationRequestResolverKt;
import eu.europa.ec.eudi.openid4vp.RequestValidationError;
import eu.europa.ec.eudi.openid4vp.ResponseEncryptionConfiguration;
import eu.europa.ec.eudi.openid4vp.ResponseMode;
import eu.europa.ec.eudi.openid4vp.TypesKt;
import eu.europa.ec.eudi.openid4vp.VpFormatsSupported;
import eu.europa.ec.eudi.openid4vp.dcql.DCQL;
import eu.europa.ec.eudi.openid4vp.internal.request.ClientMetaDataValidatorKt;
import eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedClientMetaData;
import eu.europa.ec.eudi.openid4vp.internal.request.ValidatedClientMetaData;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/request/ClientMetaDataValidator;", "", "<init>", "()V", "validateClientMetaData", "Leu/europa/ec/eudi/openid4vp/internal/request/ValidatedClientMetaData;", "unvalidated", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedClientMetaData;", "responseMode", "Leu/europa/ec/eudi/openid4vp/ResponseMode;", "query", "Leu/europa/ec/eudi/openid4vp/dcql/DCQL;", "responseEncryptionConfiguration", "Leu/europa/ec/eudi/openid4vp/ResponseEncryptionConfiguration;", "walletSupportedVpFormats", "Leu/europa/ec/eudi/openid4vp/VpFormatsSupported;", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nClientMetaDataValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientMetaDataValidator.kt\neu/europa/ec/eudi/openid4vp/internal/request/ClientMetaDataValidator\n+ 2 ResultOps.kt\neu/europa/ec/eudi/openid4vp/internal/ResultOpsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n32#2,2:294\n40#2,2:296\n827#3:298\n855#3,2:299\n*S KotlinDebug\n*F\n+ 1 ClientMetaDataValidator.kt\neu/europa/ec/eudi/openid4vp/internal/request/ClientMetaDataValidator\n*L\n53#1:294,2\n60#1:296,2\n67#1:298\n67#1:299,2\n*E\n"})
public final class ClientMetaDataValidator {
    @NotNull
    public static final ClientMetaDataValidator INSTANCE = new ClientMetaDataValidator();

    private ClientMetaDataValidator() {
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ValidatedClientMetaData validateClientMetaData(@NotNull UnvalidatedClientMetaData unvalidated, @NotNull ResponseMode responseMode, @Nullable DCQL query, @NotNull ResponseEncryptionConfiguration responseEncryptionConfiguration, @NotNull VpFormatsSupported walletSupportedVpFormats) throws AuthorizationRequestException {
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)unvalidated, (String)"unvalidated");
                Intrinsics.checkNotNullParameter((Object)responseMode, (String)"responseMode");
                Intrinsics.checkNotNullParameter((Object)responseEncryptionConfiguration, (String)"responseEncryptionConfiguration");
                Intrinsics.checkNotNullParameter((Object)walletSupportedVpFormats, (String)"walletSupportedVpFormats");
                types = ClientMetaDataValidatorKt.access$subjectSyntaxTypes(unvalidated.getSubjectSyntaxTypesSupported());
                verifierAdvertisedJwkSet = ClientMetaDataValidatorKt.access$jwks(unvalidated);
                verifierSupportedEncryptionMethods = ClientMetaDataValidatorKt.access$responseEncryptionMethodsSupported(unvalidated);
                if (TypesKt.requiresEncryption(responseMode)) break block6;
                value$iv = verifierSupportedEncryptionMethods == null;
                $i$f$ensure = false;
                if (!value$iv) {
                    $i$a$-ensure-ClientMetaDataValidator$validateClientMetaData$responseEncryptionSpecification$1 = false;
                    throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidClientMetaData("'encrypted_response_enc_values_supported' must not be provided when encryption is not required"));
                }
                v0 = null;
                break block7;
            }
            $i$f$ensureNotNull = false;
            if (verifierAdvertisedJwkSet == null) {
                $i$a$-ensureNotNull-ClientMetaDataValidator$validateClientMetaData$responseEncryptionSpecification$2 = false;
                throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidClientMetaData("'jwks' must be provided when encryption is required"));
            }
            v1 = verifierAdvertisedJwkSet.getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getKeys(...)");
            $i$a$-ensureNotNull-ClientMetaDataValidator$validateClientMetaData$responseEncryptionSpecification$2 = v1;
            $i$f$filterNot = false;
            var13_18 = $this$filterNot$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterNotTo = false;
            for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (JWK)element$iv$iv;
                $i$a$-filterNot-ClientMetaDataValidator$validateClientMetaData$responseEncryptionSpecification$verifierCandidateEncryptionKeys$1 = false;
                var20_25 = it.getKeyID();
                if (var20_25 == null || StringsKt.isBlank((CharSequence)var20_25) != false) ** GOTO lbl-1000
                v2 = it.getAlgorithm();
                var20_25 = v2 != null ? v2.getName() : null;
                if (var20_25 == null || StringsKt.isBlank((CharSequence)var20_25) != false) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = false;
                }
                if (v3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            verifierCandidateEncryptionKeys = (List)destination$iv$iv;
            v4 = verifierSupportedEncryptionMethods;
            if (v4 == null) {
                v4 = SetsKt.setOf((Object)EncryptionMethod.parse((String)"A128GCM"));
            }
            v0 = ClientMetaDataValidatorKt.access$responseEncryptionSpecification(responseEncryptionConfiguration, verifierCandidateEncryptionKeys, v4);
        }
        responseEncryptionSpecification = v0;
        v5 = query;
        vpFormatsSupported = v5 != null ? ClientMetaDataValidatorKt.access$vpFormats(unvalidated, v5, walletSupportedVpFormats) : unvalidated.getVpFormatsSupported();
        return new ValidatedClientMetaData(responseEncryptionSpecification, types, vpFormatsSupported);
    }
}

