/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import eu.europa.ec.eudi.openid4vp.AuthorizationRequestException;
import eu.europa.ec.eudi.openid4vp.AuthorizationRequestResolverKt;
import eu.europa.ec.eudi.openid4vp.CoseAlgorithm;
import eu.europa.ec.eudi.openid4vp.Format;
import eu.europa.ec.eudi.openid4vp.RequestValidationError;
import eu.europa.ec.eudi.openid4vp.ResolutionError;
import eu.europa.ec.eudi.openid4vp.ResponseEncryptionConfiguration;
import eu.europa.ec.eudi.openid4vp.ResponseEncryptionSpecification;
import eu.europa.ec.eudi.openid4vp.SubjectSyntaxType;
import eu.europa.ec.eudi.openid4vp.TypesKt;
import eu.europa.ec.eudi.openid4vp.VpFormatsSupported;
import eu.europa.ec.eudi.openid4vp.dcql.CredentialQuery;
import eu.europa.ec.eudi.openid4vp.dcql.DCQL;
import eu.europa.ec.eudi.openid4vp.internal.JsonKt;
import eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedClientMetaData;
import eu.europa.ec.eudi.openid4vp.internal.response.EncrypterFactory;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u000e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0001H\u0002\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fH\u0002\u001a,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u001e2\u0006\u0010\u001c\u001a\u00020\u001eH\u0002\u00a8\u0006\u001f"}, d2={"subjectSyntaxTypes", "", "Leu/europa/ec/eudi/openid4vp/SubjectSyntaxType;", "subjectSyntaxTypesSupported", "", "parseSubjectSyntaxType", "value", "jwks", "Lcom/nimbusds/jose/jwk/JWKSet;", "unvalidated", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedClientMetaData;", "responseEncryptionMethodsSupported", "", "Lcom/nimbusds/jose/EncryptionMethod;", "vpFormats", "Leu/europa/ec/eudi/openid4vp/VpFormatsSupported;", "query", "Leu/europa/ec/eudi/openid4vp/dcql/DCQL;", "walletSupportedVpFormats", "responseEncryptionSpecification", "Leu/europa/ec/eudi/openid4vp/ResponseEncryptionSpecification;", "walletConfiguration", "Leu/europa/ec/eudi/openid4vp/ResponseEncryptionConfiguration;", "verifierCandidateEncryptionKeys", "Lcom/nimbusds/jose/jwk/JWK;", "verifierSupportedEncryptionMethods", "resolveCommonGround", "walletSupported", "verifierSupported", "Leu/europa/ec/eudi/openid4vp/VpFormatsSupported$SdJwtVc;", "Leu/europa/ec/eudi/openid4vp/VpFormatsSupported$MsoMdoc;", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nClientMetaDataValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientMetaDataValidator.kt\neu/europa/ec/eudi/openid4vp/internal/request/ClientMetaDataValidatorKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ResultOps.kt\neu/europa/ec/eudi/openid4vp/internal/ResultOpsKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 Json.kt\nkotlinx/serialization/json/Json\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,293:1\n1563#2:294\n1634#2,3:295\n1563#2:300\n1634#2,3:301\n1563#2:306\n1634#2,3:307\n1563#2:312\n1634#2,3:313\n295#2,2:322\n295#2,2:326\n1761#2,3:333\n1761#2,3:339\n32#3,2:298\n32#3,2:304\n32#3,2:310\n32#3,2:316\n32#3,2:318\n32#3,2:320\n32#3,2:324\n32#3,2:328\n40#3,2:344\n40#3,2:346\n1104#4,3:330\n1104#4,3:336\n205#5:342\n1#6:343\n*S KotlinDebug\n*F\n+ 1 ClientMetaDataValidator.kt\neu/europa/ec/eudi/openid4vp/internal/request/ClientMetaDataValidatorKt\n*L\n94#1:294\n94#1:295,3\n133#1:300\n133#1:301,3\n143#1:306\n143#1:307,3\n160#1:312\n160#1:313,3\n197#1:322,2\n207#1:326,2\n99#1:333,3\n106#1:339,3\n129#1:298,2\n134#1:304,2\n145#1:310,2\n161#1:316,2\n188#1:318,2\n192#1:320,2\n201#1:324,2\n239#1:328,2\n257#1:344,2\n281#1:346,2\n99#1:330,3\n104#1:336,3\n122#1:342\n*E\n"})
public final class ClientMetaDataValidatorKt {
    /*
     * WARNING - void declaration
     */
    private static final List<SubjectSyntaxType> subjectSyntaxTypes(List<String> subjectSyntaxTypesSupported) {
        List list;
        List<String> list2 = subjectSyntaxTypesSupported;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(ClientMetaDataValidatorKt.subjectSyntaxTypes$subjectSyntax((String)it));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private static final SubjectSyntaxType parseSubjectSyntaxType(String value) {
        return ClientMetaDataValidatorKt.parseSubjectSyntaxType$isJWKThumbprint(value) ? (SubjectSyntaxType)SubjectSyntaxType.JWKThumbprint.INSTANCE : (ClientMetaDataValidatorKt.parseSubjectSyntaxType$isDecentralizedIdentifier(value) ? SubjectSyntaxType.DecentralizedIdentifier.box-impl(ClientMetaDataValidatorKt.parseSubjectSyntaxType$parseDecentralizedIdentifier(value)) : null);
    }

    /*
     * WARNING - void declaration
     */
    private static final JWKSet jwks(UnvalidatedClientMetaData unvalidated) {
        JWKSet jwkSet;
        JsonObject jsonObject = unvalidated.getJwks();
        Object object = jwkSet = jsonObject != null ? ClientMetaDataValidatorKt.jwks$asJWKSet(jsonObject) : null;
        if (jwkSet != null) {
            void $this$mapTo$iv$iv;
            List list = jwkSet.getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getKeys(...)");
            boolean value$iv = !((Collection)list).isEmpty();
            boolean $i$f$ensure = false;
            if (!value$iv) {
                boolean bl = false;
                throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidClientMetaData("'jwks' cannot be empty"));
            }
            List list2 = jwkSet.getKeys();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getKeys(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JWK jWK = (JWK)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKeyID());
            }
            List keyIds = (List)destination$iv$iv;
            boolean value$iv2 = keyIds.size() == CollectionsKt.toSet((Iterable)keyIds).size();
            boolean $i$f$ensure2 = false;
            if (!value$iv2) {
                boolean bl = false;
                throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidClientMetaData("Each JWK must have a unique `kid`"));
            }
        }
        return jwkSet;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<EncryptionMethod> responseEncryptionMethodsSupported(UnvalidatedClientMetaData unvalidated) {
        List encryptionMethods;
        List<String> list = unvalidated.getResponseEncryptionMethodsSupported();
        if (list != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(EncryptionMethod.parse((String)it));
            }
            v1 = (List)destination$iv$iv;
        } else {
            v1 = encryptionMethods = null;
        }
        if (encryptionMethods != null) {
            boolean value$iv = !((Collection)encryptionMethods).isEmpty();
            boolean $i$f$ensure = false;
            if (!value$iv) {
                boolean bl = false;
                throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidClientMetaData("'encrypted_response_enc_values_supported' must not be empty"));
            }
        }
        List list2 = encryptionMethods;
        return list2 != null ? CollectionsKt.toSet((Iterable)list2) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final VpFormatsSupported vpFormats(UnvalidatedClientMetaData unvalidated, DCQL query, VpFormatsSupported walletSupportedVpFormats) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = query.getCredentials-Mvz7B_Q();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void credential;
            CredentialQuery credentialQuery = (CredentialQuery)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Format.box-impl(credential.getFormat-mS_2FiM()));
        }
        Set queryFormats = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        boolean value$iv = TypesKt.containsAll(unvalidated.getVpFormatsSupported(), queryFormats);
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidClientMetaData("Verifier does not support all Formats requested in the DCQL query"));
        }
        VpFormatsSupported verifierQueryVpFormatsSupported = TypesKt.filter(unvalidated.getVpFormatsSupported(), queryFormats);
        return ClientMetaDataValidatorKt.resolveCommonGround(walletSupportedVpFormats, verifierQueryVpFormatsSupported);
    }

    /*
     * WARNING - void declaration
     */
    private static final ResponseEncryptionSpecification responseEncryptionSpecification(ResponseEncryptionConfiguration walletConfiguration, List<? extends JWK> verifierCandidateEncryptionKeys, Set<EncryptionMethod> verifierSupportedEncryptionMethods) throws AuthorizationRequestException {
        Pair pair;
        EncryptionMethod encryptionMethod;
        block10: {
            void value$iv;
            Object v0;
            boolean $i$f$ensure;
            block8: {
                boolean value$iv2 = walletConfiguration instanceof ResponseEncryptionConfiguration.Supported;
                $i$f$ensure = false;
                if (!value$iv2) {
                    boolean bl = false;
                    throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedClientMetaData("Wallet doesn't support encrypting authorization responses"));
                }
                value$iv2 = !((Collection)verifierSupportedEncryptionMethods).isEmpty();
                $i$f$ensure = false;
                if (!value$iv2) {
                    boolean bl = false;
                    throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidClientMetaData("No encryption methods were advertised by the Verifier in his Client Metadata"));
                }
                Iterable $this$firstOrNull$iv = ((ResponseEncryptionConfiguration.Supported)walletConfiguration).getSupportedMethods();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    EncryptionMethod it = (EncryptionMethod)element$iv;
                    boolean bl = false;
                    if (!verifierSupportedEncryptionMethods.contains(it)) continue;
                    v0 = element$iv;
                    break block8;
                }
                v0 = null;
            }
            EncryptionMethod encryptionMethod2 = v0;
            if (encryptionMethod2 == null) {
                throw AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedClientMetaData("Wallet doesn't support any of the encryption methods supported by Verifier"));
            }
            encryptionMethod = encryptionMethod2;
            $i$f$ensure = !((Collection)verifierCandidateEncryptionKeys).isEmpty();
            boolean $i$f$ensure2 = false;
            if (value$iv == false) {
                boolean bl = false;
                throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidClientMetaData("No encryption JWKs were advertised by the Verifier in his Client Metadata"));
            }
            for (JWEAlgorithm supportedAlgorithm : (Iterable)((ResponseEncryptionConfiguration.Supported)walletConfiguration).getSupportedAlgorithms()) {
                Object v3;
                block9: {
                    boolean bl = false;
                    Iterable $this$firstOrNull$iv = verifierCandidateEncryptionKeys;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        JWK key = (JWK)element$iv;
                        boolean bl2 = false;
                        Algorithm algorithm = key.getAlgorithm();
                        if (!(Intrinsics.areEqual((Object)supportedAlgorithm.getName(), (Object)(algorithm != null ? algorithm.getName() : null)) && EncrypterFactory.INSTANCE.canBeUsed(supportedAlgorithm, key))) continue;
                        v3 = element$iv;
                        break block9;
                    }
                    v3 = null;
                }
                JWK encryptionKey = v3;
                Pair pair2 = encryptionKey != null ? TuplesKt.to((Object)supportedAlgorithm, (Object)encryptionKey) : null;
                if (pair2 == null) continue;
                pair = pair2;
                break block10;
            }
            pair = null;
        }
        if (pair == null) {
            throw AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedClientMetaData("Wallet doesn't support any of the encryption algorithms supported by verifier"));
        }
        Pair pair3 = pair;
        JWEAlgorithm encryptionAlgorithm = (JWEAlgorithm)pair3.component1();
        JWK encryptionKey = (JWK)pair3.component2();
        return new ResponseEncryptionSpecification(encryptionAlgorithm, encryptionMethod, encryptionKey);
    }

    private static final VpFormatsSupported resolveCommonGround(VpFormatsSupported walletSupported, VpFormatsSupported verifierSupported) {
        VpFormatsSupported.MsoMdoc msoMdoc;
        VpFormatsSupported.SdJwtVc sdJwtVc;
        if (verifierSupported.getSdJwtVc() != null) {
            VpFormatsSupported.SdJwtVc sdJwtVc2 = walletSupported.getSdJwtVc();
            if (sdJwtVc2 != null) {
                VpFormatsSupported.SdJwtVc it = sdJwtVc2;
                boolean bl = false;
                v1 = ClientMetaDataValidatorKt.resolveCommonGround(it, verifierSupported.getSdJwtVc());
            } else {
                v1 = null;
            }
        } else {
            v1 = sdJwtVc = null;
        }
        if (verifierSupported.getMsoMdoc() != null) {
            VpFormatsSupported.MsoMdoc msoMdoc2 = walletSupported.getMsoMdoc();
            if (msoMdoc2 != null) {
                VpFormatsSupported.MsoMdoc it = msoMdoc2;
                boolean bl = false;
                msoMdoc = ClientMetaDataValidatorKt.resolveCommonGround(it, verifierSupported.getMsoMdoc());
            } else {
                msoMdoc = null;
            }
        } else {
            msoMdoc = null;
        }
        VpFormatsSupported.MsoMdoc msoMdoc3 = msoMdoc;
        boolean value$iv = sdJwtVc != null || msoMdoc3 != null;
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)AuthorizationRequestResolverKt.asException(ResolutionError.ClientVpFormatsNotSupportedFromWallet.INSTANCE);
        }
        return new VpFormatsSupported(sdJwtVc, msoMdoc3);
    }

    private static final VpFormatsSupported.SdJwtVc resolveCommonGround(VpFormatsSupported.SdJwtVc walletSupported, VpFormatsSupported.SdJwtVc verifierSupported) {
        List<JWSAlgorithm> sdJwtAlgorithms = ClientMetaDataValidatorKt.resolveCommonGround$common(walletSupported.getSdJwtAlgorithms(), verifierSupported.getSdJwtAlgorithms());
        List<JWSAlgorithm> kbJwtAlgorithms = ClientMetaDataValidatorKt.resolveCommonGround$common(walletSupported.getKbJwtAlgorithms(), verifierSupported.getKbJwtAlgorithms());
        return new VpFormatsSupported.SdJwtVc(sdJwtAlgorithms, kbJwtAlgorithms);
    }

    private static final VpFormatsSupported.MsoMdoc resolveCommonGround(VpFormatsSupported.MsoMdoc walletSupported, VpFormatsSupported.MsoMdoc verifierSupported) {
        List<CoseAlgorithm> issuerAuthAlgorithms = ClientMetaDataValidatorKt.resolveCommonGround$common$25(walletSupported.getIssuerAuthAlgorithms(), verifierSupported.getIssuerAuthAlgorithms());
        List<CoseAlgorithm> deviceAuthAlgorithms = ClientMetaDataValidatorKt.resolveCommonGround$common$25(walletSupported.getDeviceAuthAlgorithms(), verifierSupported.getDeviceAuthAlgorithms());
        return new VpFormatsSupported.MsoMdoc(issuerAuthAlgorithms, deviceAuthAlgorithms);
    }

    private static final SubjectSyntaxType subjectSyntaxTypes$subjectSyntax(String value) {
        SubjectSyntaxType subjectSyntaxType = ClientMetaDataValidatorKt.parseSubjectSyntaxType(value);
        if (subjectSyntaxType == null) {
            throw AuthorizationRequestResolverKt.asException(RequestValidationError.SubjectSyntaxTypesWrongSyntax.INSTANCE);
        }
        return subjectSyntaxType;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean parseSubjectSyntaxType$isDecentralizedIdentifier(String $value) {
        boolean bl;
        void var3_3;
        if (((CharSequence)$value).length() == 0) {
            return false;
        }
        boolean bl2 = false;
        if (bl2) return false;
        Object $this$count$iv = $value;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl3 = false;
            if (!(it == ':')) continue;
            ++count$iv;
        }
        if (var3_3 != true) return false;
        $this$count$iv = new char[1];
        $this$count$iv[0] = 58;
        Iterable $this$any$iv = StringsKt.split$default((CharSequence)$value, (char[])$this$count$iv, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl4 = false;
            if (((CharSequence)it).length() == 0) {
                return false;
            }
            bl = false;
        } while (!bl);
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final String parseSubjectSyntaxType$parseDecentralizedIdentifier(String $value) {
        boolean bl;
        block7: {
            void var3_3;
            if (((CharSequence)$value).length() == 0) {
                throw new IllegalStateException(("Cannot create DID from " + $value + ": Empty value passed").toString());
            }
            Object $this$count$iv = $value;
            boolean $i$f$count = false;
            int count$iv = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$count$iv.charAt(i);
                boolean bl2 = false;
                if (!(it == ':')) continue;
                ++count$iv;
            }
            if (var3_3 != true) {
                throw new IllegalStateException(("Cannot create DID from " + $value + ": Wrong syntax").toString());
            }
            $this$count$iv = new char[1];
            $this$count$iv[0] = 58;
            Iterable $this$any$iv = StringsKt.split$default((CharSequence)$value, (char[])$this$count$iv, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    boolean bl4 = ((CharSequence)it).length() == 0;
                    if (!bl4) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new IllegalStateException(("Cannot create DID from " + $value + ": DID components cannot be empty").toString());
        }
        char[] cArray = new char[]{':'};
        return SubjectSyntaxType.DecentralizedIdentifier.constructor-impl((String)StringsKt.split$default((CharSequence)$value, (char[])cArray, (boolean)false, (int)0, (int)6, null).get(1));
    }

    private static final boolean parseSubjectSyntaxType$isJWKThumbprint(String $value) {
        return !Intrinsics.areEqual((Object)$value, (Object)"urn:ietf:params:oauth:jwk-thumbprint:");
    }

    private static final JWKSet jwks$asJWKSet(JsonObject $this$jwks_u24asJWKSet) {
        JWKSet jWKSet;
        try {
            Json this_$iv = JsonKt.getJsonSupport();
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            jWKSet = JWKSet.parse((String)this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)$this$jwks_u24asJWKSet));
            Intrinsics.checkNotNull((Object)jWKSet);
        }
        catch (ParseException ex) {
            throw AuthorizationRequestResolverKt.asException(new ResolutionError.ClientMetadataJwksUnparsable(ex));
        }
        return jWKSet;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<JWSAlgorithm> resolveCommonGround$common(List<JWSAlgorithm> walletSupported, List<JWSAlgorithm> verifierSupported) {
        List<JWSAlgorithm> list;
        if (walletSupported != null && verifierSupported != null) {
            void var2_7;
            List list2;
            List it = list2 = CollectionsKt.toList((Iterable)CollectionsKt.intersect((Iterable)walletSupported, (Iterable)verifierSupported));
            boolean bl = false;
            List common = !((Collection)it).isEmpty() ? list2 : null;
            boolean $i$f$ensureNotNull = false;
            if (common == null) {
                boolean bl2 = false;
                throw (Throwable)AuthorizationRequestResolverKt.asException(ResolutionError.ClientVpFormatsNotSupportedFromWallet.INSTANCE);
            }
            list = var2_7;
        } else {
            list = verifierSupported;
            if (list == null) {
                list = walletSupported;
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<CoseAlgorithm> resolveCommonGround$common$25(List<CoseAlgorithm> walletSupported, List<CoseAlgorithm> verifierSupported) {
        List<CoseAlgorithm> list;
        if (walletSupported != null && verifierSupported != null) {
            void var2_7;
            List list2;
            List it = list2 = CollectionsKt.toList((Iterable)CollectionsKt.intersect((Iterable)walletSupported, (Iterable)verifierSupported));
            boolean bl = false;
            List common = !((Collection)it).isEmpty() ? list2 : null;
            boolean $i$f$ensureNotNull = false;
            if (common == null) {
                boolean bl2 = false;
                throw (Throwable)AuthorizationRequestResolverKt.asException(ResolutionError.ClientVpFormatsNotSupportedFromWallet.INSTANCE);
            }
            list = var2_7;
        } else {
            list = verifierSupported;
            if (list == null) {
                list = walletSupported;
            }
        }
        return list;
    }

    public static final /* synthetic */ List access$subjectSyntaxTypes(List subjectSyntaxTypesSupported) {
        return ClientMetaDataValidatorKt.subjectSyntaxTypes(subjectSyntaxTypesSupported);
    }

    public static final /* synthetic */ JWKSet access$jwks(UnvalidatedClientMetaData unvalidated) {
        return ClientMetaDataValidatorKt.jwks(unvalidated);
    }

    public static final /* synthetic */ Set access$responseEncryptionMethodsSupported(UnvalidatedClientMetaData unvalidated) {
        return ClientMetaDataValidatorKt.responseEncryptionMethodsSupported(unvalidated);
    }

    public static final /* synthetic */ ResponseEncryptionSpecification access$responseEncryptionSpecification(ResponseEncryptionConfiguration walletConfiguration, List verifierCandidateEncryptionKeys, Set verifierSupportedEncryptionMethods) {
        return ClientMetaDataValidatorKt.responseEncryptionSpecification(walletConfiguration, verifierCandidateEncryptionKeys, verifierSupportedEncryptionMethods);
    }

    public static final /* synthetic */ VpFormatsSupported access$vpFormats(UnvalidatedClientMetaData unvalidated, DCQL query, VpFormatsSupported walletSupportedVpFormats) {
        return ClientMetaDataValidatorKt.vpFormats(unvalidated, query, walletSupportedVpFormats);
    }
}

