/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.SignedJWT;
import eu.europa.ec.eudi.openid4vp.ErrorDispatchDetails;
import eu.europa.ec.eudi.openid4vp.ResponseEncryptionSpecification;
import eu.europa.ec.eudi.openid4vp.ResponseMode;
import eu.europa.ec.eudi.openid4vp.SiopOpenId4VPConfig;
import eu.europa.ec.eudi.openid4vp.VerifierId;
import eu.europa.ec.eudi.openid4vp.internal.Base64Kt;
import eu.europa.ec.eudi.openid4vp.internal.Base64UrlNoPadding;
import eu.europa.ec.eudi.openid4vp.internal.JsonKt;
import eu.europa.ec.eudi.openid4vp.internal.JwsJson;
import eu.europa.ec.eudi.openid4vp.internal.request.ClientMetaDataValidator;
import eu.europa.ec.eudi.openid4vp.internal.request.ReceivedRequest;
import eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedClientMetaData;
import eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequestObject;
import eu.europa.ec.eudi.openid4vp.internal.request.ValidatedClientMetaData;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserKt;
import io.ktor.http.Url;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\u0012\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b*\u00020\tH\u0000\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a)\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0001*\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u0016\u001a\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0011H\u0002\u001a\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\f\u0010\u0018\u001a\u00020\u0019*\u00020\u001aH\u0002\u00a8\u0006\u001b"}, d2={"from", "Lkotlin/Result;", "Leu/europa/ec/eudi/openid4vp/internal/JwsJson;", "Leu/europa/ec/eudi/openid4vp/internal/JwsJson$Companion;", "signedJwt", "Lcom/nimbusds/jwt/SignedJWT;", "(Leu/europa/ec/eudi/openid4vp/internal/JwsJson$Companion;Lcom/nimbusds/jwt/SignedJWT;)Ljava/lang/Object;", "toSignedJwts", "", "Leu/europa/ec/eudi/openid4vp/internal/request/ReceivedRequest$Signed;", "dispatchDetailsOrNull", "Leu/europa/ec/eudi/openid4vp/ErrorDispatchDetails;", "fetchedRequest", "Leu/europa/ec/eudi/openid4vp/internal/request/ReceivedRequest;", "siopOpenId4VPConfig", "Leu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig;", "unvalidatedRequest", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;", "responseEncryptionSpecification", "Leu/europa/ec/eudi/openid4vp/ResponseEncryptionSpecification;", "responseMode", "Leu/europa/ec/eudi/openid4vp/ResponseMode;", "(Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;Leu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig;Leu/europa/ec/eudi/openid4vp/ResponseMode;)Ljava/lang/Object;", "jwsJson", "toKtorUrl", "Lio/ktor/http/Url;", "Ljava/net/URI;", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nDefaultAuthorizationRequestResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultAuthorizationRequestResolver.kt\neu/europa/ec/eudi/openid4vp/internal/request/DefaultAuthorizationRequestResolverKt\n+ 2 Util.kt\neu/europa/ec/eudi/openid4vp/UtilKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Json.kt\nkotlinx/serialization/json/JsonKt\n+ 6 RFC7515Spec.kt\neu/europa/ec/eudi/openid4vp/internal/RFC7515SpecKt\n+ 7 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,371:1\n21#2,2:372\n23#2,4:375\n21#2,2:383\n23#2,4:386\n21#2,2:390\n23#2,4:397\n21#2,6:401\n21#2,6:407\n1#3:374\n1563#4:379\n1634#4,3:380\n335#5:385\n159#6:392\n155#6,2:393\n157#6:396\n222#7:395\n*S KotlinDebug\n*F\n+ 1 DefaultAuthorizationRequestResolver.kt\neu/europa/ec/eudi/openid4vp/internal/request/DefaultAuthorizationRequestResolverKt\n*L\n210#1:372,2\n210#1:375,4\n321#1:383,2\n321#1:386,4\n363#1:390,2\n363#1:397,4\n340#1:401,6\n345#1:407,6\n218#1:379\n218#1:380,3\n323#1:385\n365#1:392\n365#1:393,2\n365#1:396\n365#1:395\n*E\n"})
public final class DefaultAuthorizationRequestResolverKt {
    private static final Object from(JwsJson.Companion $this$from, SignedJWT signedJwt) {
        Object object;
        boolean $i$f$runCatchingCancellable = false;
        try {
            boolean bl = false;
            if (!(signedJwt.getState() == JWSObject.State.SIGNED)) {
                boolean bl2 = false;
                String string = "JWS is not signed";
                throw new IllegalArgumentException(string.toString());
            }
            String compactFormString = signedJwt.getHeader().toBase64URL() + "." + signedJwt.getPayload().toBase64URL() + "." + signedJwt.getSignature();
            Object object2 = JwsJson.Companion.from-IoAF18A(compactFormString);
            ResultKt.throwOnFailure((Object)object2);
            object = Result.constructor-impl((Object)((JwsJson)object2));
        }
        catch (CancellationException ce$iv) {
            throw ce$iv;
        }
        catch (Exception e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SignedJWT> toSignedJwts(@NotNull ReceivedRequest.Signed $this$toSignedJwts) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$toSignedJwts, (String)"<this>");
        Iterable $this$map$iv = JwsJson.Companion.flatten($this$toSignedJwts.getJwsJson());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            JwsJson.Flattened flattened = (JwsJson.Flattened)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getProtected-jCRXw3M();
            collection.add(SignedJWT.parse((String)((string == null ? "null" : Base64UrlNoPadding.toString-impl(string)) + "." + Base64UrlNoPadding.toString-impl(it.getPayload-VYAuLfA()) + "." + Base64UrlNoPadding.toString-impl(it.getSignature-VYAuLfA()))));
        }
        return (List)destination$iv$iv;
    }

    private static final ErrorDispatchDetails dispatchDetailsOrNull(ReceivedRequest fetchedRequest, SiopOpenId4VPConfig siopOpenId4VPConfig) {
        ErrorDispatchDetails errorDispatchDetails;
        ReceivedRequest receivedRequest = fetchedRequest;
        if (receivedRequest instanceof ReceivedRequest.Signed) {
            errorDispatchDetails = DefaultAuthorizationRequestResolverKt.dispatchDetailsOrNull(((ReceivedRequest.Signed)fetchedRequest).getJwsJson(), siopOpenId4VPConfig);
        } else if (receivedRequest instanceof ReceivedRequest.Unsigned) {
            errorDispatchDetails = DefaultAuthorizationRequestResolverKt.dispatchDetailsOrNull(((ReceivedRequest.Unsigned)fetchedRequest).getRequestObject(), siopOpenId4VPConfig);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return errorDispatchDetails;
    }

    /*
     * WARNING - void declaration
     */
    private static final ErrorDispatchDetails dispatchDetailsOrNull(UnvalidatedRequestObject unvalidatedRequest, SiopOpenId4VPConfig siopOpenId4VPConfig) {
        ErrorDispatchDetails errorDispatchDetails;
        ResponseMode responseMode = DefaultAuthorizationRequestResolverKt.responseMode(unvalidatedRequest);
        if (responseMode != null) {
            VerifierId verifierId;
            ResponseMode responseMode2 = responseMode;
            boolean bl = false;
            Object responseEncryptionSpecification = DefaultAuthorizationRequestResolverKt.responseEncryptionSpecification(unvalidatedRequest, siopOpenId4VPConfig, responseMode2);
            ResponseMode responseMode3 = responseMode2;
            String string = unvalidatedRequest.getNonce();
            String string2 = unvalidatedRequest.getState();
            String string3 = unvalidatedRequest.getClientId();
            if (string3 != null) {
                void it;
                String string4 = string3;
                String string5 = string2;
                String string6 = string;
                ResponseMode responseMode4 = responseMode3;
                boolean bl2 = false;
                Object object = VerifierId.Companion.parse-IoAF18A((String)it);
                VerifierId verifierId2 = (VerifierId)(Result.isFailure-impl((Object)object) ? null : object);
                responseMode3 = responseMode4;
                string = string6;
                string2 = string5;
                verifierId = verifierId2;
            } else {
                verifierId = null;
            }
            ResponseEncryptionSpecification responseEncryptionSpecification2 = (ResponseEncryptionSpecification)(Result.isFailure-impl((Object)responseEncryptionSpecification) ? null : responseEncryptionSpecification);
            VerifierId verifierId3 = verifierId;
            String string7 = string2;
            String string8 = string;
            ResponseMode responseMode5 = responseMode3;
            errorDispatchDetails = new ErrorDispatchDetails(responseMode5, string8, string7, verifierId3, responseEncryptionSpecification2);
        } else {
            errorDispatchDetails = null;
        }
        return errorDispatchDetails;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object responseEncryptionSpecification(UnvalidatedRequestObject $this$responseEncryptionSpecification, SiopOpenId4VPConfig siopOpenId4VPConfig, ResponseMode responseMode) {
        Object object;
        boolean $i$f$runCatchingCancellable = false;
        try {
            ResponseEncryptionSpecification responseEncryptionSpecification;
            boolean bl = false;
            JsonObject jsonObject = $this$responseEncryptionSpecification.getClientMetaData();
            if (jsonObject != null) {
                UnvalidatedClientMetaData decodeFromJsonElement;
                void $this$decodeFromJsonElement$iv;
                JsonObject it = jsonObject;
                boolean bl2 = false;
                Json json = JsonKt.getJsonSupport();
                JsonElement json$iv = (JsonElement)$this$responseEncryptionSpecification.getClientMetaData();
                boolean $i$f$decodeFromJsonElement = false;
                $this$decodeFromJsonElement$iv.getSerializersModule();
                UnvalidatedClientMetaData it2 = decodeFromJsonElement = (UnvalidatedClientMetaData)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)UnvalidatedClientMetaData.Companion.serializer(), json$iv);
                boolean bl3 = false;
                ValidatedClientMetaData validatedClientMetadata = ClientMetaDataValidator.INSTANCE.validateClientMetaData(it2, responseMode, null, siopOpenId4VPConfig.getResponseEncryptionConfiguration(), siopOpenId4VPConfig.getVpConfiguration().getVpFormatsSupported());
                responseEncryptionSpecification = validatedClientMetadata.getResponseEncryptionSpecification();
            } else {
                responseEncryptionSpecification = null;
            }
            object = Result.constructor-impl(responseEncryptionSpecification);
        }
        catch (CancellationException ce$iv) {
            throw ce$iv;
        }
        catch (Exception e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private static final ResponseMode responseMode(UnvalidatedRequestObject $this$responseMode) {
        var1_1 = $this$responseMode.getResponseMode();
        if (var1_1 == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var1_1.hashCode()) {
            case -1650269616: {
                if (var1_1.equals("fragment")) {
                    tmp = 1;
                }
                break;
            }
            case 1910489129: {
                if (var1_1.equals("fragment.jwt")) {
                    tmp = 2;
                }
                break;
            }
            case 107944136: {
                if (var1_1.equals("query")) {
                    tmp = 3;
                }
                break;
            }
            case 1967634959: {
                if (var1_1.equals("direct_post.jwt")) {
                    tmp = 4;
                }
                break;
            }
            case -1641038026: {
                if (var1_1.equals("direct_post")) {
                    tmp = 5;
                }
                break;
            }
            case -1808008543: {
                if (var1_1.equals("query.jwt")) {
                    tmp = 6;
                }
                break;
            }
        }
        switch (tmp) {
            case 5: {
                v0 = DefaultAuthorizationRequestResolverKt.responseMode$responseUri($this$responseMode);
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-DefaultAuthorizationRequestResolverKt$responseMode$1 = false;
                    v1 = new ResponseMode.DirectPost(it);
                } else {
                    v1 = null;
                }
                v2 = v1;
                break;
            }
            case 4: {
                v3 = DefaultAuthorizationRequestResolverKt.responseMode$responseUri($this$responseMode);
                if (v3 != null) {
                    it = v3;
                    $i$a$-let-DefaultAuthorizationRequestResolverKt$responseMode$2 = false;
                    v4 = new ResponseMode.DirectPostJwt(it);
                } else {
                    v4 = null;
                }
                v2 = v4;
                break;
            }
            case 3: {
                v5 = DefaultAuthorizationRequestResolverKt.responseMode$redirectUri($this$responseMode);
                if (v5 != null) {
                    it = v5;
                    $i$a$-let-DefaultAuthorizationRequestResolverKt$responseMode$3 = false;
                    v6 = new ResponseMode.Query(it);
                } else {
                    v6 = null;
                }
                v2 = v6;
                break;
            }
            case 6: {
                v7 = DefaultAuthorizationRequestResolverKt.responseMode$redirectUri($this$responseMode);
                if (v7 != null) {
                    it = v7;
                    $i$a$-let-DefaultAuthorizationRequestResolverKt$responseMode$4 = false;
                    v8 = new ResponseMode.QueryJwt(it);
                } else {
                    v8 = null;
                }
                v2 = v8;
                break;
            }
            case 1: lbl-1000:
            // 2 sources

            {
                v9 = DefaultAuthorizationRequestResolverKt.responseMode$redirectUri($this$responseMode);
                if (v9 != null) {
                    it = v9;
                    $i$a$-let-DefaultAuthorizationRequestResolverKt$responseMode$5 = false;
                    v10 = new ResponseMode.Fragment(it);
                } else {
                    v10 = null;
                }
                v2 = v10;
                break;
            }
            case 2: {
                v11 = DefaultAuthorizationRequestResolverKt.responseMode$redirectUri($this$responseMode);
                if (v11 != null) {
                    it = v11;
                    $i$a$-let-DefaultAuthorizationRequestResolverKt$responseMode$6 = false;
                    v12 = new ResponseMode.FragmentJwt(it);
                } else {
                    v12 = null;
                }
                v2 = v12;
                break;
            }
            default: {
                v2 = null;
            }
        }
        return v2;
    }

    /*
     * WARNING - void declaration
     */
    private static final ErrorDispatchDetails dispatchDetailsOrNull(JwsJson jwsJson, SiopOpenId4VPConfig siopOpenId4VPConfig) {
        Object object;
        boolean $i$f$runCatchingCancellable = false;
        try {
            void string$iv$iv$iv;
            void this_$iv$iv$iv;
            boolean bl = false;
            JwsJson $this$decodePayloadAs$iv = jwsJson;
            boolean $i$f$decodePayloadAs = false;
            String $this$decodeAs_u2dRAoMowg$iv$iv = $this$decodePayloadAs$iv.getPayload-VYAuLfA();
            boolean bl2 = false;
            Json json = JsonKt.getJsonSupport();
            String string = StringsKt.decodeToString((byte[])Base64.decode$default((Base64)Base64Kt.getBase64UrlNoPadding(), (CharSequence)$this$decodeAs_u2dRAoMowg$iv$iv, (int)0, (int)0, (int)6, null));
            boolean $i$f$decodeFromString = false;
            this_$iv$iv$iv.getSerializersModule();
            object = Result.constructor-impl((Object)DefaultAuthorizationRequestResolverKt.dispatchDetailsOrNull((UnvalidatedRequestObject)this_$iv$iv$iv.decodeFromString((DeserializationStrategy)UnvalidatedRequestObject.Companion.serializer(), (String)string$iv$iv$iv), siopOpenId4VPConfig));
        }
        catch (CancellationException ce$iv) {
            throw ce$iv;
        }
        catch (Exception e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        Object object2 = object;
        return (ErrorDispatchDetails)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private static final Url toKtorUrl(URI $this$toKtorUrl) {
        URLBuilder uRLBuilder = new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null);
        String string = $this$toKtorUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return URLParserKt.takeFrom((URLBuilder)uRLBuilder, (String)string).build();
    }

    private static final URL responseMode$responseUri(UnvalidatedRequestObject $this$responseMode_u24responseUri) {
        URL uRL;
        String string = $this$responseMode_u24responseUri.getResponseUri();
        if (string != null) {
            Object object;
            String it = string;
            boolean bl = false;
            boolean $i$f$runCatchingCancellable = false;
            try {
                boolean bl2 = false;
                object = Result.constructor-impl((Object)new URL(it));
            }
            catch (CancellationException ce$iv) {
                throw ce$iv;
            }
            catch (Exception e$iv) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
            }
            Object object2 = object;
            uRL = (URL)(Result.isFailure-impl((Object)object2) ? null : object2);
        } else {
            uRL = null;
        }
        return uRL;
    }

    private static final URI responseMode$redirectUri(UnvalidatedRequestObject $this$responseMode_u24redirectUri) {
        URI uRI;
        String string = $this$responseMode_u24redirectUri.getRedirectUri();
        if (string != null) {
            Object object;
            String it = string;
            boolean bl = false;
            boolean $i$f$runCatchingCancellable = false;
            try {
                boolean bl2 = false;
                object = Result.constructor-impl((Object)URI.create(it));
            }
            catch (CancellationException ce$iv) {
                throw ce$iv;
            }
            catch (Exception e$iv) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
            }
            Object object2 = object;
            uRI = (URI)(Result.isFailure-impl((Object)object2) ? null : object2);
        } else {
            uRI = null;
        }
        return uRI;
    }

    public static final /* synthetic */ Url access$toKtorUrl(URI $receiver) {
        return DefaultAuthorizationRequestResolverKt.toKtorUrl($receiver);
    }

    public static final /* synthetic */ Object access$from(JwsJson.Companion $receiver, SignedJWT signedJwt) {
        return DefaultAuthorizationRequestResolverKt.from($receiver, signedJwt);
    }

    public static final /* synthetic */ ErrorDispatchDetails access$dispatchDetailsOrNull(ReceivedRequest fetchedRequest, SiopOpenId4VPConfig siopOpenId4VPConfig) {
        return DefaultAuthorizationRequestResolverKt.dispatchDetailsOrNull(fetchedRequest, siopOpenId4VPConfig);
    }

    public static final /* synthetic */ ErrorDispatchDetails access$dispatchDetailsOrNull(UnvalidatedRequestObject unvalidatedRequest, SiopOpenId4VPConfig siopOpenId4VPConfig) {
        return DefaultAuthorizationRequestResolverKt.dispatchDetailsOrNull(unvalidatedRequest, siopOpenId4VPConfig);
    }
}

