/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.jwk.AsymmetricJWK;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.shaded.gson.Gson;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import eu.europa.ec.eudi.openid4vp.AuthorizationRequestException;
import eu.europa.ec.eudi.openid4vp.AuthorizationRequestResolverKt;
import eu.europa.ec.eudi.openid4vp.LookupPublicKeyByDIDUrl;
import eu.europa.ec.eudi.openid4vp.RequestValidationError;
import eu.europa.ec.eudi.openid4vp.SupportedClientIdPrefix;
import eu.europa.ec.eudi.openid4vp.internal.AbsoluteDIDUrl;
import eu.europa.ec.eudi.openid4vp.internal.DID;
import eu.europa.ec.eudi.openid4vp.internal.JsonKt;
import eu.europa.ec.eudi.openid4vp.internal.request.DefaultAuthorizationRequestResolverKt;
import eu.europa.ec.eudi.openid4vp.internal.request.ReceivedRequest;
import eu.europa.ec.eudi.openid4vp.internal.request.TimeChecks;
import eu.europa.ec.eudi.openid4vp.internal.request.UnvalidatedRequestObject;
import eu.europa.ec.eudi.openid4vp.internal.request.VerifierAttestationClaims;
import java.net.URI;
import java.security.PublicKey;
import java.time.Clock;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0082@\u00a2\u0006\u0004\b\n\u0010\u000b\u001a,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00022\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002\u001a\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0002\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0001H\u0000\u001a\f\u0010\u001b\u001a\u00020\r*\u00020\u0001H\u0002\u00a8\u0006\u001c"}, d2={"ensureSingleSignedRequest", "Lcom/nimbusds/jwt/SignedJWT;", "Leu/europa/ec/eudi/openid4vp/internal/request/ReceivedRequest$Signed;", "lookupKeyByDID", "Ljava/security/PublicKey;", "request", "clientId", "Leu/europa/ec/eudi/openid4vp/internal/DID;", "lookupPublicKeyByDIDUrl", "Leu/europa/ec/eudi/openid4vp/LookupPublicKeyByDIDUrl;", "lookupKeyByDID-N7EJtrs", "(Leu/europa/ec/eudi/openid4vp/internal/request/ReceivedRequest$Signed;Ljava/net/URI;Leu/europa/ec/eudi/openid4vp/LookupPublicKeyByDIDUrl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "verifierAttestation", "Leu/europa/ec/eudi/openid4vp/internal/request/VerifierAttestationClaims;", "clock", "Ljava/time/Clock;", "supportedPrefix", "Leu/europa/ec/eudi/openid4vp/SupportedClientIdPrefix$VerifierAttestation;", "originalClientId", "", "Leu/europa/ec/eudi/openid4vp/OriginalClientId;", "invalidPrefix", "Leu/europa/ec/eudi/openid4vp/AuthorizationRequestException;", "cause", "invalidJarJwt", "requestObject", "Leu/europa/ec/eudi/openid4vp/internal/request/UnvalidatedRequestObject;", "verifierAttestationClaims", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nRequestAuthenticator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestAuthenticator.kt\neu/europa/ec/eudi/openid4vp/internal/request/RequestAuthenticatorKt\n+ 2 ResultOps.kt\neu/europa/ec/eudi/openid4vp/internal/ResultOpsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Util.kt\neu/europa/ec/eudi/openid4vp/UtilKt\n+ 5 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,407:1\n32#2,2:408\n40#2,2:411\n32#2,2:413\n32#2,2:421\n32#2,2:429\n1#3:410\n21#4,6:415\n21#4,6:423\n21#4,6:432\n222#5:431\n*S KotlinDebug\n*F\n+ 1 RequestAuthenticator.kt\neu/europa/ec/eudi/openid4vp/internal/request/RequestAuthenticatorKt\n*L\n198#1:408,2\n239#1:411,2\n240#1:413,2\n246#1:421,2\n260#1:429,2\n242#1:415,6\n250#1:423,6\n372#1:432,6\n349#1:431\n*E\n"})
public final class RequestAuthenticatorKt {
    private static final SignedJWT ensureSingleSignedRequest(ReceivedRequest.Signed $this$ensureSingleSignedRequest) {
        List<SignedJWT> signedJwts = DefaultAuthorizationRequestResolverKt.toSignedJwts($this$ensureSingleSignedRequest);
        boolean value$iv = signedJwts.size() == 1;
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)RequestAuthenticatorKt.invalidJarJwt("Multi-signed authorization requests are not yet supported");
        }
        Unit it = Unit.INSTANCE;
        boolean bl = false;
        return signedJwts.get(0);
    }

    private static final Object lookupKeyByDID-N7EJtrs(ReceivedRequest.Signed request, URI clientId, LookupPublicKeyByDIDUrl lookupPublicKeyByDIDUrl, Continuation<? super PublicKey> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PublicKey>, Object>(clientId, request, lookupPublicKeyByDIDUrl, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ URI $clientId;
            final /* synthetic */ ReceivedRequest.Signed $request;
            final /* synthetic */ LookupPublicKeyByDIDUrl $lookupPublicKeyByDIDUrl;
            {
                this.$clientId = $clientId;
                this.$request = $request;
                this.$lookupPublicKeyByDIDUrl = $lookupPublicKeyByDIDUrl;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var4_4 = $this$withContext = (CoroutineScope)this.L$0;
                        var5_7 = this.$request;
                        var6_9 = this.$clientId;
                        $i$a$-run-RequestAuthenticatorKt$lookupKeyByDID$2$keyUrl$1 = false;
                        jwt = RequestAuthenticatorKt.access$ensureSingleSignedRequest((ReceivedRequest.Signed)var5_7);
                        v0 = jwt.getHeader();
                        value$iv = v0 != null ? v0.getKeyID() : null;
                        $i$f$ensureNotNull = false;
                        if (value$iv == null) {
                            $i$a$-ensureNotNull-RequestAuthenticatorKt$lookupKeyByDID$2$keyUrl$1$kid$1 = false;
                            throw (Throwable)RequestAuthenticatorKt.access$invalidJarJwt("Missing kid for client_id " + DID.toString-impl(var6_9));
                        }
                        kid = value$iv;
                        value$iv = Result.isFailure-impl((Object)(value$iv = AbsoluteDIDUrl.Companion.parse-IoAF18A((String)kid))) != false ? null : value$iv;
                        $i$f$ensureNotNull = false;
                        if (value$iv == null) {
                            $i$a$-ensureNotNull-RequestAuthenticatorKt$lookupKeyByDID$2$keyUrl$1$1 = false;
                            throw (Throwable)RequestAuthenticatorKt.access$invalidJarJwt("kid should be DID URL");
                        }
                        keyUrl = ((AbsoluteDIDUrl)value$iv).unbox-impl();
                        var4_5 = StringsKt.startsWith$default((String)AbsoluteDIDUrl.toString-impl(keyUrl), (String)DID.toString-impl(this.$clientId), (boolean)false, (int)2, null);
                        var5_7 = this.$clientId;
                        $i$f$ensure = false;
                        if (value$iv == false) {
                            $i$a$-ensure-RequestAuthenticatorKt$lookupKeyByDID$2$1 = false;
                            throw (Throwable)RequestAuthenticatorKt.access$invalidJarJwt("kid should be DID URL sub-resource of " + DID.toString-impl((URI)var5_7) + " but is " + AbsoluteDIDUrl.toString-impl(keyUrl));
                        }
                        var5_7 = this.$lookupPublicKeyByDIDUrl;
                        $i$f$runCatchingCancellable = false;
                        $i$a$-runCatchingCancellable-RequestAuthenticatorKt$lookupKeyByDID$2$key$1 = false;
                        this.L$0 = keyUrl;
                        this.label = 1;
                        v1 = var5_7.resolveKey(keyUrl, (Continuation<? super PublicKey>)this);
                        ** if (v1 != var14_2) goto lbl40
lbl39:
                        // 1 sources

                        return var14_2;
lbl40:
                        // 1 sources

                        ** GOTO lbl49
                    }
                    case 1: {
                        $i$f$runCatchingCancellable = false;
                        $i$a$-runCatchingCancellable-RequestAuthenticatorKt$lookupKeyByDID$2$key$1 = false;
                        keyUrl = (URI)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl49:
                            // 2 sources

                            var8_12 = Result.constructor-impl((Object)((PublicKey)v1));
                        }
                        catch (CancellationException ce$iv) {
                            throw ce$iv;
                        }
                        catch (Exception e$iv) {
                            var8_12 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
                        }
                        var5_7 = var8_12;
                        key = (PublicKey)(Result.isFailure-impl((Object)var5_7) != false ? null : var5_7);
                        $i$f$ensureNotNull = false;
                        if (key == null) {
                            $i$a$-ensureNotNull-RequestAuthenticatorKt$lookupKeyByDID$2$2 = false;
                            throw (Throwable)AuthorizationRequestResolverKt.asException(new RequestValidationError.DIDResolutionFailed(AbsoluteDIDUrl.toString-impl(keyUrl)));
                        }
                        return key;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PublicKey> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private static final VerifierAttestationClaims verifierAttestation(Clock clock, SupportedClientIdPrefix.VerifierAttestation supportedPrefix, ReceivedRequest.Signed request, String originalClientId) {
        Object object;
        SignedJWT signedJWT;
        Object object2;
        JWSVerifier trust = supportedPrefix.component1();
        java.time.Duration skew = supportedPrefix.component2();
        boolean bl = false;
        Object jwt = RequestAuthenticatorKt.ensureSingleSignedRequest(request);
        Object jwtString = jwt.getHeader().getCustomParams().get("jwt");
        boolean $i$f$ensureNotNull = false;
        if (jwtString == null) {
            boolean bl2 = false;
            throw (Throwable)RequestAuthenticatorKt.invalidJarJwt("Missing jwt JOSE Header");
        }
        boolean value$iv = jwtString instanceof String;
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl3 = false;
            throw (Throwable)RequestAuthenticatorKt.invalidJarJwt("jwt JOSE Header doesn't contain a JWT");
        }
        boolean $i$f$runCatchingCancellable22 = false;
        try {
            boolean bl4 = false;
            object2 = Result.constructor-impl((Object)SignedJWT.parse((String)((String)jwtString)));
        }
        catch (CancellationException ce$iv) {
            throw ce$iv;
        }
        catch (Exception e$iv) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        Object $i$f$runCatchingCancellable22 = object2;
        Throwable throwable = Result.exceptionOrNull-impl((Object)$i$f$runCatchingCancellable22);
        if (throwable != null) {
            Throwable error = throwable;
            boolean bl5 = false;
            throw RequestAuthenticatorKt.verifierAttestation$invalidVerifierAttestationJwt("Cannot be parsed  " + error);
        }
        SignedJWT parsedJwt = (SignedJWT)$i$f$runCatchingCancellable22;
        String expectedType = "verifier-attestation+jwt";
        boolean value$iv2 = Intrinsics.areEqual((Object)parsedJwt.getHeader().getType(), (Object)new JOSEObjectType(expectedType));
        boolean $i$f$ensure2 = false;
        if (!value$iv2) {
            boolean bl6 = false;
            throw (Throwable)RequestAuthenticatorKt.verifierAttestation$invalidVerifierAttestationJwt("typ is not " + expectedType + " ");
        }
        SignedJWT $this$verifierAttestation_u24lambda_u2410_u24lambda_u249 = signedJWT = parsedJwt;
        boolean bl7 = false;
        boolean $i$f$runCatchingCancellable = false;
        try {
            boolean bl8 = false;
            object = Result.constructor-impl((Object)$this$verifierAttestation_u24lambda_u2410_u24lambda_u249.verify(trust));
        }
        catch (CancellationException ce$iv) {
            throw ce$iv;
        }
        catch (Exception e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        Object object3 = object;
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object3);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl9 = false;
            throw RequestAuthenticatorKt.verifierAttestation$invalidVerifierAttestationJwt("Not trusted. " + it);
        }
        SignedJWT verifierAttestationJwt = signedJWT;
        try {
            jwt = skew;
            TimeChecks timeChecks = new TimeChecks(clock, Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)((java.time.Duration)jwt).getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)((java.time.Duration)jwt).getNano(), (DurationUnit)DurationUnit.NANOSECONDS)), null);
            JWTClaimsSet jWTClaimsSet = verifierAttestationJwt.getJWTClaimsSet();
            Intrinsics.checkNotNullExpressionValue((Object)jWTClaimsSet, (String)"getJWTClaimsSet(...)");
            timeChecks.verify(jWTClaimsSet, null);
            Intrinsics.checkNotNull((Object)verifierAttestationJwt);
            jwt = RequestAuthenticatorKt.verifierAttestationClaims(verifierAttestationJwt);
        }
        catch (Throwable t) {
            throw RequestAuthenticatorKt.verifierAttestation$invalidVerifierAttestationJwt(t.getMessage());
        }
        Object verifierAttestationClaimSet = jwt;
        boolean value$iv3 = Intrinsics.areEqual((Object)((VerifierAttestationClaims)verifierAttestationClaimSet).getSub(), (Object)originalClientId);
        boolean $i$f$ensure3 = false;
        if (!value$iv3) {
            boolean bl10 = false;
            throw (Throwable)RequestAuthenticatorKt.verifierAttestation$invalidVerifierAttestationJwt("sub claim and authorization's request client_id don't match");
        }
        return verifierAttestationClaimSet;
    }

    private static final AuthorizationRequestException invalidPrefix(String cause) {
        return AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidClientIdPrefix(cause));
    }

    private static final AuthorizationRequestException invalidJarJwt(String cause) {
        return AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidJarJwt(cause));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final UnvalidatedRequestObject requestObject(@NotNull SignedJWT $this$requestObject) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$requestObject, (String)"<this>");
        Json json = JsonKt.getJsonSupport();
        String string = JSONObjectUtils.toJSONString((Map)$this$requestObject.getJWTClaimsSet().toJSONObject());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJSONString(...)");
        String string$iv = string;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (UnvalidatedRequestObject)this_$iv.decodeFromString((DeserializationStrategy)UnvalidatedRequestObject.Companion.serializer(), string$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final VerifierAttestationClaims verifierAttestationClaims(SignedJWT $this$verifierAttestationClaims) {
        Object object;
        void $this$verifierAttestationClaims_u24lambda_u2422_u24lambda_u2421;
        JWTClaimsSet $this$verifierAttestationClaims_u24lambda_u2422 = $this$verifierAttestationClaims.getJWTClaimsSet();
        boolean bl = false;
        String string = $this$verifierAttestationClaims_u24lambda_u2422.getIssuer();
        if (string == null) {
            boolean $i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$42 = false;
            String $i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$42 = "Missing iss";
            throw new IllegalArgumentException($i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$42.toString());
        }
        String string2 = $this$verifierAttestationClaims_u24lambda_u2422.getSubject();
        if (string2 == null) {
            String string3 = string;
            boolean $i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$52 = false;
            String string4 = string3;
            String $i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$52 = "Missing sub";
            throw new IllegalArgumentException($i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$52.toString());
        }
        Date date = $this$verifierAttestationClaims_u24lambda_u2422.getIssueTime();
        Instant instant = date != null ? date.toInstant() : null;
        Date date2 = $this$verifierAttestationClaims_u24lambda_u2422.getExpirationTime();
        Instant instant2 = date2 != null ? date2.toInstant() : null;
        if (instant2 == null) {
            Instant instant3 = instant;
            String string5 = string2;
            String string6 = string;
            boolean $i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$62 = false;
            String string7 = "Missing exp";
            String string8 = string6;
            String string9 = string5;
            Instant instant4 = instant3;
            String $i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$62 = string7;
            throw new IllegalArgumentException($i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$62.toString());
        }
        Date date3 = $this$verifierAttestationClaims_u24lambda_u2422.getNotBeforeTime();
        JWTClaimsSet $i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$62 = $this$verifierAttestationClaims_u24lambda_u2422;
        Instant instant5 = date3 != null ? date3.toInstant() : null;
        Instant instant6 = instant2;
        Instant instant7 = instant;
        String string10 = string2;
        String string11 = string;
        boolean bl2 = false;
        Map map = $this$verifierAttestationClaims_u24lambda_u2422_u24lambda_u2421.getJSONObjectClaim("cnf");
        if (map == null) {
            boolean $i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$4$cnf$22 = false;
            String $i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$4$cnf$22 = "Missing cnf";
            throw new IllegalArgumentException($i$a$-requireNotNull-RequestAuthenticatorKt$verifierAttestationClaims$1$4$cnf$22.toString());
        }
        Map cnf = map;
        boolean $i$f$runCatchingCancellable22 = false;
        try {
            boolean bl3 = false;
            Object v = cnf.get("jwk");
            if (v == null) {
                boolean bl4 = false;
                String string12 = "Missing jwk";
                throw new IllegalArgumentException(string12.toString());
            }
            Object jwkObj = v;
            object = Result.constructor-impl((Object)JWK.parse((String)new Gson().toJson(jwkObj)));
        }
        catch (CancellationException ce$iv) {
            throw ce$iv;
        }
        catch (Exception e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        Object $i$f$runCatchingCancellable22 = object;
        JWK jwk = (JWK)(Result.isFailure-impl((Object)$i$f$runCatchingCancellable22) ? null : $i$f$runCatchingCancellable22);
        if (jwk == null) {
            boolean bl5 = false;
            String string13 = "Missing jwk";
            throw new IllegalArgumentException(string13.toString());
        }
        if (!(!jwk.isPrivate())) {
            boolean $i$a$-require-RequestAuthenticatorKt$verifierAttestationClaims$1$4$42 = false;
            String $i$a$-require-RequestAuthenticatorKt$verifierAttestationClaims$1$4$42 = "Not a public JWK";
            throw new IllegalArgumentException($i$a$-require-RequestAuthenticatorKt$verifierAttestationClaims$1$4$42.toString());
        }
        if (!(jwk instanceof AsymmetricJWK)) {
            boolean bl6 = false;
            String string14 = "Not a valid JWK";
            throw new IllegalArgumentException(string14.toString());
        }
        AsymmetricJWK asymmetricJWK = (AsymmetricJWK)jwk;
        List list = $this$verifierAttestationClaims_u24lambda_u2422.getStringListClaim("redirect_uris");
        List list2 = $this$verifierAttestationClaims_u24lambda_u2422.getStringListClaim("response_uris");
        List list3 = list2 != null ? CollectionsKt.toList((Iterable)list2) : null;
        List list4 = list != null ? CollectionsKt.toList((Iterable)list) : null;
        AsymmetricJWK asymmetricJWK2 = asymmetricJWK;
        Instant instant8 = instant5;
        Instant instant9 = instant6;
        Instant instant10 = instant7;
        String string15 = string10;
        String string16 = string11;
        return new VerifierAttestationClaims(string16, string15, instant10, instant9, instant8, asymmetricJWK2, list4, list3);
    }

    private static final AuthorizationRequestException verifierAttestation$invalidVerifierAttestationJwt(String cause) {
        return RequestAuthenticatorKt.invalidJarJwt("Invalid VerifierAttestation JWT. Details: " + cause);
    }

    public static final /* synthetic */ SignedJWT access$ensureSingleSignedRequest(ReceivedRequest.Signed $receiver) {
        return RequestAuthenticatorKt.ensureSingleSignedRequest($receiver);
    }

    public static final /* synthetic */ Object access$lookupKeyByDID-N7EJtrs(ReceivedRequest.Signed request, URI clientId, LookupPublicKeyByDIDUrl lookupPublicKeyByDIDUrl, Continuation $completion) {
        return RequestAuthenticatorKt.lookupKeyByDID-N7EJtrs(request, clientId, lookupPublicKeyByDIDUrl, (Continuation<? super PublicKey>)$completion);
    }

    public static final /* synthetic */ VerifierAttestationClaims access$verifierAttestation(Clock clock, SupportedClientIdPrefix.VerifierAttestation supportedPrefix, ReceivedRequest.Signed request, String originalClientId) {
        return RequestAuthenticatorKt.verifierAttestation(clock, supportedPrefix, request, originalClientId);
    }

    public static final /* synthetic */ AuthorizationRequestException access$invalidPrefix(String cause) {
        return RequestAuthenticatorKt.invalidPrefix(cause);
    }

    public static final /* synthetic */ AuthorizationRequestException access$invalidJarJwt(String cause) {
        return RequestAuthenticatorKt.invalidJarJwt(cause);
    }
}

