/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.request;

import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.ECDHDecrypter;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.openid.connect.sdk.Nonce;
import eu.europa.ec.eudi.openid4vp.AuthorizationRequestException;
import eu.europa.ec.eudi.openid4vp.AuthorizationRequestResolverKt;
import eu.europa.ec.eudi.openid4vp.EncryptionRequirement;
import eu.europa.ec.eudi.openid4vp.RequestValidationError;
import eu.europa.ec.eudi.openid4vp.ResolutionError;
import eu.europa.ec.eudi.openid4vp.SiopOpenId4VPConfig;
import eu.europa.ec.eudi.openid4vp.internal.request.ReceivedRequest;
import eu.europa.ec.eudi.openid4vp.internal.request.RequestFetcherKt;
import eu.europa.ec.eudi.openid4vp.internal.request.RequestUriMethod;
import io.ktor.client.HttpClient;
import io.ktor.client.plugins.ClientRequestException;
import io.ktor.client.request.BuildersJvmKt;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.request.UtilsKt;
import io.ktor.client.request.forms.FormBuildersKt;
import io.ktor.client.statement.HttpResponse;
import io.ktor.http.ContentType;
import io.ktor.http.HttpMessageBuilder;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.ParametersKt;
import io.ktor.util.reflect.TypeInfo;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.text.ParseException;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000p\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u00060\u0004j\u0002`\bH\u0002\u001a\u0014\u0010\t\u001a\u00020\n2\n\u0010\u0007\u001a\u00060\u0004j\u0002`\bH\u0002\u001a\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\f*\u00020\u00022\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0018\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\nH\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002\u001a\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\u001e\u0010\u0019\u001a\u00060\u0004j\u0002`\b*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0082@\u00a2\u0006\u0002\u0010\u001d\u001a2\u0010\u001e\u001a\u00060\u0004j\u0002`\b*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00062\b\u0010 \u001a\u0004\u0018\u00010!H\u0082@\u00a2\u0006\u0002\u0010\"\u001a\f\u0010#\u001a\u00020\f*\u00020$H\u0002\u001a'\u0010&\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\b0'*\u00060\u0004j\u0002`\b2\u0006\u0010(\u001a\u00020)H\u0002\u00a2\u0006\u0002\u0010*\u001a\u0012\u0010+\u001a\u00020)*\u00020,H\u0080@\u00a2\u0006\u0002\u0010-\"\u000e\u0010\u0017\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010%\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"ensureValid", "Leu/europa/ec/eudi/openid4vp/internal/request/ReceivedRequest$Signed;", "Leu/europa/ec/eudi/openid4vp/SiopOpenId4VPConfig;", "expectedClient", "", "expectedWalletNonce", "Lcom/nimbusds/openid/connect/sdk/Nonce;", "unverifiedJwt", "Leu/europa/ec/eudi/openid4vp/Jwt;", "ensureIsSignedJwt", "Lcom/nimbusds/jwt/SignedJWT;", "ensureSameWalletNonce", "", "signedJwt", "ensureSupportedSigningAlgorithm", "ensureSameClientId", "expectedClientId", "invalidJwt", "Leu/europa/ec/eudi/openid4vp/AuthorizationRequestException;", "cause", "unsupportedRequestUriMethod", "m", "Leu/europa/ec/eudi/openid4vp/internal/request/RequestUriMethod;", "APPLICATION_JWT", "APPLICATION_OAUTH_AUTHZ_REQ_JWT", "getJAR", "Lio/ktor/client/HttpClient;", "requestUri", "Ljava/net/URL;", "(Lio/ktor/client/HttpClient;Ljava/net/URL;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "postForJAR", "walletNonce", "walletMetaData", "Lkotlinx/serialization/json/JsonObject;", "(Lio/ktor/client/HttpClient;Ljava/net/URL;Lcom/nimbusds/openid/connect/sdk/Nonce;Lkotlinx/serialization/json/JsonObject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addAcceptContentTypeJwt", "Lio/ktor/client/request/HttpRequestBuilder;", "CONTENT_TYPE_JWT", "decrypt", "Lkotlin/Result;", "recipientKey", "Lcom/nimbusds/jose/jwk/ECKey;", "(Ljava/lang/String;Lcom/nimbusds/jose/jwk/ECKey;)Ljava/lang/Object;", "ephemeralEncryptionKey", "Leu/europa/ec/eudi/openid4vp/EncryptionRequirement$Required;", "(Leu/europa/ec/eudi/openid4vp/EncryptionRequirement$Required;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nRequestFetcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestFetcher.kt\neu/europa/ec/eudi/openid4vp/internal/request/RequestFetcherKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ResultOps.kt\neu/europa/ec/eudi/openid4vp/internal/ResultOpsKt\n+ 4 HttpClientCall.kt\nio/ktor/client/call/HttpClientCallKt\n+ 5 Type.kt\nio/ktor/util/reflect/TypeKt\n+ 6 Util.kt\neu/europa/ec/eudi/openid4vp/UtilKt\n+ 7 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,211:1\n1#2:212\n32#3,2:213\n40#3,2:215\n32#3,2:217\n32#3,2:219\n162#4:221\n162#4:231\n69#5:222\n84#5,8:223\n69#5:232\n84#5,8:233\n21#6,6:241\n205#7:247\n*S KotlinDebug\n*F\n+ 1 RequestFetcher.kt\neu/europa/ec/eudi/openid4vp/internal/request/RequestFetcherKt\n*L\n129#1:213,2\n135#1:215,2\n138#1:217,2\n148#1:219,2\n165#1:221\n181#1:231\n165#1:222\n165#1:223,8\n181#1:232\n181#1:233,8\n194#1:241,6\n178#1:247\n*E\n"})
public final class RequestFetcherKt {
    @NotNull
    private static final String APPLICATION_JWT = "application/jwt";
    @NotNull
    private static final String APPLICATION_OAUTH_AUTHZ_REQ_JWT = "application/oauth-authz-req+jwt";
    @NotNull
    private static final String CONTENT_TYPE_JWT = "JWT";

    private static final ReceivedRequest.Signed ensureValid(SiopOpenId4VPConfig $this$ensureValid, String expectedClient, Nonce expectedWalletNonce, String unverifiedJwt) {
        SignedJWT signedJWT;
        SignedJWT p0 = signedJWT = RequestFetcherKt.ensureIsSignedJwt(unverifiedJwt);
        boolean bl = false;
        RequestFetcherKt.ensureSupportedSigningAlgorithm($this$ensureValid, p0);
        SignedJWT signedJwt = signedJWT;
        RequestFetcherKt.ensureSameClientId(expectedClient, signedJwt);
        if (expectedWalletNonce != null) {
            RequestFetcherKt.ensureSameWalletNonce(expectedWalletNonce, signedJwt);
        }
        return ReceivedRequest.Signed.Companion.invoke(signedJwt);
    }

    private static final SignedJWT ensureIsSignedJwt(String unverifiedJwt) {
        SignedJWT signedJWT;
        try {
            signedJWT = SignedJWT.parse((String)unverifiedJwt);
            Intrinsics.checkNotNull((Object)signedJWT);
        }
        catch (ParseException parseException) {
            throw RequestFetcherKt.invalidJwt("JAR JWT parse error");
        }
        return signedJWT;
    }

    private static final void ensureSameWalletNonce(Nonce expectedWalletNonce, SignedJWT signedJwt) {
        String walletNonce = signedJwt.getJWTClaimsSet().getStringClaim("wallet_nonce");
        boolean value$iv = Intrinsics.areEqual((Object)expectedWalletNonce.toString(), (Object)walletNonce);
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)RequestFetcherKt.invalidJwt("Mismatch of wallet_nonce. Expected " + expectedWalletNonce + ", actual " + walletNonce);
        }
    }

    private static final void ensureSupportedSigningAlgorithm(SiopOpenId4VPConfig $this$ensureSupportedSigningAlgorithm, SignedJWT signedJwt) {
        JWSAlgorithm value$iv = signedJwt.getHeader().getAlgorithm();
        boolean $i$f$ensureNotNull = false;
        if (value$iv == null) {
            boolean bl = false;
            throw (Throwable)RequestFetcherKt.invalidJwt("JAR is missing alg claim from header");
        }
        JWSAlgorithm signingAlg = value$iv;
        boolean value$iv2 = $this$ensureSupportedSigningAlgorithm.getJarConfiguration().getSupportedAlgorithms().contains(signingAlg);
        boolean $i$f$ensure = false;
        if (!value$iv2) {
            boolean bl = false;
            throw (Throwable)RequestFetcherKt.invalidJwt("JAR is signed with " + signingAlg.getName() + " which is not supported");
        }
    }

    private static final String ensureSameClientId(String expectedClientId, SignedJWT signedJwt) {
        String jarClientId = signedJwt.getJWTClaimsSet().getStringClaim("client_id");
        boolean value$iv = Intrinsics.areEqual((Object)expectedClientId, (Object)jarClientId);
        boolean $i$f$ensure = false;
        if (!value$iv) {
            boolean bl = false;
            throw (Throwable)RequestFetcherKt.invalidJwt("ClientId mismatch. JAR request " + expectedClientId + ", jwt " + jarClientId);
        }
        return expectedClientId;
    }

    private static final AuthorizationRequestException invalidJwt(String cause) {
        return AuthorizationRequestResolverKt.asException(new RequestValidationError.InvalidJarJwt(cause));
    }

    private static final AuthorizationRequestException unsupportedRequestUriMethod(RequestUriMethod m) {
        return AuthorizationRequestResolverKt.asException(new RequestValidationError.UnsupportedRequestUriMethod(m));
    }

    /*
     * Unable to fully structure code
     */
    private static final Object getJAR(HttpClient var0, URL var1_1, Continuation<? super String> $completion) {
        if (!($completion instanceof getJAR.1)) ** GOTO lbl-1000
        var14_3 = $completion;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RequestFetcherKt.access$getJAR(null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = BuildersJvmKt.get((HttpClient)$this$getJAR, (URL)requestUri, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getJAR$lambda$4(io.ktor.client.request.HttpRequestBuilder ), (Lio/ktor/client/request/HttpRequestBuilder;)Lkotlin/Unit;)(), (Continuation)$continuation);
                ** if (v0 != var15_5) goto lbl18
lbl17:
                // 1 sources

                return var15_5;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                $this$body$iv = (HttpResponse)v0;
                $i$f$body = false;
                var5_10 = $this$body$iv.getCall();
                $i$f$typeInfo = false;
                var7_12 = Reflection.getOrCreateKotlinClass(String.class);
                $i$f$typeOfOrNull = false;
                try {
                    var9_14 = Reflection.typeOf(String.class);
                }
                catch (Throwable var10_15) {
                    var9_14 = null;
                }
                var11_16 = var9_14;
                var12_17 = var7_12;
                $continuation.label = 2;
                v1 = var5_10.bodyNullable(new TypeInfo(var12_17, var11_16), (Continuation)$continuation);
                ** if (v1 != var15_5) goto lbl43
lbl42:
                // 1 sources

                return var15_5;
lbl43:
                // 1 sources

                ** GOTO lbl50
            }
            case 2: {
                $i$f$body = false;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl50:
                    // 2 sources

                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    var3_6 = (String)v1;
                }
                catch (ClientRequestException e) {
                    throw AuthorizationRequestResolverKt.asException(new ResolutionError.UnableToFetchRequestObject(e));
                }
                return var3_6;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private static final Object postForJAR(HttpClient var0, URL var1_1, Nonce var2_2, JsonObject var3_3, Continuation<? super String> $completion) {
        if (!($completion instanceof postForJAR.1)) ** GOTO lbl-1000
        var17_5 = $completion;
        if ((var17_5.label & -2147483648) != 0) {
            var17_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RequestFetcherKt.access$postForJAR(null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var18_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                form = ParametersKt.parameters((Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, postForJAR$lambda$7(com.nimbusds.openid.connect.sdk.Nonce kotlinx.serialization.json.JsonObject io.ktor.http.ParametersBuilder ), (Lio/ktor/http/ParametersBuilder;)Lkotlin/Unit;)((Nonce)walletNonce, (JsonObject)walletMetaData));
                var6_9 = requestUri.toString();
                Intrinsics.checkNotNullExpressionValue((Object)var6_9, (String)"toString(...)");
                $continuation.label = 1;
                v0 = FormBuildersKt.submitForm$default((HttpClient)$this$postForJAR, (String)var6_9, (Parameters)form, (boolean)false, (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, postForJAR$lambda$8(io.ktor.client.request.HttpRequestBuilder ), (Lio/ktor/client/request/HttpRequestBuilder;)Lkotlin/Unit;)(), (Continuation)$continuation, (int)4, null);
                ** if (v0 != var18_7) goto lbl21
lbl20:
                // 1 sources

                return var18_7;
lbl21:
                // 1 sources

                ** GOTO lbl27
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                $this$body$iv = (HttpResponse)v0;
                $i$f$body = false;
                var8_13 = $this$body$iv.getCall();
                $i$f$typeInfo = false;
                var10_15 = Reflection.getOrCreateKotlinClass(String.class);
                $i$f$typeOfOrNull = false;
                try {
                    var12_17 = Reflection.typeOf(String.class);
                }
                catch (Throwable var13_18) {
                    var12_17 = null;
                }
                var14_19 = var12_17;
                var15_20 = var10_15;
                $continuation.label = 2;
                v1 = var8_13.bodyNullable(new TypeInfo(var15_20, var14_19), (Continuation)$continuation);
                ** if (v1 != var18_7) goto lbl46
lbl45:
                // 1 sources

                return var18_7;
lbl46:
                // 1 sources

                ** GOTO lbl53
            }
            case 2: {
                $i$f$body = false;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl53:
                    // 2 sources

                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    var6_9 = (String)v1;
                }
                catch (ClientRequestException e) {
                    throw AuthorizationRequestResolverKt.asException(new ResolutionError.UnableToFetchRequestObject(e));
                }
                return var6_9;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void addAcceptContentTypeJwt(HttpRequestBuilder $this$addAcceptContentTypeJwt) {
        UtilsKt.accept((HttpMessageBuilder)((HttpMessageBuilder)$this$addAcceptContentTypeJwt), (ContentType)ContentType.Companion.parse(APPLICATION_OAUTH_AUTHZ_REQ_JWT));
        UtilsKt.accept((HttpMessageBuilder)((HttpMessageBuilder)$this$addAcceptContentTypeJwt), (ContentType)ContentType.Companion.parse(APPLICATION_JWT));
    }

    private static final Object decrypt(String $this$decrypt, ECKey recipientKey) {
        Object object;
        boolean $i$f$runCatchingCancellable = false;
        try {
            boolean bl = false;
            JWEObject jwe = JWEObject.parse((String)$this$decrypt);
            if (!Intrinsics.areEqual((Object)CONTENT_TYPE_JWT, (Object)jwe.getHeader().getContentType())) {
                boolean $i$a$-require-RequestFetcherKt$decrypt$1$22 = false;
                String $i$a$-require-RequestFetcherKt$decrypt$1$22 = "JWEObject must contain a JWT Payload";
                throw new IllegalArgumentException($i$a$-require-RequestFetcherKt$decrypt$1$22.toString());
            }
            ECDHDecrypter decrypter = new ECDHDecrypter(recipientKey);
            jwe.decrypt((JWEDecrypter)decrypter);
            Payload payload = jwe.getPayload();
            object = Result.constructor-impl((Object)payload.toString());
        }
        catch (CancellationException ce$iv) {
            throw ce$iv;
        }
        catch (Exception e$iv) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e$iv));
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object ephemeralEncryptionKey(@NotNull EncryptionRequirement.Required var0, @NotNull Continuation<? super ECKey> $completion) {
        if (!($completion instanceof ephemeralEncryptionKey.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return RequestFetcherKt.ephemeralEncryptionKey(null, (Continuation<? super ECKey>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ECKey>, Object>($this$ephemeralEncryptionKey, null){
                    int label;
                    final /* synthetic */ EncryptionRequirement.Required $this_ephemeralEncryptionKey;
                    {
                        this.$this_ephemeralEncryptionKey = $receiver;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                return new ECKeyGenerator(this.$this_ephemeralEncryptionKey.getEphemeralEncryptionKeyCurve()).keyUse(KeyUse.ENCRYPTION).generate();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super ECKey> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"withContext(...)");
                return v0;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit getJAR$lambda$4(HttpRequestBuilder $this$get) {
        Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$this$get");
        RequestFetcherKt.addAcceptContentTypeJwt($this$get);
        return Unit.INSTANCE;
    }

    private static final Unit postForJAR$lambda$7(Nonce $walletNonce, JsonObject $walletMetaData, ParametersBuilder $this$parameters) {
        block1: {
            Nonce it;
            Intrinsics.checkNotNullParameter((Object)$this$parameters, (String)"$this$parameters");
            Nonce nonce = $walletNonce;
            if (nonce != null) {
                it = nonce;
                boolean bl = false;
                String string = it.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                $this$parameters.append("wallet_nonce", string);
            }
            JsonObject jsonObject = $walletMetaData;
            if (jsonObject == null) break block1;
            it = jsonObject;
            boolean bl = false;
            Json this_$iv = (Json)Json.Default;
            boolean $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            $this$parameters.append("wallet_metadata", this_$iv.encodeToString((SerializationStrategy)JsonObject.Companion.serializer(), (Object)it));
        }
        return Unit.INSTANCE;
    }

    private static final Unit postForJAR$lambda$8(HttpRequestBuilder $this$submitForm) {
        Intrinsics.checkNotNullParameter((Object)$this$submitForm, (String)"$this$submitForm");
        RequestFetcherKt.addAcceptContentTypeJwt($this$submitForm);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$getJAR(HttpClient $receiver, URL requestUri, Continuation $completion) {
        return RequestFetcherKt.getJAR($receiver, requestUri, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$postForJAR(HttpClient $receiver, URL requestUri, Nonce walletNonce, JsonObject walletMetaData, Continuation $completion) {
        return RequestFetcherKt.postForJAR($receiver, requestUri, walletNonce, walletMetaData, (Continuation<? super String>)$completion);
    }

    public static final /* synthetic */ Object access$decrypt(String $receiver, ECKey recipientKey) {
        return RequestFetcherKt.decrypt($receiver, recipientKey);
    }

    public static final /* synthetic */ ReceivedRequest.Signed access$ensureValid(SiopOpenId4VPConfig $receiver, String expectedClient, Nonce expectedWalletNonce, String unverifiedJwt) {
        return RequestFetcherKt.ensureValid($receiver, expectedClient, expectedWalletNonce, unverifiedJwt);
    }

    public static final /* synthetic */ AuthorizationRequestException access$unsupportedRequestUriMethod(RequestUriMethod m) {
        return RequestFetcherKt.unsupportedRequestUriMethod(m);
    }
}

