/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.response;

import eu.europa.ec.eudi.openid4vp.Consensus;
import eu.europa.ec.eudi.openid4vp.EncryptionParameters;
import eu.europa.ec.eudi.openid4vp.ResolvedRequestObject;
import eu.europa.ec.eudi.openid4vp.ResponseEncryptionSpecification;
import eu.europa.ec.eudi.openid4vp.ResponseMode;
import eu.europa.ec.eudi.openid4vp.internal.response.AuthorizationResponse;
import eu.europa.ec.eudi.openid4vp.internal.response.AuthorizationResponsePayload;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0000\u001a\u001e\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\n"}, d2={"responseWith", "Leu/europa/ec/eudi/openid4vp/internal/response/AuthorizationResponse;", "Leu/europa/ec/eudi/openid4vp/ResolvedRequestObject;", "consensus", "Leu/europa/ec/eudi/openid4vp/Consensus;", "encryptionParameters", "Leu/europa/ec/eudi/openid4vp/EncryptionParameters;", "responsePayload", "Leu/europa/ec/eudi/openid4vp/internal/response/AuthorizationResponsePayload;", "data", "eudi-lib-jvm-siop-openid4vp-kt"})
@SourceDebugExtension(value={"SMAP\nAuthorizationResponse.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuthorizationResponse.kt\neu/europa/ec/eudi/openid4vp/internal/response/AuthorizationResponseKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,285:1\n1#2:286\n*E\n"})
public final class AuthorizationResponseKt {
    @NotNull
    public static final AuthorizationResponse responseWith(@NotNull ResolvedRequestObject $this$responseWith, @NotNull Consensus consensus, @Nullable EncryptionParameters encryptionParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$responseWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)consensus, (String)"consensus");
        AuthorizationResponsePayload payload = AuthorizationResponseKt.responsePayload($this$responseWith, consensus, encryptionParameters);
        return AuthorizationResponseKt.responseWith($this$responseWith, payload);
    }

    private static final AuthorizationResponsePayload responsePayload(ResolvedRequestObject $this$responsePayload, Consensus consensus, EncryptionParameters encryptionParameters) {
        AuthorizationResponsePayload authorizationResponsePayload;
        Consensus consensus2 = consensus;
        if (consensus2 instanceof Consensus.NegativeConsensus) {
            authorizationResponsePayload = new AuthorizationResponsePayload.NoConsensusResponseData($this$responsePayload.getNonce(), $this$responsePayload.getState(), $this$responsePayload.getClient().getId(), encryptionParameters);
        } else if (consensus2 instanceof Consensus.PositiveConsensus) {
            AuthorizationResponsePayload.Success success;
            ResolvedRequestObject resolvedRequestObject = $this$responsePayload;
            if (resolvedRequestObject instanceof ResolvedRequestObject.SiopAuthentication) {
                if (!(consensus instanceof Consensus.PositiveConsensus.IdTokenConsensus)) {
                    boolean $i$a$-require-AuthorizationResponseKt$responsePayload$42 = false;
                    String $i$a$-require-AuthorizationResponseKt$responsePayload$42 = "IdTokenConsensus expected";
                    throw new IllegalArgumentException($i$a$-require-AuthorizationResponseKt$responsePayload$42.toString());
                }
                success = new AuthorizationResponsePayload.SiopAuthentication(((Consensus.PositiveConsensus.IdTokenConsensus)consensus).getIdToken(), ((ResolvedRequestObject.SiopAuthentication)$this$responsePayload).getNonce(), ((ResolvedRequestObject.SiopAuthentication)$this$responsePayload).getState(), ((ResolvedRequestObject.SiopAuthentication)$this$responsePayload).getClient().getId(), encryptionParameters);
            } else if (resolvedRequestObject instanceof ResolvedRequestObject.OpenId4VPAuthorization) {
                if (!(consensus instanceof Consensus.PositiveConsensus.VPTokenConsensus)) {
                    boolean $i$a$-require-AuthorizationResponseKt$responsePayload$52 = false;
                    String $i$a$-require-AuthorizationResponseKt$responsePayload$52 = "VPTokenConsensus expected";
                    throw new IllegalArgumentException($i$a$-require-AuthorizationResponseKt$responsePayload$52.toString());
                }
                success = new AuthorizationResponsePayload.OpenId4VPAuthorization(((Consensus.PositiveConsensus.VPTokenConsensus)consensus).getVerifiablePresentations-C3kSdWY(), ((ResolvedRequestObject.OpenId4VPAuthorization)$this$responsePayload).getNonce(), ((ResolvedRequestObject.OpenId4VPAuthorization)$this$responsePayload).getState(), ((ResolvedRequestObject.OpenId4VPAuthorization)$this$responsePayload).getClient().getId(), encryptionParameters, null);
            } else if (resolvedRequestObject instanceof ResolvedRequestObject.SiopOpenId4VPAuthentication) {
                if (!(consensus instanceof Consensus.PositiveConsensus.IdAndVPTokenConsensus)) {
                    boolean bl = false;
                    String string = "IdAndVPTokenConsensus expected";
                    throw new IllegalArgumentException(string.toString());
                }
                success = new AuthorizationResponsePayload.SiopOpenId4VPAuthentication(((Consensus.PositiveConsensus.IdAndVPTokenConsensus)consensus).getIdToken(), ((Consensus.PositiveConsensus.IdAndVPTokenConsensus)consensus).getVerifiablePresentations-C3kSdWY(), ((ResolvedRequestObject.SiopOpenId4VPAuthentication)$this$responsePayload).getNonce(), ((ResolvedRequestObject.SiopOpenId4VPAuthentication)$this$responsePayload).getState(), ((ResolvedRequestObject.SiopOpenId4VPAuthentication)$this$responsePayload).getClient().getId(), encryptionParameters, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            authorizationResponsePayload = success;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return authorizationResponsePayload;
    }

    private static final AuthorizationResponse responseWith(ResolvedRequestObject $this$responseWith, AuthorizationResponsePayload data) {
        AuthorizationResponse authorizationResponse;
        ResponseMode mode = $this$responseWith.getResponseMode();
        if (mode instanceof ResponseMode.DirectPost) {
            authorizationResponse = new AuthorizationResponse.DirectPost(((ResponseMode.DirectPost)mode).getResponseURI(), data);
        } else if (mode instanceof ResponseMode.DirectPostJwt) {
            ResponseEncryptionSpecification responseEncryptionSpecification = $this$responseWith.getResponseEncryptionSpecification();
            if (responseEncryptionSpecification == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            authorizationResponse = new AuthorizationResponse.DirectPostJwt(((ResponseMode.DirectPostJwt)mode).getResponseURI(), data, responseEncryptionSpecification);
        } else if (mode instanceof ResponseMode.Fragment) {
            authorizationResponse = new AuthorizationResponse.Fragment(((ResponseMode.Fragment)mode).getRedirectUri(), data);
        } else if (mode instanceof ResponseMode.FragmentJwt) {
            ResponseEncryptionSpecification responseEncryptionSpecification = $this$responseWith.getResponseEncryptionSpecification();
            if (responseEncryptionSpecification == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            authorizationResponse = new AuthorizationResponse.FragmentJwt(((ResponseMode.FragmentJwt)mode).getRedirectUri(), data, responseEncryptionSpecification);
        } else if (mode instanceof ResponseMode.Query) {
            authorizationResponse = new AuthorizationResponse.Query(((ResponseMode.Query)mode).getRedirectUri(), data);
        } else if (mode instanceof ResponseMode.QueryJwt) {
            ResponseEncryptionSpecification responseEncryptionSpecification = $this$responseWith.getResponseEncryptionSpecification();
            if (responseEncryptionSpecification == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            authorizationResponse = new AuthorizationResponse.QueryJwt(((ResponseMode.QueryJwt)mode).getRedirectUri(), data, responseEncryptionSpecification);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return authorizationResponse;
    }
}

