/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.ec.eudi.openid4vp.internal.response;

import io.ktor.http.ContentType;
import io.ktor.http.HttpUrlEncodedKt;
import io.ktor.http.Parameters;
import io.ktor.http.content.OutgoingContent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0013"}, d2={"Leu/europa/ec/eudi/openid4vp/internal/response/FormData;", "Lio/ktor/http/content/OutgoingContent$ByteArrayContent;", "formData", "Lio/ktor/http/Parameters;", "<init>", "(Lio/ktor/http/Parameters;)V", "getFormData", "()Lio/ktor/http/Parameters;", "content", "", "contentLength", "", "getContentLength", "()Ljava/lang/Long;", "contentType", "Lio/ktor/http/ContentType;", "getContentType", "()Lio/ktor/http/ContentType;", "bytes", "eudi-lib-jvm-siop-openid4vp-kt"})
public final class FormData
extends OutgoingContent.ByteArrayContent {
    @NotNull
    private final Parameters formData;
    @NotNull
    private final byte[] content;
    private final long contentLength;
    @NotNull
    private final ContentType contentType;

    public FormData(@NotNull Parameters formData) {
        Intrinsics.checkNotNullParameter((Object)formData, (String)"formData");
        this.formData = formData;
        byte[] byArray = HttpUrlEncodedKt.formUrlEncode((Parameters)this.formData).getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.content = byArray;
        this.contentLength = this.content.length;
        this.contentType = ContentType.Application.INSTANCE.getFormUrlEncoded();
    }

    @NotNull
    public final Parameters getFormData() {
        return this.formData;
    }

    @NotNull
    public Long getContentLength() {
        return this.contentLength;
    }

    @NotNull
    public ContentType getContentType() {
        return this.contentType;
    }

    @NotNull
    public byte[] bytes() {
        return this.content;
    }
}

