/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.signature;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.exception.IllegalInputException;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.JAdESSignatureParameters;
import eu.europa.esig.dss.jades.JAdESTimestampParameters;
import eu.europa.esig.dss.jades.JsonObject;
import eu.europa.esig.dss.jades.signature.JAdESLevelBaselineLT;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.model.DigestDocument;
import eu.europa.esig.dss.model.TimestampBinary;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.AdvancedSignature;
import eu.europa.esig.dss.validation.CertificateVerifier;
import eu.europa.esig.dss.validation.ValidationData;
import eu.europa.esig.dss.validation.ValidationDataContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jose4j.json.internal.json_simple.JSONArray;

public class JAdESLevelBaselineLTA
extends JAdESLevelBaselineLT {
    public JAdESLevelBaselineLTA(CertificateVerifier certificateVerifier) {
        super(certificateVerifier);
    }

    @Override
    protected void extendSignatures(List<AdvancedSignature> signatures, JAdESSignatureParameters params) {
        super.extendSignatures(signatures, params);
        boolean addTimestampValidationData = false;
        for (AdvancedSignature signature : signatures) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            this.assertExtendSignatureToLTAPossible(jadesSignature, params);
            this.assertSignatureValid(jadesSignature, params);
            if (!jadesSignature.hasLTAProfile()) continue;
            addTimestampValidationData = true;
        }
        ValidationDataContainer validationDataContainer = null;
        if (addTimestampValidationData) {
            validationDataContainer = this.documentValidator.getValidationData(signatures);
        }
        for (AdvancedSignature signature : signatures) {
            JAdESSignature jadesSignature = (JAdESSignature)signature;
            JAdESEtsiUHeader etsiUHeader = jadesSignature.getEtsiUHeader();
            if (jadesSignature.hasLTAProfile() && addTimestampValidationData) {
                this.removeLastTimestampValidationData(jadesSignature, etsiUHeader);
                ValidationData validationDataForInclusion = validationDataContainer.getCompleteValidationDataForSignature(signature);
                if (!validationDataForInclusion.isEmpty()) {
                    JsonObject tstVd = this.getTstVd(validationDataForInclusion);
                    etsiUHeader.addComponent("tstVD", tstVd, params.isBase64UrlEncodedEtsiUComponents());
                }
            }
            TimestampBinary timestampBinary = this.getArchiveTimestamp(jadesSignature, params);
            JsonObject arcTst = DSSJsonUtils.getTstContainer(Collections.singletonList(timestampBinary), params.getArchiveTimestampParameters().getCanonicalizationMethod());
            etsiUHeader.addComponent("arcTst", arcTst, params.isBase64UrlEncodedEtsiUComponents());
        }
    }

    private void removeLastTimestampValidationData(JAdESSignature jadesSignature, JAdESEtsiUHeader etsiUHeader) {
        etsiUHeader.removeLastComponent("tstVD");
        jadesSignature.resetCertificateSource();
        jadesSignature.resetRevocationSources();
    }

    private JsonObject getTstVd(ValidationData validationDataForInclusion) {
        Set certificateTokens = validationDataForInclusion.getCertificateTokens();
        Set crlTokens = validationDataForInclusion.getCrlTokens();
        Set ocspTokens = validationDataForInclusion.getOcspTokens();
        JsonObject tstVd = new JsonObject();
        if (Utils.isCollectionNotEmpty((Collection)certificateTokens)) {
            JSONArray xVals = this.getXVals(certificateTokens);
            tstVd.put("xVals", (Object)xVals);
        }
        if (Utils.isCollectionNotEmpty((Collection)crlTokens) || Utils.isCollectionNotEmpty((Collection)ocspTokens)) {
            JsonObject rVals = this.getRVals(crlTokens, ocspTokens);
            tstVd.put("rVals", (Object)rVals);
        }
        return tstVd;
    }

    private TimestampBinary getArchiveTimestamp(JAdESSignature jadesSignature, JAdESSignatureParameters params) {
        JAdESTimestampParameters archiveTimestampParameters = params.getArchiveTimestampParameters();
        DigestAlgorithm digestAlgorithmForTimestampRequest = archiveTimestampParameters.getDigestAlgorithm();
        String canonicalizationMethod = archiveTimestampParameters.getCanonicalizationMethod();
        DSSMessageDigest messageDigest = jadesSignature.getTimestampSource().getArchiveTimestampData(digestAlgorithmForTimestampRequest, canonicalizationMethod);
        return this.tspSource.getTimeStampResponse(digestAlgorithmForTimestampRequest, messageDigest.getValue());
    }

    private void assertExtendSignatureToLTAPossible(JAdESSignature jadesSignature, JAdESSignatureParameters params) {
        this.checkArchiveTimestampParameters(params);
        this.assertDetachedDocumentsContainBinaries(params);
        this.checkEtsiUContentUnicity(jadesSignature);
    }

    private void checkArchiveTimestampParameters(JAdESSignatureParameters params) {
        JAdESTimestampParameters archiveTimestampParameters = params.getArchiveTimestampParameters();
        if (!params.isBase64UrlEncodedEtsiUComponents() && Utils.isStringEmpty((String)archiveTimestampParameters.getCanonicalizationMethod())) {
            throw new IllegalInputException("Unable to extend JAdES-LTA level. Clear 'etsiU' incorporation requires a canonicalization method!");
        }
    }

    private void assertDetachedDocumentsContainBinaries(JAdESSignatureParameters params) {
        List detachedContents = params.getDetachedContents();
        if (Utils.isCollectionNotEmpty((Collection)detachedContents)) {
            for (DSSDocument detachedDocument : detachedContents) {
                if (!(detachedDocument instanceof DigestDocument)) continue;
                throw new IllegalArgumentException("JAdES-LTA with All data Timestamp requires complete binaries of signed documents! Extension with a DigestDocument is not possible.");
            }
        }
    }

    private void checkEtsiUContentUnicity(JAdESSignature jadesSignature) {
        List<Object> etsiU = DSSJsonUtils.getEtsiU(jadesSignature.getJws());
        if (!DSSJsonUtils.checkComponentsUnicity(etsiU)) {
            throw new IllegalInputException("Unsupported 'etsiU' container structure! Extension is not possible.");
        }
    }
}

