/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.jades.validation.X509URLCertificateSource;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.x509.CommonCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonX509URLCertificateSource
extends CommonCertificateSource
implements X509URLCertificateSource {
    private static final long serialVersionUID = 5423873125786850353L;
    private static final Logger LOG = LoggerFactory.getLogger(CommonX509URLCertificateSource.class);
    private Map<String, Collection<CertificateToken>> mapByUri = new HashMap<String, Collection<CertificateToken>>();

    public CertificateToken addCertificate(CertificateToken certificateToAdd) {
        throw new UnsupportedOperationException("#addCertificate(certificateToAdd) method is not supported in CommonX509URLCertificateSource! Please use #addCertificate(uri, certificateToAdd) or #addCertificates(uri, certificatesToAdd) methods.");
    }

    public CertificateToken addCertificate(String uri, CertificateToken certificate) {
        CertificateToken addedCertificate = super.addCertificate(certificate);
        Collection<CertificateToken> certificateTokens = this.mapByUri.get(uri);
        if (Utils.isCollectionEmpty(certificateTokens)) {
            certificateTokens = new ArrayList<CertificateToken>();
            this.mapByUri.put(uri, certificateTokens);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("URI {} is already known, the certificate will be added to the existing collection.", (Object)uri);
        }
        certificateTokens.add(certificate);
        return addedCertificate;
    }

    public Collection<CertificateToken> addCertificates(String uri, Collection<CertificateToken> certificates) {
        Collection<CertificateToken> certificateTokens = this.mapByUri.get(uri);
        if (Utils.isCollectionEmpty(certificateTokens)) {
            certificateTokens = new ArrayList<CertificateToken>();
            this.mapByUri.put(uri, certificateTokens);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("URI {} is already known, the certificates will be added to the existing collection.", (Object)uri);
        }
        for (CertificateToken certificate : certificates) {
            CertificateToken addedCertificate = super.addCertificate(certificate);
            certificateTokens.add(addedCertificate);
        }
        return certificateTokens;
    }

    @Override
    public Collection<CertificateToken> getCertificatesByUrl(String uri) {
        return this.mapByUri.get(uri);
    }

    protected void reset() {
        super.reset();
        this.mapByUri = new HashMap<String, Collection<CertificateToken>>();
    }
}

