/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation;

import eu.europa.esig.dss.crl.CRLUtils;
import eu.europa.esig.dss.enumerations.PKIEncoding;
import eu.europa.esig.dss.enumerations.RevocationOrigin;
import eu.europa.esig.dss.enumerations.RevocationRefOrigin;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.validation.JAdESAttribute;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESRevocationRefExtractionUtils;
import eu.europa.esig.dss.model.identifier.EncapsulatedRevocationTokenIdentifier;
import eu.europa.esig.dss.spi.x509.revocation.RevocationRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.CRLRef;
import eu.europa.esig.dss.spi.x509.revocation.crl.OfflineCRLSource;
import eu.europa.esig.dss.utils.Utils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESCRLSource
extends OfflineCRLSource {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESCRLSource.class);
    private static final long serialVersionUID = -8088419662779006608L;
    private final transient JAdESEtsiUHeader etsiUHeader;

    public JAdESCRLSource(JAdESEtsiUHeader etsiUHeader) {
        Objects.requireNonNull(etsiUHeader, "etsiUComponents cannot be null");
        this.etsiUHeader = etsiUHeader;
        this.extractEtsiU();
    }

    private void extractEtsiU() {
        if (!this.etsiUHeader.isExist()) {
            return;
        }
        for (JAdESAttribute jAdESAttribute : this.etsiUHeader.getAttributes()) {
            this.extractRevocationValues(jAdESAttribute);
            this.extractAttributeRevocationValues(jAdESAttribute);
            this.extractTimestampValidationData(jAdESAttribute);
            this.extractCompleteRevocationRefs(jAdESAttribute);
            this.extractAttributeRevocationRefs(jAdESAttribute);
        }
    }

    private void extractRevocationValues(JAdESAttribute attribute) {
        if ("rVals".equals(attribute.getHeaderName())) {
            this.extractCRLValues(DSSJsonUtils.toMap(attribute.getValue(), "rVals"), RevocationOrigin.REVOCATION_VALUES);
        }
    }

    private void extractAttributeRevocationValues(JAdESAttribute attribute) {
        if ("arVals".equals(attribute.getHeaderName())) {
            this.extractCRLValues(DSSJsonUtils.toMap(attribute.getValue(), "arVals"), RevocationOrigin.ATTRIBUTE_REVOCATION_VALUES);
        }
    }

    private void extractTimestampValidationData(JAdESAttribute attribute) {
        Map<?, ?> rVals;
        Map<?, ?> tstVd;
        if ("tstVD".equals(attribute.getHeaderName()) && Utils.isMapNotEmpty(tstVd = DSSJsonUtils.toMap(attribute.getValue(), "tstVD")) && Utils.isMapNotEmpty(rVals = DSSJsonUtils.getAsMap(tstVd, "rVals"))) {
            this.extractCRLValues(rVals, RevocationOrigin.TIMESTAMP_VALIDATION_DATA);
        }
    }

    private void extractCompleteRevocationRefs(JAdESAttribute attribute) {
        if ("rRefs".equals(attribute.getHeaderName())) {
            this.extractCRLReferences(DSSJsonUtils.toMap(attribute.getValue(), "rRefs"), RevocationRefOrigin.COMPLETE_REVOCATION_REFS);
        }
    }

    private void extractAttributeRevocationRefs(JAdESAttribute attribute) {
        if ("arRefs".equals(attribute.getHeaderName())) {
            this.extractCRLReferences(DSSJsonUtils.toMap(attribute.getValue(), "arRefs"), RevocationRefOrigin.ATTRIBUTE_REVOCATION_REFS);
        }
    }

    private void extractCRLValues(Map<?, ?> rVals, RevocationOrigin origin) {
        List<?> crlVals = DSSJsonUtils.getAsList(rVals, "crlVals");
        if (Utils.isCollectionNotEmpty(crlVals)) {
            for (Object item : crlVals) {
                Map<?, ?> pkiOb = DSSJsonUtils.toMap(item, "pkiOb");
                this.extractCRLFromPkiOb(pkiOb, origin);
            }
        }
    }

    private void extractCRLFromPkiOb(Map<?, ?> pkiOb, RevocationOrigin origin) {
        if (Utils.isMapNotEmpty(pkiOb)) {
            String encoding = DSSJsonUtils.getAsString(pkiOb, "encoding");
            if (Utils.isStringEmpty((String)encoding) || Utils.areStringsEqual((String)PKIEncoding.DER.getUri(), (String)encoding)) {
                String val = DSSJsonUtils.getAsString(pkiOb, "val");
                if (Utils.isStringNotEmpty((String)val)) {
                    this.add(val, origin);
                }
            } else {
                LOG.warn("Unsupported encoding '{}'", (Object)encoding);
            }
        }
    }

    private void add(String crlValueDerB64, RevocationOrigin origin) {
        try {
            this.addBinary((EncapsulatedRevocationTokenIdentifier)CRLUtils.buildCRLBinary((byte[])Utils.fromBase64((String)crlValueDerB64)), origin);
        }
        catch (Exception e) {
            LOG.warn("Unable to extract CRL from '{}'. Reason : {}", new Object[]{crlValueDerB64, e.getMessage(), e});
        }
    }

    private void extractCRLReferences(Map<?, ?> rRefs, RevocationRefOrigin origin) {
        List<?> crlRefs = DSSJsonUtils.getAsList(rRefs, "crlRefs");
        if (Utils.isCollectionNotEmpty(crlRefs)) {
            for (Object item : crlRefs) {
                CRLRef crlRef;
                Map<?, ?> crlRefMap = DSSJsonUtils.toMap(item);
                if (!Utils.isMapNotEmpty(crlRefMap) || (crlRef = JAdESRevocationRefExtractionUtils.createCRLRef(crlRefMap)) == null) continue;
                this.addRevocationReference((RevocationRef)crlRef, origin);
            }
        }
    }
}

