/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.jades.validation.timestamp;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.SigDMechanism;
import eu.europa.esig.dss.jades.DSSJsonUtils;
import eu.europa.esig.dss.jades.signature.HttpHeadersPayloadBuilder;
import eu.europa.esig.dss.jades.validation.EtsiUComponent;
import eu.europa.esig.dss.jades.validation.JAdESAttribute;
import eu.europa.esig.dss.jades.validation.JAdESEtsiUHeader;
import eu.europa.esig.dss.jades.validation.JAdESSignature;
import eu.europa.esig.dss.jades.validation.JWS;
import eu.europa.esig.dss.model.DSSDocument;
import eu.europa.esig.dss.model.DSSException;
import eu.europa.esig.dss.model.DSSMessageDigest;
import eu.europa.esig.dss.spi.DSSMessageDigestCalculator;
import eu.europa.esig.dss.spi.DSSUtils;
import eu.europa.esig.dss.spi.x509.tsp.TimestampToken;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.validation.timestamp.TimestampMessageDigestBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jose4j.json.internal.json_simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JAdESTimestampMessageDigestBuilder
implements TimestampMessageDigestBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(JAdESTimestampMessageDigestBuilder.class);
    private static final String MESSAGE_IMPRINT_ERROR = "Unable to compute message-imprint for TimestampToken. Reason : %s";
    private static final String MESSAGE_IMPRINT_ERROR_WITH_ID = "Unable to compute message-imprint for TimestampToken with Id '%s'. Reason : %s";
    private static final String MESSAGE_IMPRINT_MESSAGE = "The '{}' timestamp message-imprint : {}";
    private final JAdESSignature signature;
    private DigestAlgorithm digestAlgorithm;
    private TimestampToken timestampToken;
    private String canonicalizationAlgorithm;
    private JAdESAttribute timestampAttribute;

    public JAdESTimestampMessageDigestBuilder(JAdESSignature signature, DigestAlgorithm digestAlgorithm) {
        this(signature);
        Objects.requireNonNull(digestAlgorithm, "DigestAlgorithm cannot be null!");
        this.digestAlgorithm = digestAlgorithm;
    }

    public JAdESTimestampMessageDigestBuilder(JAdESSignature signature, TimestampToken timestampToken) {
        this(signature);
        Objects.requireNonNull(timestampToken, "TimestampToken cannot be null!");
        this.timestampToken = timestampToken;
        this.digestAlgorithm = timestampToken.getDigestAlgorithm();
        this.canonicalizationAlgorithm = timestampToken.getCanonicalizationMethod();
    }

    private JAdESTimestampMessageDigestBuilder(JAdESSignature signature) {
        Objects.requireNonNull(signature, "Signature cannot be null!");
        this.signature = signature;
    }

    public JAdESTimestampMessageDigestBuilder setCanonicalizationAlgorithm(String canonicalizationAlgorithm) {
        this.canonicalizationAlgorithm = canonicalizationAlgorithm;
        return this;
    }

    public JAdESTimestampMessageDigestBuilder setTimestampAttribute(JAdESAttribute timestampAttribute) {
        this.timestampAttribute = timestampAttribute;
        return this;
    }

    public DSSMessageDigest getContentTimestampMessageDigest() {
        try {
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            this.writeSignedDataBinaries(digestCalculator);
            return digestCalculator.getMessageDigest();
        }
        catch (Exception e) {
            String errorMessage;
            String string = errorMessage = this.timestampToken == null ? String.format(MESSAGE_IMPRINT_ERROR, e.getMessage()) : String.format(MESSAGE_IMPRINT_ERROR_WITH_ID, this.timestampToken.getDSSIdAsString(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Throwable)e);
            } else {
                LOG.warn(errorMessage);
            }
            return DSSMessageDigest.createEmptyDigest();
        }
    }

    private void writeSignedDataBinaries(DSSMessageDigestCalculator digestCalculator) {
        SigDMechanism sigDMechanism = this.signature.getSigDMechanism();
        if (sigDMechanism != null) {
            this.writeSigDReferencedOctets(digestCalculator, sigDMechanism);
        } else {
            this.writeJWSPayloadValue(digestCalculator);
        }
    }

    private void writeJWSPayloadValue(DSSMessageDigestCalculator digestCalculator) {
        byte[] payload = this.signature.getJws().isRfc7797UnencodedPayload() ? this.signature.getJws().getUnverifiedPayloadBytes() : this.signature.getJws().getEncodedPayload().getBytes();
        if (Utils.isArrayEmpty((byte[])payload)) {
            throw new DSSException("Unable to extract JWS payload!");
        }
        digestCalculator.update(payload);
    }

    private void writeSigDReferencedOctets(DSSMessageDigestCalculator digestCalculator, SigDMechanism sigDMechanism) {
        switch (sigDMechanism) {
            case HTTP_HEADERS: {
                List<DSSDocument> documentList = this.signature.getSignedDocumentsByHTTPHeaderName();
                HttpHeadersPayloadBuilder httpHeadersPayloadBuilder = new HttpHeadersPayloadBuilder(documentList, true);
                byte[] sigDOctets = httpHeadersPayloadBuilder.build();
                digestCalculator.update(sigDOctets);
                break;
            }
            case OBJECT_ID_BY_URI: 
            case OBJECT_ID_BY_URI_HASH: {
                List<DSSDocument> documentList = this.signature.getSignedDocumentsForObjectIdByUriMechanism();
                DSSJsonUtils.writeDocumentsDigest(documentList, !this.signature.getJws().isRfc7797UnencodedPayload(), digestCalculator);
                break;
            }
            default: {
                LOG.warn("Unsupported SigDMechanism '{}' has been found!", (Object)sigDMechanism);
            }
        }
    }

    public DSSMessageDigest getSignatureTimestampMessageDigest() {
        try {
            byte[] signatureTimestampData = this.getBase64UrlEncodedSignatureValue();
            return new DSSMessageDigest(this.digestAlgorithm, DSSUtils.digest((DigestAlgorithm)this.digestAlgorithm, (byte[])signatureTimestampData));
        }
        catch (Exception e) {
            String errorMessage;
            String string = errorMessage = this.timestampToken == null ? String.format(MESSAGE_IMPRINT_ERROR, e.getMessage()) : String.format(MESSAGE_IMPRINT_ERROR_WITH_ID, this.timestampToken.getDSSIdAsString(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Throwable)e);
            } else {
                LOG.warn(errorMessage);
            }
            return DSSMessageDigest.createEmptyDigest();
        }
    }

    public DSSMessageDigest getTimestampX1MessageDigest() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("--->Get '{}' timestamp data", (Object)"sigRTst");
            }
            JWS jws = this.signature.getJws();
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            digestCalculator.update(this.getBase64UrlEncodedSignatureValue());
            digestCalculator.update((byte)46);
            List<Object> etsiU = DSSJsonUtils.getEtsiU(jws);
            if (DSSJsonUtils.checkComponentsUnicity(etsiU)) {
                JAdESEtsiUHeader etsiUHeader = this.signature.getEtsiUHeader();
                for (EtsiUComponent etsiUComponent : etsiUHeader.getAttributes()) {
                    if (this.timestampAttribute == null || !this.timestampAttribute.equals(etsiUComponent)) {
                        if (!this.isAllowedTypeEntry(etsiUComponent, "sigTst", "xRefs", "rRefs", "axRefs", "arRefs")) continue;
                        digestCalculator.update(this.getEtsiUComponentValue(etsiUComponent, this.canonicalizationAlgorithm));
                        continue;
                    }
                    break;
                }
            } else {
                LOG.warn("Unable to process 'etsiU' entries for a '{}' timestamp. The 'etsiU' components shall have a common format (Strings or Objects)!", (Object)"sigRTst");
            }
            DSSMessageDigest messageDigest = digestCalculator.getMessageDigest();
            if (LOG.isTraceEnabled()) {
                LOG.trace(MESSAGE_IMPRINT_MESSAGE, (Object)"sigRTst", (Object)messageDigest);
            }
            return messageDigest;
        }
        catch (Exception e) {
            String errorMessage;
            String string = errorMessage = this.timestampToken == null ? String.format(MESSAGE_IMPRINT_ERROR, e.getMessage()) : String.format(MESSAGE_IMPRINT_ERROR_WITH_ID, this.timestampToken.getDSSIdAsString(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Throwable)e);
            } else {
                LOG.warn(errorMessage);
            }
            return DSSMessageDigest.createEmptyDigest();
        }
    }

    private boolean isAllowedTypeEntry(EtsiUComponent etsiUComponent, String ... allowedTypes) {
        return Arrays.asList(allowedTypes).contains(etsiUComponent.getHeaderName());
    }

    public DSSMessageDigest getTimestampX2MessageDigest() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("--->Get '{}' timestamp data", (Object)"rfsTst");
            }
            JWS jws = this.signature.getJws();
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            List<Object> etsiU = DSSJsonUtils.getEtsiU(jws);
            if (DSSJsonUtils.checkComponentsUnicity(etsiU)) {
                JAdESEtsiUHeader etsiUHeader = this.signature.getEtsiUHeader();
                for (EtsiUComponent etsiUComponent : etsiUHeader.getAttributes()) {
                    if (!this.isAllowedTypeEntry(etsiUComponent, "xRefs", "rRefs", "axRefs", "arRefs")) continue;
                    digestCalculator.update(this.getEtsiUComponentValue(etsiUComponent, this.canonicalizationAlgorithm));
                }
            } else {
                LOG.warn("Unable to process 'etsiU' entries for an '{}' timestamp. The 'etsiU' components shall have a common format (Strings or Objects)!", (Object)"rfsTst");
            }
            DSSMessageDigest messageDigest = digestCalculator.getMessageDigest();
            if (LOG.isTraceEnabled()) {
                LOG.trace(MESSAGE_IMPRINT_MESSAGE, (Object)"rfsTst", (Object)messageDigest);
            }
            return messageDigest;
        }
        catch (Exception e) {
            String errorMessage;
            String string = errorMessage = this.timestampToken == null ? String.format(MESSAGE_IMPRINT_ERROR, e.getMessage()) : String.format(MESSAGE_IMPRINT_ERROR_WITH_ID, this.timestampToken.getDSSIdAsString(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Throwable)e);
            } else {
                LOG.warn(errorMessage);
            }
            return DSSMessageDigest.createEmptyDigest();
        }
    }

    public DSSMessageDigest getArchiveTimestampMessageDigest() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("--->Get '{}' timestamp data : {}", (Object)"arcTst", (Object)(this.timestampToken == null ? "--> CREATION" : "--> VALIDATION"));
            }
            JWS jws = this.signature.getJws();
            DSSMessageDigestCalculator digestCalculator = new DSSMessageDigestCalculator(this.digestAlgorithm);
            this.writeSignedDataBinaries(digestCalculator);
            digestCalculator.update((byte)46);
            digestCalculator.update(jws.getEncodedHeader().getBytes());
            digestCalculator.update((byte)46);
            digestCalculator.update(this.getBase64UrlEncodedSignatureValue());
            digestCalculator.update((byte)46);
            List<Object> etsiU = DSSJsonUtils.getEtsiU(jws);
            if (DSSJsonUtils.checkComponentsUnicity(etsiU)) {
                JAdESEtsiUHeader etsiUHeader = this.signature.getEtsiUHeader();
                for (EtsiUComponent etsiUComponent : etsiUHeader.getAttributes()) {
                    if (this.timestampAttribute == null || !this.timestampAttribute.equals(etsiUComponent)) {
                        digestCalculator.update(this.getEtsiUComponentValue(etsiUComponent, this.canonicalizationAlgorithm));
                        continue;
                    }
                    break;
                }
            } else {
                LOG.warn("Unable to process 'etsiU' entries for an '{}' timestamp. The 'etsiU' components shall have a common format (Strings or Objects)!", (Object)"arcTst");
            }
            DSSMessageDigest messageDigest = digestCalculator.getMessageDigest();
            if (LOG.isTraceEnabled()) {
                LOG.trace(MESSAGE_IMPRINT_MESSAGE, (Object)"arcTst", (Object)messageDigest);
            }
            return messageDigest;
        }
        catch (Exception e) {
            String errorMessage;
            String string = errorMessage = this.timestampToken == null ? String.format(MESSAGE_IMPRINT_ERROR, e.getMessage()) : String.format(MESSAGE_IMPRINT_ERROR_WITH_ID, this.timestampToken.getDSSIdAsString(), e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.warn(errorMessage, (Throwable)e);
            } else {
                LOG.warn(errorMessage);
            }
            return DSSMessageDigest.createEmptyDigest();
        }
    }

    private byte[] getBase64UrlEncodedSignatureValue() {
        String messageImprint = this.signature.getJws().getEncodedSignature();
        if (LOG.isTraceEnabled()) {
            LOG.trace(MESSAGE_IMPRINT_MESSAGE, (Object)"sigTst", (Object)messageImprint);
        }
        return messageImprint.getBytes();
    }

    private byte[] getEtsiUComponentValue(EtsiUComponent etsiUComponent, String canonicalizationMethod) {
        Object component = etsiUComponent.getComponent();
        if (etsiUComponent.isBase64UrlEncoded()) {
            return ((String)component).getBytes();
        }
        return this.getCanonicalizedValue(etsiUComponent.getValue(), canonicalizationMethod);
    }

    private byte[] getCanonicalizedValue(Object jsonObject, String canonicalizationMethod) {
        LOG.warn("Canonicalization is not supported in the current version. The message imprint computation can lead to an unexpected result");
        String jsonString = JSONValue.toJSONString((Object)jsonObject);
        return jsonString.getBytes();
    }
}

