/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.server.signing.rest.client;

import eu.europa.esig.dss.enumerations.DigestAlgorithm;
import eu.europa.esig.dss.enumerations.MaskGenerationFunction;
import eu.europa.esig.dss.ws.dto.DigestDTO;
import eu.europa.esig.dss.ws.dto.SignatureValueDTO;
import eu.europa.esig.dss.ws.dto.ToBeSignedDTO;
import eu.europa.esig.dss.ws.server.signing.dto.RemoteKeyEntry;
import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Path(value="/")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public interface RestSignatureTokenConnection
extends Serializable {
    @GET
    @Path(value="keys")
    public List<RemoteKeyEntry> getKeys();

    @GET
    @Path(value="key/{alias}")
    public RemoteKeyEntry getKey(@PathParam(value="alias") String var1);

    @POST
    @Path(value="sign/{alias}/{algo}")
    public SignatureValueDTO sign(ToBeSignedDTO var1, @PathParam(value="algo") DigestAlgorithm var2, @PathParam(value="alias") String var3);

    @POST
    @Path(value="sign/{alias}/{digest-algo}/{mask}")
    public SignatureValueDTO sign(ToBeSignedDTO var1, @PathParam(value="digest-algo") DigestAlgorithm var2, @PathParam(value="mask") MaskGenerationFunction var3, @PathParam(value="alias") String var4);

    @POST
    @Path(value="sign-digest/{alias}")
    public SignatureValueDTO signDigest(DigestDTO var1, @PathParam(value="alias") String var2);

    @POST
    @Path(value="sign-digest/{alias}/{mask}")
    public SignatureValueDTO signDigest(DigestDTO var1, @PathParam(value="mask") MaskGenerationFunction var2, @PathParam(value="alias") String var3);
}

