/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.ws.validation.dto;

import eu.europa.esig.dss.detailedreport.jaxb.XmlDetailedReport;
import eu.europa.esig.dss.diagnostic.jaxb.XmlDiagnosticData;
import eu.europa.esig.dss.simplereport.jaxb.XmlSimpleReport;
import eu.europa.esig.dss.ws.dto.exception.DSSRemoteServiceException;
import eu.europa.esig.dss.ws.validation.dto.ValidationReportTypeDataSource;
import eu.europa.esig.validationreport.ValidationReportFacade;
import eu.europa.esig.validationreport.jaxb.ValidationReportType;
import java.io.Serializable;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlMimeType;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class WSReportsDTO
implements Serializable {
    @XmlElement(name="DiagnosticData", namespace="http://dss.esig.europa.eu/validation/diagnostic")
    private XmlDiagnosticData diagnosticData;
    @XmlElement(name="SimpleReport", namespace="http://dss.esig.europa.eu/validation/simple-report")
    private XmlSimpleReport simpleReport;
    @XmlElement(name="DetailedReport", namespace="http://dss.esig.europa.eu/validation/detailed-report")
    private XmlDetailedReport detailedReport;
    @XmlMimeType(value="application/octet-stream")
    private DataHandler validationReportDataHandler;
    private transient ValidationReportType validationReport;

    public WSReportsDTO() {
    }

    public WSReportsDTO(XmlDiagnosticData diagnosticData, XmlSimpleReport simpleReport, XmlDetailedReport detailedReport) {
        this.diagnosticData = diagnosticData;
        this.detailedReport = detailedReport;
        this.simpleReport = simpleReport;
    }

    public WSReportsDTO(XmlDiagnosticData diagnosticData, XmlSimpleReport simpleReport, XmlDetailedReport detailedReport, ValidationReportType validationReport) {
        this(diagnosticData, simpleReport, detailedReport);
        this.validationReport = validationReport;
        this.validationReportDataHandler = new DataHandler((DataSource)new ValidationReportTypeDataSource(validationReport));
    }

    public XmlDiagnosticData getDiagnosticData() {
        return this.diagnosticData;
    }

    public void setDiagnosticData(XmlDiagnosticData diagnosticData) {
        this.diagnosticData = diagnosticData;
    }

    public XmlSimpleReport getSimpleReport() {
        return this.simpleReport;
    }

    public void setSimpleReport(XmlSimpleReport simpleReport) {
        this.simpleReport = simpleReport;
    }

    public XmlDetailedReport getDetailedReport() {
        return this.detailedReport;
    }

    public void setDetailedReport(XmlDetailedReport detailedReport) {
        this.detailedReport = detailedReport;
    }

    public DataHandler getValidationReportDataHandler() {
        return this.validationReportDataHandler;
    }

    public void setValidationReportDataHandler(DataHandler validationReportDataHandler) {
        this.validationReportDataHandler = validationReportDataHandler;
    }

    public ValidationReportType getValidationReport() {
        if (this.validationReport == null && this.validationReportDataHandler != null) {
            try {
                this.validationReport = (ValidationReportType)ValidationReportFacade.newFacade().unmarshall(this.validationReportDataHandler.getInputStream());
            }
            catch (Exception e) {
                throw new DSSRemoteServiceException("Unable to unmarshall ValidationReportType", (Throwable)e);
            }
        }
        return this.validationReport;
    }

    public void setValidationReport(ValidationReportType validationReport) {
        this.validationReport = validationReport;
    }
}

