/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.reference;

import eu.europa.esig.dss.xades.reference.DSSTransform;
import eu.europa.esig.dss.xml.common.definition.DSSElement;
import eu.europa.esig.dss.xml.common.definition.DSSNamespace;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigElement;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigNamespace;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.Objects;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractTransform
implements DSSTransform {
    private static final long serialVersionUID = 7176619121506452500L;
    protected final String algorithm;
    protected DSSNamespace namespace = XMLDSigNamespace.NS;

    protected AbstractTransform(String algorithm) {
        this.algorithm = algorithm;
    }

    protected AbstractTransform(DSSNamespace xmlDSigNamespace, String algorithm) {
        this.namespace = xmlDSigNamespace;
        this.algorithm = algorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public void setNamespace(DSSNamespace namespace) {
        this.namespace = namespace;
    }

    @Override
    public Element createTransform(Document document, Element parentNode) {
        Element transformDom = DomUtils.addElement((Document)document, (Element)parentNode, (DSSNamespace)this.namespace, (DSSElement)XMLDSigElement.TRANSFORM);
        transformDom.setAttribute(XMLDSigAttribute.ALGORITHM.getAttributeName(), this.algorithm);
        return transformDom;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + (this.namespace == null ? 0 : this.namespace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTransform other = (AbstractTransform)obj;
        if (!Objects.equals(this.algorithm, other.algorithm)) {
            return false;
        }
        return Objects.equals(this.namespace, other.namespace);
    }

    public String toString() {
        return "DSSTransform [algorithm=" + this.algorithm + ", namespace=" + this.namespace + "]";
    }
}

