/*
 * Decompiled with CFR 0.152.
 */
package eu.europa.esig.dss.xades.validation;

import eu.europa.esig.dss.enumerations.DigestMatcherType;
import eu.europa.esig.dss.model.ReferenceValidation;
import eu.europa.esig.dss.model.x509.CertificateToken;
import eu.europa.esig.dss.spi.signature.BaselineRequirementsChecker;
import eu.europa.esig.dss.spi.signature.DefaultAdvancedSignature;
import eu.europa.esig.dss.spi.validation.CertificateVerifier;
import eu.europa.esig.dss.spi.x509.ListCertificateSource;
import eu.europa.esig.dss.utils.Utils;
import eu.europa.esig.dss.xades.DSSXMLUtils;
import eu.europa.esig.dss.xades.XAdESSignatureUtils;
import eu.europa.esig.dss.xades.definition.XAdESNamespace;
import eu.europa.esig.dss.xades.definition.XAdESPath;
import eu.europa.esig.dss.xades.definition.xades132.XAdES132Attribute;
import eu.europa.esig.dss.xades.validation.XAdESCertificateSource;
import eu.europa.esig.dss.xades.validation.XAdESSignature;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigAttribute;
import eu.europa.esig.dss.xml.common.definition.xmldsig.XMLDSigPath;
import eu.europa.esig.dss.xml.utils.DomUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XAdESBaselineRequirementsChecker
extends BaselineRequirementsChecker<XAdESSignature> {
    private static final Logger LOG = LoggerFactory.getLogger(XAdESBaselineRequirementsChecker.class);
    private Map<String, ReferenceValidationStatus> statusMap;

    public XAdESBaselineRequirementsChecker(XAdESSignature signature, CertificateVerifier offlineCertificateVerifier) {
        super((DefaultAdvancedSignature)signature, offlineCertificateVerifier);
    }

    public boolean hasBaselineBProfile() {
        NodeList signingCertificateV2List;
        String signingCertificateV2Path;
        String canonicalizationMethod;
        String archiveTimestampPath;
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        XAdESPath xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths();
        if (this.getNumberOfOccurrences(signatureElement, XMLDSigPath.KEY_INFO_PATH) != 1) {
            LOG.warn("ds:KeyInfo element shall be present for XAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, XMLDSigPath.SIGNED_INFO_CANONICALIZATION_METHOD) != 1) {
            LOG.warn("ds:SignedInfo/ds:CanonicalizationMethod element shall be present for XAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, XMLDSigPath.SIGNED_INFO_REFERENCE_PATH) < 2) {
            LOG.warn("ds:SignedInfo/ds:Reference element shall be present for XAdES-BASELINE-B signature (cardinality >= 2)!");
            return false;
        }
        NodeList referenceList = DomUtils.getNodeList((Node)signatureElement, (String)XMLDSigPath.SIGNED_INFO_REFERENCE_PATH);
        if (referenceList != null && referenceList.getLength() > 0) {
            for (int ii = 0; ii < referenceList.getLength(); ++ii) {
                Element reference = (Element)referenceList.item(ii);
                if (DomUtils.getNodesAmount((Node)reference, (String)XMLDSigPath.TRANSFORMS_PATH) <= 1) continue;
                LOG.warn("Only one ds:Reference/ds:Transforms may be present for XAdES-BASELINE-B signature (cardinality 0 or 1)!");
                return false;
            }
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getSigningTimePath()) != 1) {
            LOG.warn("SigningTime shall be present for XAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (!this.isSigningCertificatePresent(signatureElement, xadesPaths)) {
            LOG.warn("SigningCertificate(V2) shall be present for XAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        Map<String, ReferenceValidationStatus> referenceStatusMap = this.getReferenceValidationStatusMap();
        NodeList dataObjectFormatList = this.getDataObjectFormatList(signatureElement, xadesPaths);
        for (int ii = 0; ii < dataObjectFormatList.getLength(); ++ii) {
            Element dataObjectFormat = (Element)dataObjectFormatList.item(ii);
            if (this.isValidXAdESBaselineDataObjectFormat(dataObjectFormat, (XAdESSignature)this.signature, xadesPaths, referenceStatusMap)) continue;
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignerRolePath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignerRoleV2Path()) > 1) {
            LOG.warn("Only one SignerRole(V2) may be present for XAdES-BASELINE-B signature (cardinality 0 or 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignatureProductionPlacePath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignatureProductionPlaceV2Path()) > 1) {
            LOG.warn("Only one SignatureProductionPlace(V2) may be present for XAdES-BASELINE-B signature (cardinality 0 or 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignaturePolicyIdentifierPath()) > 1) {
            LOG.warn("Only one SignaturePolicyIdentifier may be present for XAdES-BASELINE-B signature (cardinality 0 or 1)!");
            return false;
        }
        int signaturePolicyStoreAmount = this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignaturePolicyStorePath());
        if (signaturePolicyStoreAmount == 1) {
            if (!this.isSignaturePolicyIdentifierHashPresent()) {
                LOG.warn("SignaturePolicyStore shall not be present for XAdES-BASELINE-B signature with not defined SignaturePolicyIdentifier/SigPolicyHash (requirement (m))!");
            }
        } else if (signaturePolicyStoreAmount > 1) {
            LOG.warn("Only one SignaturePolicyIdentifier may be present for XAdES-BASELINE-B signature (cardinality 0 or 1)!");
            return false;
        }
        if (Utils.isStringNotEmpty((String)(archiveTimestampPath = xadesPaths.getArchiveTimestampPath()))) {
            NodeList archiveTimeStampList = DomUtils.getNodeList((Node)signatureElement, (String)archiveTimestampPath);
            for (int ii = 0; ii < archiveTimeStampList.getLength(); ++ii) {
                Object archiveTimeStamp = archiveTimeStampList.item(ii);
                if (!XAdESNamespace.XADES_132.getUri().equals(archiveTimeStamp.getNamespaceURI())) continue;
                LOG.warn("xades132:ArchiveTimeStamp shall not be present for XAdES-BASELINE-B signature (cardinality == 0)!");
                return false;
            }
        }
        if (!this.containsSigningCertificate(((XAdESSignature)this.signature).getCertificateSource().getKeyInfoCertificates())) {
            LOG.warn("Signing certificate shall be present in ds:KeyInfo/ds:X509Data/ds:X509Certificate for XAdES-BASELINE-B signature (requirement (a))!");
            return false;
        }
        Element signedInfo = ((XAdESSignature)this.signature).getSignedInfo();
        if (signedInfo != null && Utils.isStringNotEmpty((String)(canonicalizationMethod = DomUtils.getValue((Node)signedInfo, (String)XMLDSigPath.CANONICALIZATION_ALGORITHM_PATH)))) {
            switch (canonicalizationMethod) {
                case "http://www.w3.org/2006/12/xml-c14n11": 
                case "http://www.w3.org/2001/10/xml-exc-c14n#": 
                case "http://www.w3.org/TR/2001/REC-xml-c14n-20010315": 
                case "http://www.w3.org/2006/12/xml-c14n11#WithComments": 
                case "http://www.w3.org/2001/10/xml-exc-c14n#WithComments": 
                case "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments": {
                    break;
                }
                default: {
                    LOG.warn("ds:SignedInfo/ds:CanonicalizationMethod contains not accepted Algorithm attribute value for XAdES-BASELINE-B signature (requirement (d))!");
                    return false;
                }
            }
        }
        if (Utils.isStringNotEmpty((String)(signingCertificateV2Path = xadesPaths.getSigningCertificateV2Path())) && (signingCertificateV2List = DomUtils.getNodeList((Node)signatureElement, (String)signingCertificateV2Path)).getLength() == 1) {
            Node signingCertificateV2 = signingCertificateV2List.item(0);
            NodeList certList = DomUtils.getNodeList((Node)signingCertificateV2, (String)xadesPaths.getCurrentCertChildren());
            for (int ii = 0; ii < certList.getLength(); ++ii) {
                Element cert = (Element)certList.item(ii);
                if (!cert.hasAttribute(XAdES132Attribute.URI.getAttributeName())) continue;
                LOG.warn("SigningCertificateV2/Cert shall not include URI optional attribute for XAdES-BASELINE-B signature (requirement (i))!");
                return false;
            }
        }
        for (ReferenceValidationStatus referenceStatus : referenceStatusMap.values()) {
            ReferenceValidation referenceValidation;
            if (referenceStatus.isDataObjectFormatFound() || (DomUtils.startsFromHash((String)(referenceValidation = referenceStatus.getReferenceValidation()).getUri()) || DomUtils.isXPointerQuery((String)referenceValidation.getUri())) && (DigestMatcherType.SIGNED_PROPERTIES.equals((Object)referenceValidation.getType()) || DigestMatcherType.COUNTER_SIGNATURE.equals((Object)referenceValidation.getType()) || DigestMatcherType.MANIFEST.equals((Object)referenceValidation.getType()) || DigestMatcherType.KEY_INFO.equals((Object)referenceValidation.getType()) || DigestMatcherType.SIGNATURE_PROPERTIES.equals((Object)referenceValidation.getType()))) continue;
            LOG.warn("DataObjectFormat shall be generated for each signed data for XAdES-BASELINE-B signature (requirement (k))!");
            return false;
        }
        return true;
    }

    public boolean hasBaselineTProfile() {
        if (!this.minimalTRequirement()) {
            return false;
        }
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        XAdESPath xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths();
        NodeList signatureTimeStampList = DomUtils.getNodeList((Node)signatureElement, (String)xadesPaths.getSignatureTimestampPath());
        for (int ii = 0; ii < signatureTimeStampList.getLength(); ++ii) {
            Node signatureTimeStamp = signatureTimeStampList.item(ii);
            NodeList encapsulatedTimestampList = DomUtils.getNodeList((Node)signatureTimeStamp, (String)xadesPaths.getCurrentEncapsulatedTimestamp());
            if (encapsulatedTimestampList.getLength() == 1) continue;
            LOG.warn("SignatureTimeStamp shall contain only one electronic timestamp for XAdES-BASELINE-T signature (requirement (n))!");
            return false;
        }
        if (!this.signatureTimestampsCreatedBeforeSignCertExpiration()) {
            LOG.warn("SignatureTimeStamp shall be created before expiration of the signing-certificate for XAdES-BASELINE-T signature (requirement (o))!");
            return false;
        }
        return true;
    }

    public boolean hasBaselineLTProfile() {
        XAdESPath xadesPaths;
        if (!this.minimalLTRequirement()) {
            return false;
        }
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        if (this.getNumberOfOccurrences(signatureElement, (xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths()).getCertificateValuesPath()) > 1) {
            LOG.warn("Only one CertificateValues element may be present for XAdES-BASELINE-LT signature (cardinality 0 or 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getCompleteCertificateRefsPath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getCompleteCertificateRefsV2Path()) > 0) {
            LOG.warn("CompleteCertificateRefs(V2) shall not be present for XAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getAttrAuthoritiesCertValuesPath()) > 1) {
            LOG.warn("Only one AttrAuthoritiesCertValues element may be present for XAdES-BASELINE-LT signature (cardinality 0 or 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getRevocationValuesPath()) > 1) {
            LOG.warn("Only one RevocationValues element may be present for XAdES-BASELINE-LT signature (cardinality 0 or 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getCompleteRevocationRefsPath()) > 0) {
            LOG.warn("CompleteRevocationRefs shall not be present for XAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getAttributeRevocationValuesPath()) > 1) {
            LOG.warn("AttributeRevocationValues shall not be present for XAdES-BASELINE-LT signature (cardinality 0 or 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getSigAndRefsTimestampPath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getSigAndRefsTimestampV2Path()) > 0) {
            LOG.warn("SigAndRefsTimeStamp(V2) shall not be present for XAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getRefsOnlyTimestampPath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getRefsOnlyTimestampV2Path()) > 0) {
            LOG.warn("RefsOnlyTimeStampV2 shall not be present for XAdES-BASELINE-LT signature (cardinality == 0)!");
            return false;
        }
        return true;
    }

    protected boolean containsLTLevelCertificates() {
        return this.containsCertificateValues() || this.containsTstOrAnyValDataCertificates();
    }

    private boolean containsCertificateValues() {
        XAdESPath xadesPaths;
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        return this.getNumberOfOccurrences(signatureElement, (xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths()).getCertificateValuesPath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getAttrAuthoritiesCertValuesPath()) != 0;
    }

    private boolean containsTstOrAnyValDataCertificates() {
        XAdESPath xadesPaths;
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        return this.getNumberOfOccurrences(signatureElement, (xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths()).getEncapsulatedTimeStampValidationDataCertValuesPath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getEncapsulatedAnyValidationDataCertValuesPath()) != 0;
    }

    public boolean hasBaselineLTAProfile() {
        return this.minimalLTARequirement();
    }

    public boolean hasExtendedBESProfile() {
        XAdESPath xadesPaths;
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        if (this.getNumberOfOccurrences(signatureElement, (xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths()).getSigningTimePath()) > 1) {
            LOG.warn("Only one SigningTime may be present for XAdES-BES signature (cardinality 0 or 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getSigningCertificatePath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getSigningCertificateV2Path()) > 1) {
            LOG.warn("Only one SigningCertificate(V2) may be present for XAdES-BES signature (cardinality 0 or 1)!");
            return false;
        }
        Map<String, ReferenceValidationStatus> referenceStatusMap = this.getReferenceValidationStatusMap();
        NodeList dataObjectFormatList = this.getDataObjectFormatList(signatureElement, xadesPaths);
        for (int ii = 0; ii < dataObjectFormatList.getLength(); ++ii) {
            Element dataObjectFormat = (Element)dataObjectFormatList.item(ii);
            if (this.isValidXAdESDataObjectFormat(dataObjectFormat, (XAdESSignature)this.signature, xadesPaths, referenceStatusMap)) continue;
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignatureProductionPlacePath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignatureProductionPlaceV2Path()) > 1) {
            LOG.warn("Only one SignatureProductionPlace(V2) may be present for XAdES-BES signature (cardinality 0 or 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignerRolePath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignerRoleV2Path()) > 1) {
            LOG.warn("Only one SignerRole(V2) may be present for XAdES-BES signature (cardinality 0 or 1)!");
            return false;
        }
        if (!this.isSigningCertificatePresent(signatureElement, xadesPaths) && !this.isSigningCertificateSignedInKeyInfo()) {
            LOG.warn("SigningCertificate(V2) shall be present for XAdES-BES signature or be present in ds:KeyInfo and signed by the signature (requirement (a))!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedEPESProfile() {
        XAdESPath xadesPaths;
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        if (this.getNumberOfOccurrences(signatureElement, (xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths()).getSignaturePolicyIdentifierPath()) != 1) {
            LOG.debug("SignaturePolicyIdentifier shall be present for XAdES-EPES signature (cardinality == 1)!");
            return false;
        }
        int signaturePolicyStoreOccurrences = this.getNumberOfOccurrences(signatureElement, xadesPaths.getSignaturePolicyStorePath());
        if (signaturePolicyStoreOccurrences > 1) {
            LOG.debug("Only one SignaturePolicyStore may be present for XAdES-EPES signature (cardinality 0 or 1)!");
            return false;
        }
        if (signaturePolicyStoreOccurrences == 1 && !this.isSignaturePolicyIdentifierHashPresent()) {
            LOG.debug("SignaturePolicyStore may be present for XAdES-EPES signature only if SignaturePolicyIdentifier is present and it contains SigPolicyHash element (requirement (c))!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedTProfile() {
        if (!this.minimalTRequirement()) {
            return false;
        }
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        XAdESPath xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths();
        NodeList signatureTimeStampList = DomUtils.getNodeList((Node)signatureElement, (String)xadesPaths.getSignatureTimestampPath());
        for (int ii = 0; ii < signatureTimeStampList.getLength(); ++ii) {
            Node signatureTimeStamp = signatureTimeStampList.item(ii);
            NodeList encapsulatedTimestampList = DomUtils.getNodeList((Node)signatureTimeStamp, (String)xadesPaths.getCurrentEncapsulatedTimestamp());
            if (encapsulatedTimestampList.getLength() != 0) continue;
            LOG.warn("SignatureTimeStamp shall contain one or more electronic timestamp for XAdES-T signature (requirement (d))!");
            return false;
        }
        if (!this.signatureTimestampsCreatedBeforeSignCertExpiration()) {
            LOG.warn("SignatureTimeStamp shall be created before expiration of the signing-certificate for XAdES-T signature (requirement (e))!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedCProfile() {
        XAdESPath xadesPaths;
        ListCertificateSource certificateSources = this.getCertificateSourcesExceptLastArchiveTimestamp();
        boolean certificateFound = certificateSources.getNumberOfCertificates() > 0;
        boolean allSelfSigned = certificateFound && certificateSources.isAllSelfSigned();
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        int completeCertificateRefsNumberOfOccurrences = this.getNumberOfOccurrences(signatureElement, (xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths()).getCompleteCertificateRefsPath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getCompleteCertificateRefsV2Path());
        if (completeCertificateRefsNumberOfOccurrences > 1 || !allSelfSigned && completeCertificateRefsNumberOfOccurrences == 0) {
            LOG.debug("CompleteCertificateRefs(V2) shall be present for XAdES-C signature (cardinality == 1)!");
            return false;
        }
        int completeRevocationRefsNumberOfOccurrences = this.getNumberOfOccurrences(signatureElement, xadesPaths.getCompleteRevocationRefsPath());
        if (completeRevocationRefsNumberOfOccurrences > 1 || !allSelfSigned && completeRevocationRefsNumberOfOccurrences == 0) {
            LOG.debug("CompleteRevocationRefs shall be present for XAdES-C signature (cardinality == 1)!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedXProfile() {
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        XAdESPath xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths();
        boolean refsOnlyTst = this.isElementPresent(signatureElement, xadesPaths.getRefsOnlyTimestampPath());
        boolean refsOnlyTstV2 = this.isElementPresent(signatureElement, xadesPaths.getRefsOnlyTimestampV2Path());
        boolean sigAndRefsTst = this.isElementPresent(signatureElement, xadesPaths.getSigAndRefsTimestampPath());
        boolean sigAndRefsTstV2 = this.isElementPresent(signatureElement, xadesPaths.getSigAndRefsTimestampV2Path());
        if (!(refsOnlyTst || refsOnlyTstV2 || sigAndRefsTst || sigAndRefsTstV2)) {
            LOG.debug("Either RefsOnlyTimestamp(V2) or SigAndRefsTimestamp(V2) shall be present for XAdES-X signature)!");
            return false;
        }
        return true;
    }

    public boolean hasExtendedXLProfile() {
        return this.minimalLTRequirement();
    }

    public boolean hasExtendedAProfile() {
        return this.minimalLTARequirement();
    }

    public boolean hasExtendedERSProfile() {
        XAdESPath xadesPaths;
        Element signatureElement = ((XAdESSignature)this.signature).getSignatureElement();
        if (this.getNumberOfOccurrences(signatureElement, (xadesPaths = ((XAdESSignature)this.signature).getXAdESPaths()).getSigningTimePath()) != 1) {
            LOG.debug("SigningTime shall be present for XAdES-E-ERS signature (cardinality == 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(signatureElement, xadesPaths.getSealingEvidenceRecordsPath()) == 0) {
            LOG.debug("xadesen:SealingEvidenceRecords shall be present for XAdES-E-ERS signature (cardinality >= 1)!");
            return false;
        }
        return true;
    }

    private boolean isSigningCertificatePresent(Element signatureElement, XAdESPath xadesPaths) {
        return this.getNumberOfOccurrences(signatureElement, xadesPaths.getSigningCertificatePath()) + this.getNumberOfOccurrences(signatureElement, xadesPaths.getSigningCertificateV2Path()) == 1;
    }

    private NodeList getDataObjectFormatList(Element signatureElement, XAdESPath xadesPaths) {
        return DomUtils.getNodeList((Node)signatureElement, (String)xadesPaths.getDataObjectFormat());
    }

    private boolean isValidXAdESDataObjectFormat(Element dataObjectFormat, XAdESSignature signature, XAdESPath xadesPaths, Map<String, ReferenceValidationStatus> referenceStatusMap) {
        Element signatureElement = signature.getSignatureElement();
        if (this.getNumberOfOccurrences(dataObjectFormat, xadesPaths.getCurrentDescription()) != 1 && this.getNumberOfOccurrences(dataObjectFormat, xadesPaths.getCurrentObjectIdentifier()) != 1 && this.getNumberOfOccurrences(dataObjectFormat, xadesPaths.getCurrentMimeType()) != 1) {
            LOG.warn("At least one of the following elements: Description, ObjectIdentifier and MimeType shall be present within DataObjectFormat element for XAdES signature!");
            return false;
        }
        String objectReference = dataObjectFormat.getAttribute(XAdES132Attribute.OBJECT_REFERENCE.getAttributeName());
        if (Utils.isStringEmpty((String)objectReference)) {
            LOG.warn("DataObjectFormat's ObjectReference attribute shall be present for XAdES signature (cardinality == 1)!");
            return false;
        }
        if (!DomUtils.isElementReference((String)objectReference)) {
            LOG.warn("DataObjectFormat's ObjectReference attribute shall refer to an element within the document!");
            return false;
        }
        String id = DomUtils.getId((String)objectReference);
        ReferenceValidation matchingReference = this.getMatchingReference(id, referenceStatusMap);
        if (matchingReference == null) {
            LOG.warn("DataObjectFormat's ObjectReference attribute shall refer to a signed data object within the document!");
            return false;
        }
        return this.isDataObjectFormatValuesCompliant(dataObjectFormat, matchingReference, signatureElement, xadesPaths);
    }

    private ReferenceValidation getMatchingReference(String id, Map<String, ReferenceValidationStatus> referenceStatusMap) {
        ReferenceValidationStatus referenceValidationStatus = referenceStatusMap.get(id);
        if (referenceValidationStatus != null) {
            referenceValidationStatus.setDataObjectFormatFound(true);
            return referenceValidationStatus.getReferenceValidation();
        }
        return null;
    }

    private boolean isDataObjectFormatValuesCompliant(Element dataObjectFormat, ReferenceValidation reference, Element signatureElement, XAdESPath xadesPaths) {
        if (DomUtils.isElementReference((String)reference.getUri())) {
            String objectEncoding;
            Element object;
            String objectMimeType;
            Element object2;
            Element dataObjectFormatMimeType = DomUtils.getElement((Node)dataObjectFormat, (String)xadesPaths.getCurrentMimeType());
            if (dataObjectFormatMimeType != null && (object2 = DSSXMLUtils.getObjectById(signatureElement, reference.getUri())) != null && Utils.isStringNotEmpty((String)(objectMimeType = object2.getAttribute(XMLDSigAttribute.MIME_TYPE.getAttributeName()))) && !objectMimeType.equals(dataObjectFormatMimeType.getTextContent())) {
                LOG.warn("DataObjectFormat's MimeType attribute shall have the same value as the corresponding signed ds:Object element, when present!");
                return false;
            }
            Element dataObjectFormatEncoding = DomUtils.getElement((Node)dataObjectFormat, (String)xadesPaths.getCurrentEncoding());
            if (dataObjectFormatEncoding != null && (object = DSSXMLUtils.getObjectById(signatureElement, reference.getUri())) != null && Utils.isStringNotEmpty((String)(objectEncoding = object.getAttribute(XMLDSigAttribute.ENCODING.getAttributeName()))) && !objectEncoding.equals(dataObjectFormatEncoding.getTextContent())) {
                LOG.warn("DataObjectFormat's Encoding attribute shall have the same value as the corresponding signed ds:Object element, when present!");
                return false;
            }
        }
        return true;
    }

    private boolean isValidXAdESBaselineDataObjectFormat(Element dataObjectFormat, XAdESSignature signature, XAdESPath xadesPaths, Map<String, ReferenceValidationStatus> referenceStatusMap) {
        if (!this.isValidXAdESDataObjectFormat(dataObjectFormat, signature, xadesPaths, referenceStatusMap)) {
            return false;
        }
        if (this.getNumberOfOccurrences(dataObjectFormat, xadesPaths.getCurrentDescription()) > 1) {
            LOG.warn("Only one DataObjectFormat/Description may be present for XAdES-BASELINE-B signature (cardinality 0 or 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(dataObjectFormat, xadesPaths.getCurrentObjectIdentifier()) > 1) {
            LOG.warn("Only one DataObjectFormat/ObjectIdentifier may be present for XAdES-BASELINE-B signature (cardinality 0 or 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(dataObjectFormat, xadesPaths.getCurrentMimeType()) != 1) {
            LOG.warn("DataObjectFormat/MimeType shall be present for XAdES-BASELINE-B signature (cardinality == 1)!");
            return false;
        }
        if (this.getNumberOfOccurrences(dataObjectFormat, xadesPaths.getCurrentEncoding()) > 1) {
            LOG.warn("Only one DataObjectFormat/Encoding may be present for XAdES-BASELINE-B signature (cardinality 0 or 1)!");
            return false;
        }
        return true;
    }

    private boolean isSigningCertificateSignedInKeyInfo() {
        CertificateToken signingCertificate = ((XAdESSignature)this.signature).getSigningCertificateToken();
        if (signingCertificate != null && XAdESSignatureUtils.isKeyInfoCovered((XAdESSignature)this.signature)) {
            XAdESCertificateSource certificateSource = (XAdESCertificateSource)((XAdESSignature)this.signature).getCertificateSource();
            List keyInfoCertificates = certificateSource.getKeyInfoCertificates();
            for (CertificateToken keyInfoCertificate : keyInfoCertificates) {
                if (!signingCertificate.equals((Object)keyInfoCertificate)) continue;
                return true;
            }
        }
        return false;
    }

    private int getNumberOfOccurrences(Element element, String xPath) {
        if (element != null && Utils.isStringNotEmpty((String)xPath)) {
            return DomUtils.getNodesAmount((Node)element, (String)xPath);
        }
        return 0;
    }

    private boolean isElementPresent(Node xmlNode, String xPathString) {
        if (Utils.isStringEmpty((String)xPathString)) {
            return false;
        }
        return DomUtils.isNotEmpty((Node)xmlNode, (String)xPathString);
    }

    private Map<String, ReferenceValidationStatus> getReferenceValidationStatusMap() {
        if (this.statusMap == null) {
            this.statusMap = new HashMap<String, ReferenceValidationStatus>();
            for (ReferenceValidation referenceValidation : ((XAdESSignature)this.signature).getReferenceValidations()) {
                this.statusMap.put(referenceValidation.getId(), new ReferenceValidationStatus(referenceValidation));
                if (!Utils.isCollectionNotEmpty((Collection)referenceValidation.getDependentValidations())) continue;
                for (ReferenceValidation dependentReference : referenceValidation.getDependentValidations()) {
                    this.statusMap.put(dependentReference.getId(), new ReferenceValidationStatus(dependentReference, true));
                }
            }
        }
        return this.statusMap;
    }

    private static final class ReferenceValidationStatus {
        private final ReferenceValidation referenceValidation;
        private boolean dataObjectFormatFound;

        private ReferenceValidationStatus(ReferenceValidation referenceValidation) {
            this(referenceValidation, false);
        }

        private ReferenceValidationStatus(ReferenceValidation referenceValidation, boolean manifestEntry) {
            this.referenceValidation = referenceValidation;
            this.dataObjectFormatFound = manifestEntry;
        }

        public ReferenceValidation getReferenceValidation() {
            return this.referenceValidation;
        }

        public boolean isDataObjectFormatFound() {
            return this.dataObjectFormatFound;
        }

        public void setDataObjectFormatFound(boolean dataObjectFormatFound) {
            this.dataObjectFormatFound = dataObjectFormatFound;
        }
    }
}

