/*
 * Decompiled with CFR 0.152.
 */
package eu.evops.maven.plugins.cucumber.parallel;

import cucumber.api.cli.Main;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.logging.SystemStreamLog;

public class ProcessInThread
extends Thread {
    private Log log = new SystemStreamLog();
    private List<String> command;
    private Properties properties;
    private List<String> classpath;
    private int threadTimeout;
    private int status;
    private File stdout;
    private File stderr;
    private String jvmArgs;
    private HashMap<String, String> environmentVariables;
    private String workingDirectory;
    private Consumer<ProcessInThread> finishCallback;

    ProcessInThread(List<String> arguments, String jvmArgs, List<String> classpath, Properties properties, HashMap<String, String> environmentVariables, String workingDirectory, int threadTimeout) {
        this.jvmArgs = jvmArgs;
        this.environmentVariables = environmentVariables;
        this.workingDirectory = workingDirectory;
        this.command = arguments;
        this.properties = properties;
        this.classpath = classpath;
        this.threadTimeout = threadTimeout;
        this.status = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String className = Main.class.getCanonicalName();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.classpath.size(); ++i) {
            if (i != 0) {
                stringBuilder.append(File.pathSeparator);
            }
            stringBuilder.append(this.classpath.get(i));
        }
        String classpathString = stringBuilder.toString();
        ProcessBuilder builder = new ProcessBuilder(javaBin);
        builder.directory(new File(this.workingDirectory));
        builder.environment().putAll(this.environmentVariables);
        if (!this.jvmArgs.equalsIgnoreCase("")) {
            for (String jvmArg : this.jvmArgs.split("\\s+")) {
                builder.command().add(jvmArg);
            }
        }
        builder.command().add("-cp");
        builder.command().add(classpathString);
        Properties properties = this.properties;
        properties.putAll((Map<?, ?>)System.getProperties());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey().toString().startsWith("java.")) continue;
            builder.command().add(String.format("-D%s=%s", entry.getKey(), entry.getValue()));
        }
        builder.command().add(className);
        for (String argument : this.command) {
            builder.command().add(argument);
        }
        if (this.stderr != null) {
            builder.redirectError(this.stderr);
        }
        if (this.stdout != null) {
            builder.redirectOutput(this.stdout);
        }
        this.log.debug((CharSequence)String.format("Running command: %s", builder.command()));
        try {
            Process process = builder.start();
            if (process.waitFor(this.threadTimeout, TimeUnit.MINUTES)) {
                this.status = process.exitValue();
            } else {
                this.log.error((CharSequence)"Cucumber process timed out, terminating...");
                process.destroy();
                this.status = 2;
            }
        }
        catch (IOException | InterruptedException e) {
            this.log.error((CharSequence)"Error running thread");
            this.status = 1;
        }
        finally {
            if (this.finishCallback != null) {
                this.finishCallback.accept(this);
            }
        }
    }

    void onFinish(Consumer<ProcessInThread> predicate) {
        this.finishCallback = predicate;
    }

    public int getStatus() {
        return this.status;
    }

    void setStdout(File stdout) {
        this.stdout = stdout;
    }

    void setStderr(File stderr) {
        this.stderr = stderr;
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

