/*
 * Decompiled with CFR 0.152.
 */
package eu.evops.maven.plugins.cucumber.parallel.reporting;

import eu.evops.maven.plugins.cucumber.parallel.reporting.MergeException;
import eu.evops.maven.plugins.cucumber.parallel.reporting.ResultMerger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.codehaus.plexus.util.FileUtils;
import org.json.JSONArray;
import org.json.JSONException;

public class JsonResultMerger
implements ResultMerger {
    private String outputFileName;

    public JsonResultMerger(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    @Override
    public File merge(File outputFolder, List<String> paths) throws MergeException {
        File outputFile = new File(outputFolder, this.outputFileName);
        JSONArray combined = new JSONArray();
        String contents = "";
        for (String jsonFile : paths) {
            try {
                contents = FileUtils.fileRead((String)jsonFile);
                JSONArray threadReport = new JSONArray(contents);
                for (int i = 0; i < threadReport.length(); ++i) {
                    String suiteId = threadReport.getJSONObject(i).getString("id");
                    boolean matchFound = false;
                    for (int j = 0; j < combined.length(); ++j) {
                        if (!combined.getJSONObject(j).getString("id").equals(suiteId)) continue;
                        matchFound = true;
                        JSONArray combinedElements = combined.getJSONObject(j).getJSONArray("elements");
                        JSONArray elements = threadReport.getJSONObject(i).getJSONArray("elements");
                        for (int k = 0; k < elements.length(); ++k) {
                            combinedElements.put(elements.get(k));
                        }
                    }
                    if (matchFound) continue;
                    combined.put(threadReport.get(i));
                }
                Files.write(Paths.get(outputFile.getAbsolutePath(), new String[0]), combined.toString(2).getBytes(), StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                throw new MergeException("Could not write to combined json report file", e);
            }
            catch (JSONException e) {
                System.out.println(String.format("Ignoring the report.json file [%s] due to json parsing issue", jsonFile));
                System.out.println(String.format("Ignored Report Content: \n [%s]", contents));
            }
        }
        return outputFile;
    }
}

