/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.util.Preconditions;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.util.StringUtils;

public class FeatureRebaseCommand
extends AbstractGitFlowCommand<Void> {
    private static final String SHORT_NAME = "feature-rebase";
    private final String branchName;

    public FeatureRebaseCommand(String name, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(git, gfConfig, reporter);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)name));
        this.branchName = gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.FEATURE.configKey()) + name;
    }

    @Override
    public FeatureRebaseCommand setAllowUntracked(boolean allow) {
        super.setAllowUntracked(allow);
        return this;
    }

    @Override
    public FeatureRebaseCommand setScmMessagePrefix(String scmMessagePrefix) {
        super.setScmMessagePrefix(scmMessagePrefix);
        return this;
    }

    @Override
    public FeatureRebaseCommand setScmMessageSuffix(String scmMessageSuffix) {
        super.setScmMessageSuffix(scmMessageSuffix);
        return this;
    }

    @Override
    public Void call() throws NotInitializedException, JGitFlowGitAPIException, DirtyWorkingTreeException, JGitFlowIOException, LocalBranchMissingException {
        this.requireGitFlowInitialized();
        this.requireCleanWorkingTree();
        this.requireLocalBranchExists(this.branchName);
        try {
            this.git.checkout().setName(this.branchName).call();
            this.git.rebase().call();
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        return null;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

