/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.exception.RemoteBranchExistsException;
import com.atlassian.jgitflow.core.util.Preconditions;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.StringUtils;

public class HotfixPublishCommand
extends AbstractGitFlowCommand<Void> {
    private static final String SHORT_NAME = "hotfix-publish";
    private final String branchName;

    public HotfixPublishCommand(String name, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(git, gfConfig, reporter);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)name));
        this.branchName = name;
    }

    @Override
    public Void call() throws NotInitializedException, JGitFlowGitAPIException, DirtyWorkingTreeException, JGitFlowIOException, LocalBranchMissingException, RemoteBranchExistsException {
        this.requireGitFlowInitialized();
        String prefixedBranchName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.HOTFIX.configKey()) + this.branchName;
        this.requireCleanWorkingTree();
        this.requireLocalBranchExists(prefixedBranchName);
        try {
            this.git.fetch().setRemote("origin").call();
            this.requireRemoteBranchAbsent(prefixedBranchName);
            RefSpec branchSpec = new RefSpec(prefixedBranchName + ":" + "refs/heads/" + prefixedBranchName);
            this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
            this.git.fetch().setRemote("origin").call();
            StoredConfig config = this.git.getRepository().getConfig();
            config.setString("branch", prefixedBranchName, "remote", "origin");
            config.setString("branch", prefixedBranchName, "merge", "refs/heads/" + prefixedBranchName);
            config.save();
            this.git.checkout().setName(prefixedBranchName).call();
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        return null;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

