/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.HotfixBranchExistsException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchExistsException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.exception.NotInitializedException;
import com.atlassian.jgitflow.core.exception.RemoteBranchExistsException;
import com.atlassian.jgitflow.core.exception.TagExistsException;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.jgitflow.core.util.Preconditions;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.StringUtils;

public class HotfixStartCommand
extends AbstractGitFlowCommand<Ref> {
    private static final String SHORT_NAME = "hotfix-start";
    private final String hotfixName;
    private boolean fetch;
    private boolean push;
    private RevCommit startCommit;
    private String startCommitString;

    public HotfixStartCommand(String hotfixName, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(git, gfConfig, reporter);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)hotfixName));
        this.hotfixName = hotfixName;
        this.fetch = false;
        this.push = false;
    }

    @Override
    public HotfixStartCommand setAllowUntracked(boolean allow) {
        super.setAllowUntracked(allow);
        return this;
    }

    @Override
    public HotfixStartCommand setScmMessagePrefix(String scmMessagePrefix) {
        super.setScmMessagePrefix(scmMessagePrefix);
        return this;
    }

    @Override
    public HotfixStartCommand setScmMessageSuffix(String scmMessageSuffix) {
        super.setScmMessageSuffix(scmMessageSuffix);
        return this;
    }

    @Override
    public Ref call() throws NotInitializedException, JGitFlowGitAPIException, HotfixBranchExistsException, DirtyWorkingTreeException, JGitFlowIOException, LocalBranchExistsException, TagExistsException, BranchOutOfDateException, LocalBranchMissingException, RemoteBranchExistsException {
        String prefixedHotfixName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.HOTFIX.configKey()) + this.hotfixName;
        this.requireGitFlowInitialized();
        this.requireNoExistingHotfixBranches();
        this.requireCleanWorkingTree();
        this.requireLocalBranchAbsent(prefixedHotfixName);
        try {
            if (this.fetch) {
                RefSpec spec = new RefSpec("+refs/heads/" + this.gfConfig.getMaster() + ":" + "refs/remotes/" + "origin/" + this.gfConfig.getMaster());
                this.git.fetch().setRefSpecs(new RefSpec[]{spec}).call();
            }
            this.requireTagAbsent(this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.VERSIONTAG.configKey()) + this.hotfixName);
            if (GitHelper.remoteBranchExists(this.git, this.gfConfig.getMaster(), this.reporter)) {
                this.requireLocalBranchNotBehindRemote(this.gfConfig.getMaster());
            }
            RevCommit startPoint = null;
            startPoint = null != this.startCommit ? this.startCommit : (!StringUtils.isEmptyOrNull((String)this.startCommitString) ? GitHelper.getCommitForString(this.git, this.startCommitString) : GitHelper.getLatestCommit(this.git, this.gfConfig.getMaster()));
            this.requireCommitOnBranch(startPoint, this.gfConfig.getMaster());
            Ref newBranch = this.git.checkout().setName(prefixedHotfixName).setCreateBranch(true).setStartPoint(startPoint).call();
            if (this.push) {
                this.requireRemoteBranchAbsent(prefixedHotfixName);
                RefSpec branchSpec = new RefSpec(prefixedHotfixName + ":" + "refs/heads/" + prefixedHotfixName);
                this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
                this.git.fetch().setRemote("origin").call();
                StoredConfig config = this.git.getRepository().getConfig();
                config.setString("branch", prefixedHotfixName, "remote", "origin");
                config.setString("branch", prefixedHotfixName, "merge", "refs/heads/" + prefixedHotfixName);
                config.save();
            }
            return newBranch;
        }
        catch (GitAPIException e) {
            throw new JGitFlowGitAPIException(e);
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
    }

    public HotfixStartCommand setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public HotfixStartCommand setStartCommit(String commitId) {
        this.startCommitString = commitId;
        return this;
    }

    public HotfixStartCommand setStartCommit(RevCommit commit) {
        this.startCommit = commit;
        return this;
    }

    public HotfixStartCommand setPush(boolean push) {
        this.push = push;
        return this;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

