/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.FeatureFinishCommand;
import com.atlassian.jgitflow.core.FeaturePublishCommand;
import com.atlassian.jgitflow.core.FeatureStartCommand;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.HotfixFinishCommand;
import com.atlassian.jgitflow.core.HotfixPublishCommand;
import com.atlassian.jgitflow.core.HotfixStartCommand;
import com.atlassian.jgitflow.core.InitContext;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowInitCommand;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.ReleaseFinishCommand;
import com.atlassian.jgitflow.core.ReleasePublishCommand;
import com.atlassian.jgitflow.core.ReleaseStartCommand;
import com.atlassian.jgitflow.core.exception.AlreadyInitializedException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.SameBranchException;
import java.io.File;
import java.io.IOException;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.RepositoryBuilder;

public class JGitFlow {
    private Git git;
    private GitFlowConfiguration gfConfig;
    private JGitFlowReporter reporter;

    private JGitFlow() {
    }

    JGitFlow(Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        this.git = git;
        this.gfConfig = gfConfig;
        this.reporter = reporter;
        this.reporter.setGitFlowConfiguration(git, gfConfig);
    }

    public static JGitFlow init(File projectDir) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        JGitFlowInitCommand initCommand = new JGitFlowInitCommand();
        return initCommand.setDirectory(projectDir).call();
    }

    public static JGitFlow init(File projectDir, String defaultOriginUrl) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        JGitFlowInitCommand initCommand = new JGitFlowInitCommand();
        return initCommand.setDirectory(projectDir).setDefaultOriginUrl(defaultOriginUrl).call();
    }

    public static JGitFlow init(File projectDir, InitContext context) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        JGitFlowInitCommand initCommand = new JGitFlowInitCommand();
        return initCommand.setDirectory(projectDir).setInitContext(context).call();
    }

    public static JGitFlow init(File projectDir, InitContext context, String defaultOriginUrl) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        JGitFlowInitCommand initCommand = new JGitFlowInitCommand();
        return initCommand.setDirectory(projectDir).setDefaultOriginUrl(defaultOriginUrl).setInitContext(context).call();
    }

    public static JGitFlow forceInit(File projectDir) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        JGitFlowInitCommand initCommand = new JGitFlowInitCommand();
        return initCommand.setDirectory(projectDir).setForce(true).call();
    }

    public static JGitFlow forceInit(File projectDir, String defaultOriginUrl) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        JGitFlowInitCommand initCommand = new JGitFlowInitCommand();
        return initCommand.setDirectory(projectDir).setDefaultOriginUrl(defaultOriginUrl).setForce(true).call();
    }

    public static JGitFlow forceInit(File projectDir, InitContext context) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        JGitFlowInitCommand initCommand = new JGitFlowInitCommand();
        return initCommand.setDirectory(projectDir).setForce(true).setInitContext(context).call();
    }

    public static JGitFlow forceInit(File projectDir, InitContext context, String defaultOriginUrl) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        JGitFlowInitCommand initCommand = new JGitFlowInitCommand();
        return initCommand.setDirectory(projectDir).setDefaultOriginUrl(defaultOriginUrl).setForce(true).setInitContext(context).call();
    }

    public static JGitFlow get(File projectDir) throws JGitFlowIOException {
        try {
            RepositoryBuilder rb = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().readEnvironment()).findGitDir(projectDir);
            File gitDir = rb.getGitDir();
            Git gitRepo = Git.open((File)gitDir);
            GitFlowConfiguration gfConfig = new GitFlowConfiguration(gitRepo);
            return new JGitFlow(gitRepo, gfConfig, new JGitFlowReporter());
        }
        catch (IOException e) {
            throw new JGitFlowIOException(e);
        }
    }

    public static JGitFlow getOrInit(File projectDir) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        if (JGitFlow.isInitialized(projectDir)) {
            return JGitFlow.get(projectDir);
        }
        return JGitFlow.init(projectDir);
    }

    public static JGitFlow getOrInit(File projectDir, String defaultOriginUrl) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        if (JGitFlow.isInitialized(projectDir)) {
            return JGitFlow.get(projectDir);
        }
        return JGitFlow.init(projectDir, defaultOriginUrl);
    }

    public static JGitFlow getOrInit(File projectDir, InitContext ctx) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        if (JGitFlow.isInitialized(projectDir)) {
            return JGitFlow.get(projectDir);
        }
        return JGitFlow.init(projectDir, ctx);
    }

    public static JGitFlow getOrInit(File projectDir, InitContext ctx, String defaultOriginUrl) throws JGitFlowIOException, AlreadyInitializedException, SameBranchException, JGitFlowGitAPIException {
        if (JGitFlow.isInitialized(projectDir)) {
            return JGitFlow.get(projectDir);
        }
        return JGitFlow.init(projectDir, ctx, defaultOriginUrl);
    }

    public static boolean isInitialized(File dir) {
        boolean inited = false;
        try {
            RepositoryBuilder rb = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().readEnvironment()).findGitDir(dir);
            File gitDir = rb.getGitDir();
            if (gitDir != null) {
                Git gitRepo = Git.open((File)gitDir);
                GitFlowConfiguration gfConfig = new GitFlowConfiguration(gitRepo);
                inited = gfConfig.gitFlowIsInitialized();
            }
        }
        catch (IOException e) {
        }
        catch (JGitFlowGitAPIException jGitFlowGitAPIException) {
            // empty catch block
        }
        return inited;
    }

    public boolean isInitialized() {
        boolean inited = false;
        try {
            inited = this.gfConfig.gitFlowIsInitialized();
        }
        catch (JGitFlowGitAPIException jGitFlowGitAPIException) {
            // empty catch block
        }
        return inited;
    }

    public FeatureStartCommand featureStart(String name) {
        return new FeatureStartCommand(name, this.git, this.gfConfig, this.reporter);
    }

    public FeatureFinishCommand featureFinish(String name) {
        return new FeatureFinishCommand(name, this.git, this.gfConfig, this.reporter);
    }

    public FeaturePublishCommand featurePublish(String name) {
        return new FeaturePublishCommand(name, this.git, this.gfConfig, this.reporter);
    }

    public ReleaseStartCommand releaseStart(String name) {
        return new ReleaseStartCommand(name, this.git, this.gfConfig, this.reporter);
    }

    public ReleaseFinishCommand releaseFinish(String name) {
        return new ReleaseFinishCommand(name, this.git, this.gfConfig, this.reporter);
    }

    public ReleasePublishCommand releasePublish(String name) {
        return new ReleasePublishCommand(name, this.git, this.gfConfig, this.reporter);
    }

    public HotfixStartCommand hotfixStart(String name) {
        return new HotfixStartCommand(name, this.git, this.gfConfig, this.reporter);
    }

    public HotfixFinishCommand hotfixFinish(String name) {
        return new HotfixFinishCommand(name, this.git, this.gfConfig, this.reporter);
    }

    public HotfixPublishCommand hotfixPublish(String name) {
        return new HotfixPublishCommand(name, this.git, this.gfConfig, this.reporter);
    }

    public Git git() {
        return this.git;
    }

    public String getMasterBranchName() {
        return this.gfConfig.getMaster();
    }

    public String getDevelopBranchName() {
        return this.gfConfig.getDevelop();
    }

    public String getFeatureBranchPrefix() {
        return this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.FEATURE.configKey());
    }

    public String getReleaseBranchPrefix() {
        return this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.RELEASE.configKey());
    }

    public String getHotfixBranchPrefix() {
        return this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.HOTFIX.configKey());
    }

    public String getSupportBranchPrefix() {
        return this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.SUPPORT.configKey());
    }

    public String getVersionTagPrefix() {
        return this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.VERSIONTAG.configKey());
    }

    public JGitFlowReporter getReporter() {
        return this.reporter;
    }
}

