/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.InitContext;
import com.atlassian.jgitflow.core.JGitFlow;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.exception.AlreadyInitializedException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.SameBranchException;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryBuilder;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

public class JGitFlowInitCommand
implements Callable<JGitFlow> {
    private static final String SHORT_NAME = "init";
    private File directory;
    private boolean force = false;
    private InitContext context;
    JGitFlowReporter reporter = new JGitFlowReporter();
    private String defaultOriginUrl;

    @Override
    public JGitFlow call() throws JGitFlowIOException, JGitFlowGitAPIException, AlreadyInitializedException, SameBranchException {
        Git git = null;
        this.reporter.debugCommandCall(SHORT_NAME);
        if (null == this.context) {
            this.context = new InitContext();
        }
        try {
            git = this.getOrInitGit(this.directory);
        }
        catch (IOException e) {
            this.reporter.errorText(SHORT_NAME, e.getMessage());
            this.reporter.endCommand();
            throw new JGitFlowIOException(e);
        }
        catch (GitAPIException e) {
            this.reporter.errorText(SHORT_NAME, e.getMessage());
            this.reporter.endCommand();
            throw new JGitFlowGitAPIException(e);
        }
        Repository repo = git.getRepository();
        GitFlowConfiguration gfConfig = new GitFlowConfiguration(git);
        RevWalk walk = null;
        try {
            StoredConfig gitConfig;
            String originUrl;
            if (!Strings.isNullOrEmpty((String)this.defaultOriginUrl) && Strings.isNullOrEmpty((String)(originUrl = (gitConfig = git.getRepository().getConfig()).getString("remote", "origin", "url")))) {
                String newOriginUrl = this.defaultOriginUrl;
                if (this.defaultOriginUrl.startsWith("file://")) {
                    File originFile = new File(this.defaultOriginUrl.substring(7));
                    newOriginUrl = "file://" + originFile.getCanonicalPath();
                }
                gitConfig.setString("remote", "origin", "url", newOriginUrl);
                gitConfig.setString("remote", "origin", "fetch", "+refs/heads/*:refs/remotes/origin/*");
                gitConfig.save();
                gitConfig.load();
                git.fetch().setRemote("origin").call();
            }
            if (!this.force && gfConfig.gitFlowIsInitialized()) {
                this.reporter.errorText(SHORT_NAME, "git flow is already initialized and force flag is false");
                this.reporter.endCommand();
                throw new AlreadyInitializedException("Already initialized for git flow.");
            }
            if (gfConfig.hasMasterConfigured() && !this.force) {
                this.context.setMaster(gfConfig.getMaster());
            }
            if (!GitHelper.localBranchExists(git, this.context.getMaster()) && GitHelper.remoteBranchExists(git, this.context.getMaster(), this.reporter)) {
                this.reporter.debugText(SHORT_NAME, "creating new local '" + this.context.getMaster() + "' branch from origin '" + this.context.getMaster() + "'");
                git.branchCreate().setName(this.context.getMaster()).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint("origin/" + this.context.getMaster()).call();
            }
            gfConfig.setMaster(this.context.getMaster());
            if (gfConfig.hasDevelopConfigured() && !this.force) {
                this.context.setDevelop(gfConfig.getDevelop());
            }
            if (this.context.getDevelop().equals(this.context.getMaster())) {
                this.reporter.errorText(SHORT_NAME, "master and develop branches configured with the same name: [" + this.context.getMaster() + "]");
                this.reporter.endCommand();
                throw new SameBranchException("master and develop branches cannot be the same: [" + this.context.getMaster() + "]");
            }
            gfConfig.setDevelop(this.context.getDevelop());
            walk = new RevWalk(repo);
            ObjectId masterBranch = repo.resolve("refs/heads/" + this.context.getMaster());
            RevCommit masterCommit = null;
            if (null != masterBranch) {
                try {
                    masterCommit = walk.parseCommit((AnyObjectId)masterBranch);
                }
                catch (MissingObjectException e) {
                }
                catch (IncorrectObjectTypeException e) {
                    // empty catch block
                }
            }
            if (null == masterCommit) {
                this.reporter.debugText(SHORT_NAME, "no commits found on '" + this.context.getMaster() + "'. creating initial commit.");
                RefUpdate refUpdate = repo.getRefDatabase().newUpdate("HEAD", false);
                refUpdate.setForceUpdate(true);
                refUpdate.link("refs/heads/" + this.context.getMaster());
                git.commit().setMessage("Initial Commit").call();
            }
            if (!GitHelper.localBranchExists(git, this.context.getDevelop())) {
                if (GitHelper.remoteBranchExists(git, this.context.getDevelop(), this.reporter)) {
                    this.reporter.debugText(SHORT_NAME, "creating new local '" + this.context.getDevelop() + "' branch from origin '" + this.context.getDevelop() + "'");
                    git.branchCreate().setName(this.context.getDevelop()).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM).setStartPoint("origin/" + this.context.getDevelop()).call();
                } else {
                    this.reporter.debugText(SHORT_NAME, "creating new local '" + this.context.getDevelop() + "' branch without origin");
                    git.branchCreate().setName(this.context.getDevelop()).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.NOTRACK).call();
                }
            }
            for (String prefixName : gfConfig.getPrefixNames()) {
                if (gfConfig.hasPrefixConfigured(prefixName) && !this.force) {
                    this.context.setPrefix(prefixName, gfConfig.getPrefixValue(prefixName));
                }
                gfConfig.setPrefix(prefixName, this.context.getPrefix(prefixName));
            }
        }
        catch (IOException e) {
            this.reporter.errorText(SHORT_NAME, e.getMessage());
            this.reporter.flush();
            throw new JGitFlowIOException(e);
        }
        catch (GitAPIException e) {
            this.reporter.errorText(SHORT_NAME, e.getMessage());
            this.reporter.flush();
            throw new JGitFlowGitAPIException(e);
        }
        catch (ConfigInvalidException e) {
            this.reporter.errorText(SHORT_NAME, e.getMessage());
            this.reporter.flush();
            throw new JGitFlowGitAPIException(e);
        }
        finally {
            if (null != walk) {
                walk.release();
            }
            this.reporter.endCommand();
        }
        return new JGitFlow(git, gfConfig, this.reporter);
    }

    public JGitFlowInitCommand setDirectory(File directory) {
        this.directory = directory;
        return this;
    }

    public JGitFlowInitCommand setInitContext(InitContext context) {
        this.context = context;
        return this;
    }

    public JGitFlowInitCommand setForce(boolean force) {
        this.force = force;
        return this;
    }

    public JGitFlowInitCommand setDefaultOriginUrl(String defaultOriginUrl) {
        this.defaultOriginUrl = defaultOriginUrl;
        return this;
    }

    private Git getOrInitGit(File folder) throws IOException, GitAPIException {
        Git gitRepo;
        this.reporter.debugMethod(SHORT_NAME, "getOrInitGit");
        try {
            this.reporter.debugText(SHORT_NAME, "looking for git folder in " + folder.getAbsolutePath());
            RepositoryBuilder rb = (RepositoryBuilder)((RepositoryBuilder)new RepositoryBuilder().readEnvironment()).findGitDir(folder);
            File gitDir = rb.getGitDir();
            if (null != gitDir) {
                this.reporter.debugText(SHORT_NAME, "found existing git folder");
                gitRepo = Git.open((File)gitDir);
            } else {
                this.reporter.debugText(SHORT_NAME, "no git folder found, initializing");
                gitRepo = Git.init().setDirectory(folder).call();
            }
        }
        catch (RepositoryNotFoundException e) {
            this.reporter.debugText(SHORT_NAME, "no git folder found, initializing");
            gitRepo = Git.init().setDirectory(folder).call();
        }
        this.reporter.endMethod();
        return gitRepo;
    }
}

