/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jgitflow.core;

import com.atlassian.jgitflow.core.AbstractGitFlowCommand;
import com.atlassian.jgitflow.core.GitFlowConfiguration;
import com.atlassian.jgitflow.core.JGitFlowConstants;
import com.atlassian.jgitflow.core.JGitFlowReporter;
import com.atlassian.jgitflow.core.ReleaseMergeResult;
import com.atlassian.jgitflow.core.exception.BranchOutOfDateException;
import com.atlassian.jgitflow.core.exception.DirtyWorkingTreeException;
import com.atlassian.jgitflow.core.exception.JGitFlowGitAPIException;
import com.atlassian.jgitflow.core.exception.JGitFlowIOException;
import com.atlassian.jgitflow.core.exception.LocalBranchMissingException;
import com.atlassian.jgitflow.core.util.GitHelper;
import com.atlassian.jgitflow.core.util.Preconditions;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.MergeResult;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.util.StringUtils;

public class ReleaseFinishCommand
extends AbstractGitFlowCommand<ReleaseMergeResult> {
    private static final String SHORT_NAME = "release-finish";
    private final String releaseName;
    private boolean fetch;
    private String message;
    private boolean push;
    private boolean keepBranch;
    private boolean noTag;
    private boolean squash;
    private boolean noMerge;

    public ReleaseFinishCommand(String releaseName, Git git, GitFlowConfiguration gfConfig, JGitFlowReporter reporter) {
        super(git, gfConfig, reporter);
        Preconditions.checkState(!StringUtils.isEmptyOrNull((String)releaseName));
        this.releaseName = releaseName;
        this.fetch = false;
        this.message = "tagging release " + releaseName;
        this.push = false;
        this.keepBranch = false;
        this.noTag = false;
        this.squash = false;
        this.noMerge = false;
    }

    @Override
    public ReleaseFinishCommand setAllowUntracked(boolean allow) {
        super.setAllowUntracked(allow);
        return this;
    }

    @Override
    public ReleaseFinishCommand setScmMessagePrefix(String scmMessagePrefix) {
        super.setScmMessagePrefix(scmMessagePrefix);
        return this;
    }

    @Override
    public ReleaseFinishCommand setScmMessageSuffix(String scmMessageSuffix) {
        super.setScmMessageSuffix(scmMessageSuffix);
        return this;
    }

    @Override
    public ReleaseMergeResult call() throws JGitFlowGitAPIException, LocalBranchMissingException, DirtyWorkingTreeException, JGitFlowIOException, BranchOutOfDateException {
        this.reporter.commandCall(this.getCommandName());
        String prefixedReleaseName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.RELEASE.configKey()) + this.releaseName;
        this.requireLocalBranchExists(prefixedReleaseName);
        this.requireCleanWorkingTree();
        MergeResult developResult = new MergeResult(null, null, new ObjectId[]{null, null}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, (MergeStrategy)MergeStrategy.RESOLVE, null);
        MergeResult masterResult = new MergeResult(null, null, new ObjectId[]{null, null}, MergeResult.MergeStatus.ALREADY_UP_TO_DATE, (MergeStrategy)MergeStrategy.RESOLVE, null);
        try {
            if (this.fetch) {
                RefSpec developSpec = new RefSpec("+refs/heads/" + this.gfConfig.getDevelop() + ":" + "refs/remotes/" + "origin/" + this.gfConfig.getDevelop());
                RefSpec masterSpec = new RefSpec("+refs/heads/" + this.gfConfig.getMaster() + ":" + "refs/remotes/" + "origin/" + this.gfConfig.getMaster());
                this.git.fetch().setRemote("origin").setRefSpecs(new RefSpec[]{masterSpec}).call();
                this.git.fetch().setRemote("origin").setRefSpecs(new RefSpec[]{developSpec}).call();
                this.git.fetch().setRemote("origin").call();
            }
            if (GitHelper.remoteBranchExists(this.git, prefixedReleaseName, this.reporter)) {
                this.requireLocalBranchNotBehindRemote(prefixedReleaseName);
            }
            if (GitHelper.remoteBranchExists(this.git, this.gfConfig.getMaster(), this.reporter)) {
                this.requireLocalBranchNotBehindRemote(this.gfConfig.getMaster());
            }
            if (GitHelper.remoteBranchExists(this.git, this.gfConfig.getDevelop(), this.reporter)) {
                this.requireLocalBranchNotBehindRemote(this.gfConfig.getDevelop());
            }
            Ref releaseBranch = GitHelper.getLocalBranch(this.git, prefixedReleaseName);
            if (!this.noMerge) {
                if (!GitHelper.isMergedInto(this.git, prefixedReleaseName, this.gfConfig.getMaster())) {
                    this.git.checkout().setName(this.gfConfig.getMaster()).call();
                    this.reporter.infoText(this.getCommandName(), "merging '" + prefixedReleaseName + "' into '" + this.gfConfig.getMaster() + "'...");
                    if (this.squash) {
                        this.reporter.infoText(this.getCommandName(), "squashing merge");
                        masterResult = this.git.merge().setSquash(true).include(releaseBranch).call();
                        if (masterResult.getMergeStatus().isSuccessful()) {
                            this.git.commit().setMessage(this.getScmMessagePrefix() + "squashing '" + prefixedReleaseName + "' into '" + this.gfConfig.getMaster() + "'" + this.getScmMessageSuffix()).call();
                        }
                    } else {
                        masterResult = this.git.merge().setFastForward(MergeCommand.FastForwardMode.NO_FF).include(releaseBranch).call();
                    }
                }
                this.reporter.mergeResult(this.getCommandName(), masterResult);
                if (!masterResult.getMergeStatus().isSuccessful()) {
                    this.reporter.errorText(this.getCommandName(), "merge into '" + this.gfConfig.getMaster() + "' was not successful! Aborting the release...");
                    if (masterResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.CONFLICTING)) {
                        this.reporter.errorText(this.getCommandName(), "please resolve your merge conflicts and re-run " + this.getCommandName());
                    } else {
                        this.reporter.errorText(this.getCommandName(), "until JGit supports merge resets, please run 'git reset --merge' to get back to a clean state");
                    }
                }
                if (!GitHelper.isMergedInto(this.git, prefixedReleaseName, this.gfConfig.getDevelop())) {
                    this.reporter.infoText(this.getCommandName(), "merging '" + prefixedReleaseName + "' into '" + this.gfConfig.getDevelop() + "'...");
                    this.git.checkout().setName(this.gfConfig.getDevelop()).call();
                    if (this.squash) {
                        this.reporter.infoText(this.getCommandName(), "squashing merge");
                        developResult = this.git.merge().setSquash(true).include(releaseBranch).call();
                        if (developResult.getMergeStatus().isSuccessful()) {
                            this.git.commit().setMessage(this.getScmMessagePrefix() + "squashing '" + prefixedReleaseName + "' into '" + this.gfConfig.getDevelop() + "'" + this.getScmMessageSuffix()).call();
                        }
                    } else {
                        developResult = this.git.merge().setFastForward(MergeCommand.FastForwardMode.NO_FF).include(releaseBranch).call();
                    }
                }
                this.reporter.mergeResult(this.getCommandName(), developResult);
                if (!developResult.getMergeStatus().isSuccessful()) {
                    this.reporter.errorText(this.getCommandName(), "merge into '" + this.gfConfig.getDevelop() + "' was not successful! Aborting the release...");
                    if (developResult.getMergeStatus().equals((Object)MergeResult.MergeStatus.CONFLICTING)) {
                        this.reporter.errorText(this.getCommandName(), "please resolve your merge conflicts and re-run " + this.getCommandName());
                    } else {
                        this.reporter.errorText(this.getCommandName(), "until JGit supports merge resets, please run 'git reset --merge' to get back to a clean state");
                    }
                }
            }
            if (!this.noTag && masterResult.getMergeStatus().isSuccessful() && developResult.getMergeStatus().isSuccessful()) {
                this.git.checkout().setName(releaseBranch.getName()).call();
                String tagName = this.gfConfig.getPrefixValue(JGitFlowConstants.PREFIXES.VERSIONTAG.configKey()) + this.releaseName;
                if (!GitHelper.tagExists(this.git, tagName)) {
                    this.reporter.infoText(this.getCommandName(), "tagging release with name:" + tagName);
                    this.git.tag().setName(tagName).setMessage(this.getScmMessagePrefix() + this.message + this.getScmMessageSuffix()).call();
                }
            }
            if (this.push && masterResult.getMergeStatus().isSuccessful() && developResult.getMergeStatus().isSuccessful()) {
                this.reporter.infoText(this.getCommandName(), "pushing changes to origin...");
                this.reporter.infoText(this.getCommandName(), "pushing '" + this.gfConfig.getDevelop() + "'");
                RefSpec developSpec = new RefSpec(this.gfConfig.getDevelop());
                this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{developSpec}).call();
                this.reporter.infoText(this.getCommandName(), "pushing '" + this.gfConfig.getMaster() + "'");
                RefSpec masterSpec = new RefSpec(this.gfConfig.getMaster());
                this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{masterSpec}).call();
                if (!this.noTag) {
                    this.reporter.infoText(this.getCommandName(), "pushing tags");
                    this.git.push().setRemote("origin").setPushTags().call();
                }
                if (GitHelper.remoteBranchExists(this.git, prefixedReleaseName, this.reporter)) {
                    this.reporter.infoText(this.getCommandName(), "pushing release branch");
                    RefSpec branchSpec = new RefSpec(prefixedReleaseName);
                    this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{branchSpec}).call();
                }
            }
            if (!this.keepBranch && masterResult.getMergeStatus().isSuccessful() && developResult.getMergeStatus().isSuccessful()) {
                this.reporter.infoText(this.getCommandName(), "deleting local release branch");
                this.git.checkout().setName(this.gfConfig.getDevelop()).call();
                this.git.branchDelete().setForce(true).setBranchNames(new String[]{prefixedReleaseName}).call();
                if (this.push && GitHelper.remoteBranchExists(this.git, prefixedReleaseName, this.reporter)) {
                    this.reporter.infoText(this.getCommandName(), "pushing deleted release branch");
                    RefSpec deleteSpec = new RefSpec(":refs/heads/" + prefixedReleaseName);
                    this.git.push().setRemote("origin").setRefSpecs(new RefSpec[]{deleteSpec}).call();
                }
            }
            this.reporter.infoText(this.getCommandName(), "checking out '" + this.gfConfig.getDevelop() + "'");
            this.git.checkout().setName(this.gfConfig.getDevelop()).call();
        }
        catch (GitAPIException e) {
            this.reporter.errorText(this.getCommandName(), e.getMessage());
            this.reporter.endCommand();
            throw new JGitFlowGitAPIException(e);
        }
        this.reporter.endCommand();
        return new ReleaseMergeResult(masterResult, developResult);
    }

    public ReleaseFinishCommand setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public ReleaseFinishCommand setMessage(String message) {
        this.message = message;
        return this;
    }

    public ReleaseFinishCommand setPush(boolean push) {
        this.push = push;
        return this;
    }

    public ReleaseFinishCommand setKeepBranch(boolean keepBranch) {
        this.keepBranch = keepBranch;
        return this;
    }

    public ReleaseFinishCommand setNoTag(boolean noTag) {
        this.noTag = noTag;
        return this;
    }

    public ReleaseFinishCommand setSquash(boolean squash) {
        this.squash = squash;
        return this;
    }

    public ReleaseFinishCommand setNoMerge(boolean noMerge) {
        this.noMerge = noMerge;
        return this;
    }

    @Override
    protected String getCommandName() {
        return SHORT_NAME;
    }
}

