/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.jgitflow.util;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.RemoteIdentityRepository;
import com.jcraft.jsch.agentproxy.USocketFactory;
import com.jcraft.jsch.agentproxy.connector.SSHAgentConnector;
import com.jcraft.jsch.agentproxy.usocket.JNAUSocketFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.FS;

public class SshCredentialsProvider
extends JschConfigSessionFactory {
    protected void configure(OpenSshConfig.Host hc, Session session) {
        session.setConfig("StrictHostKeyChecking", "no");
    }

    protected JSch createDefaultJSch(FS fs) throws JSchException {
        SSHAgentConnector con = null;
        JSch jsch = null;
        try {
            if (SSHAgentConnector.isConnectorAvailable()) {
                JNAUSocketFactory usf = new JNAUSocketFactory();
                con = new SSHAgentConnector((USocketFactory)usf);
            }
        }
        catch (AgentProxyException e) {
            System.out.println(e.getMessage());
        }
        if (null == con) {
            jsch = super.createDefaultJSch(fs);
            return jsch;
        }
        jsch = new JSch();
        JSch.setConfig((String)"PreferredAuthentications", (String)"publickey");
        RemoteIdentityRepository irepo = new RemoteIdentityRepository((Connector)con);
        jsch.setIdentityRepository((IdentityRepository)irepo);
        this.knownHosts(jsch, fs);
        this.identities(jsch, fs);
        return jsch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void knownHosts(JSch sch, FS fs) throws JSchException {
        File home = fs.userHome();
        if (home == null) {
            return;
        }
        File known_hosts = new File(new File(home, ".ssh"), "known_hosts");
        try {
            FileInputStream in = new FileInputStream(known_hosts);
            try {
                sch.setKnownHosts((InputStream)in);
            }
            finally {
                in.close();
            }
        }
        catch (FileNotFoundException none) {
        }
        catch (IOException err) {
            // empty catch block
        }
    }

    private void identities(JSch sch, FS fs) {
        File home = fs.userHome();
        if (home == null) {
            return;
        }
        File sshdir = new File(home, ".ssh");
        if (sshdir.isDirectory()) {
            this.loadIdentity(sch, new File(sshdir, "identity"));
            this.loadIdentity(sch, new File(sshdir, "id_rsa"));
            this.loadIdentity(sch, new File(sshdir, "id_dsa"));
        }
    }

    private void loadIdentity(JSch sch, File priv) {
        if (priv.isFile()) {
            try {
                sch.addIdentity(priv.getAbsolutePath());
            }
            catch (JSchException jSchException) {
                // empty catch block
            }
        }
    }
}

