/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.text.ParseException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public final class BinarySearch
extends Enum<BinarySearch> {
    public static final /* enum */ BinarySearch INSTANCE = new BinarySearch();
    private static final /* synthetic */ BinarySearch[] $VALUES;

    public static BinarySearch[] values() {
        return (BinarySearch[])$VALUES.clone();
    }

    public static BinarySearch valueOf(String name) {
        return Enum.valueOf(BinarySearch.class, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long search(@NotNull SingleChronicleQueue q, @NotNull Wire key, @NotNull Comparator<Wire> c) throws ParseException {
        long readPosition = key.bytes().readPosition();
        try {
            ExcerptTailer tailer = q.createTailer();
            long start = tailer.toStart().index();
            long end = tailer.toEnd().index();
            RollCycle rollCycle = q.rollCycle();
            int startCycle = rollCycle.toCycle(start);
            int endCycle = rollCycle.toCycle(end);
            if (startCycle == endCycle) {
                long l = BinarySearch.findWithinCycle(key, c, startCycle, tailer, q, rollCycle);
                return l;
            }
            NavigableSet<Long> cycles = q.listCyclesBetween(startCycle, endCycle);
            int cycle = (int)BinarySearch.findCycleLinearSearch(cycles, key, c, tailer, q);
            if (cycle == -1) {
                long l = -1L;
                return l;
            }
            long l = BinarySearch.findWithinCycle(key, c, cycle, tailer, q, rollCycle);
            return l;
        }
        finally {
            key.bytes().readPosition(readPosition);
        }
    }

    private static long findCycleLinearSearch(@NotNull NavigableSet<Long> cycles, Wire key, @NotNull Comparator<Wire> c, @NotNull ExcerptTailer tailer, @NotNull SingleChronicleQueue queue) {
        Iterator<Long> iterator = cycles.iterator();
        if (!iterator.hasNext()) {
            return -1L;
        }
        RollCycle rollCycle = queue.rollCycle();
        long prevIndex = iterator.next();
        while (iterator.hasNext()) {
            Long current = iterator.next();
            boolean b = tailer.moveToIndex(rollCycle.toIndex((int)current.longValue(), 0L));
            if (!b) {
                return prevIndex;
            }
            DocumentContext dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                int compare = c.compare(dc.wire(), key);
                if (compare == 0) {
                    long l = current;
                    return l;
                }
                if (compare == 1) {
                    long l = prevIndex;
                    return l;
                }
                prevIndex = current;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
            }
        }
        return prevIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long findWithinCycle(@NotNull Wire key, @NotNull Comparator<Wire> c, int cycle, @NotNull ExcerptTailer tailer, @NotNull SingleChronicleQueue q, @NotNull RollCycle rollCycle) {
        long readPosition = key.bytes().readPosition();
        try {
            long lowSeqNum = 0L;
            long highSeqNum = q.exceptsPerCycle(cycle) - 1L;
            if (highSeqNum == 0L) {
                long l = rollCycle.toIndex(cycle, 0L);
                return l;
            }
            if (highSeqNum < lowSeqNum) {
                long l = -1L;
                return l;
            }
            long midIndex = 0L;
            while (lowSeqNum <= highSeqNum) {
                long l;
                long midSeqNumber = lowSeqNum + highSeqNum >>> 1;
                midIndex = rollCycle.toIndex(cycle, midSeqNumber);
                boolean b = tailer.moveToIndex(midIndex);
                assert (b);
                DocumentContext dc = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    if (!dc.isPresent()) {
                        long l2 = -1L;
                        return l2;
                    }
                    key.bytes().readPosition(readPosition);
                    int cmp = c.compare(dc.wire(), key);
                    if (cmp < 0) {
                        lowSeqNum = midSeqNumber + 1L;
                        continue;
                    }
                    if (cmp > 0) {
                        highSeqNum = midSeqNumber - 1L;
                        continue;
                    }
                    l = midIndex;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                return l;
            }
            long l = -midIndex;
            return l;
        }
        finally {
            key.bytes().readPosition(readPosition);
        }
    }

    static {
        $VALUES = new BinarySearch[]{INSTANCE};
    }
}

