/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.single.StoreRecovery;
import net.openhft.chronicle.wire.AbstractMarshallable;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleStoreRecovery
extends AbstractMarshallable
implements StoreRecovery {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleStoreRecovery.class);

    @Override
    public long recoverIndex2Index(@NotNull LongValue index2Index, @NotNull Callable<Long> action, long timeoutMS) throws UnrecoverableTimeoutException {
        Jvm.warn().on(this.getClass(), "Rebuilding the index2index");
        index2Index.setValue(0L);
        try {
            return action.call();
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    public long recoverSecondaryAddress(@NotNull LongArrayValues index2indexArr, int index2, @NotNull Callable<Long> action, long timeoutMS) throws UnrecoverableTimeoutException {
        Jvm.warn().on(this.getClass(), "Timed out trying to get index2index[" + index2 + "]");
        index2indexArr.setValueAt((long)index2, 0L);
        try {
            return action.call();
        }
        catch (TimeoutException e) {
            throw new UnrecoverableTimeoutException((Exception)e);
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    public long recoverAndWriteHeader(@NotNull Wire wire, int length, long timeoutMS, @NotNull LongValue lastPosition) throws UnrecoverableTimeoutException {
        Jvm.warn().on(this.getClass(), "Clearing an incomplete header so a header can be written");
        wire.bytes().writeInt(0);
        wire.pauser().reset();
        try {
            return wire.writeHeader(length, timeoutMS, TimeUnit.MILLISECONDS, lastPosition);
        }
        catch (EOFException | TimeoutException e) {
            throw new UnrecoverableTimeoutException(e);
        }
    }
}

