/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum StoreComponentReferenceHandler {

    public static final String THREAD_NAME = "queue-thread-local-cleaner-daemon";
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreComponentReferenceHandler.class);
    private static final ReferenceQueue<ExcerptAppender> EXPIRED_THREAD_LOCAL_APPENDERS_QUEUE = new ReferenceQueue();
    private static final ReferenceQueue<SingleChronicleQueueExcerpts.StoreTailer> EXPIRED_THREAD_LOCAL_TAILERS_QUEUE = new ReferenceQueue();
    private static final ExecutorService THREAD_LOCAL_CLEANER_EXECUTOR_SERVICE = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.setName(THREAD_NAME);
        return thread;
    });
    private static final ConcurrentMap<Reference<?>, Runnable> CLOSE_ACTIONS = new ConcurrentHashMap();
    private static final boolean SHOULD_RELEASE_RESOURCES = Boolean.valueOf(System.getProperty("chronicle.queue.release.weakRef.resources", Boolean.TRUE.toString()));

    static ReferenceQueue<ExcerptAppender> appenderQueue() {
        return EXPIRED_THREAD_LOCAL_APPENDERS_QUEUE;
    }

    static ReferenceQueue<SingleChronicleQueueExcerpts.StoreTailer> tailerQueue() {
        return EXPIRED_THREAD_LOCAL_TAILERS_QUEUE;
    }

    static <T> void register(Reference<T> reference, Runnable cleanupJob) {
        CLOSE_ACTIONS.put(reference, cleanupJob);
    }

    private static void processReferenceQueue(ReferenceQueue<?> referenceQueue) {
        try {
            Runnable closeAction;
            Reference<?> reference = referenceQueue.remove(1000L);
            if (reference != null && reference.get() == null && (closeAction = (Runnable)CLOSE_ACTIONS.remove(reference)) != null && SHOULD_RELEASE_RESOURCES) {
                closeAction.run();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Thread-local cleaner thread was interrupted. Exiting.");
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            LOGGER.warn("Error occurred attempting to close ExcerptAppender.", (Throwable)e);
        }
    }

    static {
        THREAD_LOCAL_CLEANER_EXECUTOR_SERVICE.submit(() -> {
            while (!Thread.currentThread().isInterrupted()) {
                StoreComponentReferenceHandler.processReferenceQueue(EXPIRED_THREAD_LOCAL_APPENDERS_QUEUE);
                StoreComponentReferenceHandler.processReferenceQueue(EXPIRED_THREAD_LOCAL_TAILERS_QUEUE);
            }
        });
    }
}

