/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessProperty;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.UnconditionalDerefDataflow;
import edu.umd.cs.findbugs.ba.npe.UnconditionalDerefSet;
import java.util.BitSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class BuildUnconditionalParamDerefDatabase {
    private static final boolean VERBOSE_DEBUG = Boolean.getBoolean("fnd.debug.nullarg.verbose");
    private static final boolean DEBUG = Boolean.getBoolean("fnd.debug.nullarg") || VERBOSE_DEBUG;
    private ParameterNullnessPropertyDatabase database;

    protected ParameterNullnessPropertyDatabase getDatabase() {
        return this.database;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        if (this.database == null) {
            this.database = AnalysisContext.currentAnalysisContext().getUnconditionalDerefParamDatabase();
            if (this.database == null) {
                this.database = new ParameterNullnessPropertyDatabase();
                AnalysisContext.currentAnalysisContext().setUnconditionalDerefParamDatabase(this.database);
            }
        }
        if (VERBOSE_DEBUG) {
            System.out.println("Visiting class " + classContext.getJavaClass().getClassName());
        }
        Method[] arr$ = methodList = classContext.getJavaClass().getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            boolean hasReferenceParameters = false;
            Type[] arr$2 = method.getArgumentTypes();
            int len$2 = arr$2.length;
            for (int i$2 = 0; i$2 < len$2; ++i$2) {
                Type argument = arr$2[i$2];
                if (!(argument instanceof ReferenceType)) continue;
                hasReferenceParameters = true;
            }
            if (!hasReferenceParameters || classContext.getMethodGen(method) == null) continue;
            if (VERBOSE_DEBUG) {
                System.out.println("Check " + method);
            }
            this.analyzeMethod(classContext, method);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) {
        try {
            CFG cfg = classContext.getCFG(method);
            UnconditionalDerefDataflow dataflow = classContext.getUnconditionalDerefDataflow(method);
            UnconditionalDerefSet unconditionalDerefSet = (UnconditionalDerefSet)dataflow.getResultFact(cfg.getEntry());
            if (!unconditionalDerefSet.isValid()) {
                if (VERBOSE_DEBUG) {
                    System.out.println("\tResult is not valid: " + unconditionalDerefSet.toString());
                }
                return;
            }
            if (unconditionalDerefSet.isEmpty()) {
                if (VERBOSE_DEBUG) {
                    System.out.println("\tResult is empty");
                }
                return;
            }
            if (VERBOSE_DEBUG) {
                System.out.println("\tAdding result " + unconditionalDerefSet.toString() + " to database");
            }
            ParameterNullnessProperty property = new ParameterNullnessProperty();
            property.setNonNullParamSet((BitSet)unconditionalDerefSet);
            XMethod xmethod = XFactory.createXMethod((JavaClass)classContext.getJavaClass(), (Method)method);
            this.database.setProperty((Object)xmethod, (Object)property);
            if (DEBUG) {
                System.out.println("Unconditional deref: " + xmethod + "=" + property);
            }
        }
        catch (CFGBuilderException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error analyzing " + method + " for unconditional deref training", (Throwable)e);
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error analyzing " + method + " for unconditional deref training", (Throwable)e);
        }
    }
}

