/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashSet;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

public class XMLFactoryBypass
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private static final Set<String> xmlInterfaces = new HashSet<String>(){
        static final long serialVersionUID = -9117982073509840017L;
        {
            this.add("javax.xml.parsers.DocumentBuilder");
            this.add("org.w3c.dom.Document");
            this.add("javax.xml.parsers.SAXParser");
            this.add("org.xml.sax.XMLReader");
            this.add("org.xml.sax.XMLFilter");
            this.add("javax.xml.transform.Transformer");
            this.add("org.w3c.dom.Attr");
            this.add("org.w3c.dom.CDATASection");
            this.add("org.w3c.dom.Comment");
            this.add("org.w3c.dom.Element");
            this.add("org.w3c.dom.Text");
        }
    };
    private final Set<String> rejectedXMLClasses = new HashSet<String>();
    private JavaClass curClass;

    public XMLFactoryBypass(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.curClass = classContext.getJavaClass();
        super.visitClassContext(classContext);
    }

    public void sawOpcode(int seen) {
        try {
            if (seen == 183) {
                JavaClass[] infs;
                String newClsName = this.getClassConstantOperand();
                if (this.rejectedXMLClasses.contains(newClsName)) {
                    return;
                }
                this.rejectedXMLClasses.add(newClsName);
                if (newClsName.startsWith("java/") || newClsName.startsWith("javax/")) {
                    return;
                }
                if (newClsName.endsWith("Adapter")) {
                    return;
                }
                if (!this.getNameConstantOperand().equals("<init>")) {
                    return;
                }
                String invokerClsName = this.getClassName();
                if (this.samePackageBase(invokerClsName, newClsName)) {
                    return;
                }
                JavaClass newCls = Repository.lookupClass((String)this.getDottedClassConstantOperand());
                JavaClass superCls = this.curClass.getSuperClass();
                if (superCls.getClassName().equals(newClsName.replace('/', '.'))) {
                    return;
                }
                JavaClass[] arr$ = infs = newCls.getAllInterfaces();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    JavaClass inf = arr$[i$];
                    if (!xmlInterfaces.contains(inf.getClassName())) continue;
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "XFB_XML_FACTORY_BYPASS", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                    this.rejectedXMLClasses.remove(newClsName);
                }
            }
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    public boolean samePackageBase(String invokerClsName, String newClsName) {
        String[] invokerParts = invokerClsName.split("/");
        String[] newClsParts = newClsName.split("/");
        if (newClsParts.length < 3) {
            return false;
        }
        if (invokerParts.length < 3) {
            return false;
        }
        if (!invokerParts[0].equals(newClsParts[0])) {
            return false;
        }
        return invokerParts[1].equals(newClsParts[1]);
    }
}

