/*
 * Decompiled with CFR 0.152.
 */
package fr.brouillard.oss.jgitver.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;

public class Commit {
    private final ObjectId gitObject;
    private final List<Ref> annotatedTags;
    private final List<Ref> lightTags;
    private final int headDistance;

    public Commit(ObjectId gitObject, int headDistance, List<Ref> annotatedTags, List<Ref> lightTags) {
        this.gitObject = Objects.requireNonNull(gitObject);
        this.annotatedTags = new ArrayList<Ref>((Collection)Objects.requireNonNull(annotatedTags));
        this.lightTags = new ArrayList<Ref>((Collection)Objects.requireNonNull(lightTags));
        this.headDistance = headDistance;
    }

    public ObjectId getGitObject() {
        return this.gitObject;
    }

    public List<Ref> getAnnotatedTags() {
        return this.annotatedTags;
    }

    public List<Ref> getLightTags() {
        return this.lightTags;
    }

    public int getHeadDistance() {
        return this.headDistance;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit commit = (Commit)o;
        return Objects.equals(this.gitObject, commit.gitObject);
    }

    public int hashCode() {
        return Objects.hash(this.gitObject);
    }
}

