/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.action.api;

import fr.enedis.chutney.action.api.ActionDto;
import fr.enedis.chutney.action.domain.ActionTemplate;
import fr.enedis.chutney.action.domain.parameter.Parameter;
import fr.enedis.chutney.action.spi.injectable.Input;
import fr.enedis.chutney.action.spi.injectable.Target;
import java.util.List;

public class ActionTemplateMapper {
    private ActionTemplateMapper() {
    }

    public static ActionDto toDto(ActionTemplate actionTemplate) {
        return new ActionDto(actionTemplate.identifier(), ActionTemplateMapper.hasTarget(actionTemplate), ActionTemplateMapper.toInputsDto(actionTemplate));
    }

    private static boolean hasTarget(ActionTemplate actionTemplate) {
        return actionTemplate.parameters().stream().anyMatch(p -> p.rawType().equals(Target.class));
    }

    private static List<ActionDto.InputsDto> toInputsDto(ActionTemplate actionTemplate) {
        return actionTemplate.parameters().stream().filter(parameter -> parameter.annotations().optional(Input.class).isPresent()).map(ActionTemplateMapper::simpleParameterToInputsDto).toList();
    }

    private static ActionDto.InputsDto simpleParameterToInputsDto(Parameter parameter) {
        return new ActionDto.InputsDto(parameter.annotations().get(Input.class).value(), parameter.rawType());
    }
}

