/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.api.execution;

import fr.enedis.chutney.action.spi.injectable.ActionsConfiguration;
import fr.enedis.chutney.engine.api.execution.EnvironmentDtoMapper;
import fr.enedis.chutney.engine.api.execution.ExecutionRequestDto;
import fr.enedis.chutney.engine.api.execution.StepDefinitionMapper;
import fr.enedis.chutney.engine.api.execution.StepExecutionReportDto;
import fr.enedis.chutney.engine.api.execution.StepExecutionReportMapper;
import fr.enedis.chutney.engine.api.execution.TestEngine;
import fr.enedis.chutney.engine.domain.execution.ExecutionEngine;
import fr.enedis.chutney.engine.domain.execution.ExecutionManager;
import fr.enedis.chutney.engine.domain.execution.ScenarioExecution;
import fr.enedis.chutney.engine.domain.execution.StepDefinition;
import fr.enedis.chutney.engine.domain.execution.engine.Dataset;
import fr.enedis.chutney.engine.domain.execution.engine.Environment;
import fr.enedis.chutney.engine.domain.report.Reporter;
import io.reactivex.rxjava3.core.Observable;
import java.util.Optional;

public final class EmbeddedTestEngine
implements TestEngine {
    private final ExecutionEngine engine;
    private final Reporter reporter;
    private final ExecutionManager executionManager;
    private final ActionsConfiguration actionsConfiguration;

    public EmbeddedTestEngine(ExecutionEngine engine, Reporter reporter, ExecutionManager executionManager, ActionsConfiguration actionsConfiguration) {
        this.engine = engine;
        this.reporter = reporter;
        this.executionManager = executionManager;
        this.actionsConfiguration = actionsConfiguration;
    }

    @Override
    public StepExecutionReportDto execute(ExecutionRequestDto request) {
        Long executionId = this.executeAsync(request);
        return (StepExecutionReportDto)this.receiveNotification(executionId).blockingLast();
    }

    @Override
    public Long executeAsync(ExecutionRequestDto request) {
        StepDefinition stepDefinition = StepDefinitionMapper.toStepDefinition(request.scenario.definition);
        Dataset dataset = Optional.ofNullable(request.dataset).map(d -> new Dataset(d.constants, d.datatable)).orElseGet(Dataset::new);
        Environment environment = EnvironmentDtoMapper.INSTANCE.toDomain(request.environment);
        return this.engine.execute(stepDefinition, dataset, ScenarioExecution.createScenarioExecution(this.actionsConfiguration), environment);
    }

    @Override
    public Observable<StepExecutionReportDto> receiveNotification(Long executionId) {
        return this.reporter.subscribeOnExecution(executionId).map(StepExecutionReportMapper::toDto);
    }

    @Override
    public void pauseExecution(Long executionId) {
        this.executionManager.pauseExecution(executionId);
    }

    @Override
    public void resumeExecution(Long executionId) {
        this.executionManager.resumeExecution(executionId);
    }

    @Override
    public void stopExecution(Long executionId) {
        this.executionManager.stopExecution(executionId);
    }

    @Override
    public void close() {
        this.engine.shutdown();
    }
}

