/*
 * Decompiled with CFR 0.152.
 */
package fr.enedis.chutney.engine.domain.execution.engine;

import fr.enedis.chutney.action.spi.FinallyAction;
import fr.enedis.chutney.action.spi.injectable.Target;
import fr.enedis.chutney.engine.domain.delegation.DelegationService;
import fr.enedis.chutney.engine.domain.execution.ExecutionEngine;
import fr.enedis.chutney.engine.domain.execution.RxBus;
import fr.enedis.chutney.engine.domain.execution.ScenarioExecution;
import fr.enedis.chutney.engine.domain.execution.StepDefinition;
import fr.enedis.chutney.engine.domain.execution.engine.Dataset;
import fr.enedis.chutney.engine.domain.execution.engine.Environment;
import fr.enedis.chutney.engine.domain.execution.engine.FinallyActionMapper;
import fr.enedis.chutney.engine.domain.execution.engine.StepExecutor;
import fr.enedis.chutney.engine.domain.execution.engine.evaluation.StepDataEvaluator;
import fr.enedis.chutney.engine.domain.execution.engine.scenario.ScenarioContext;
import fr.enedis.chutney.engine.domain.execution.engine.scenario.ScenarioContextImpl;
import fr.enedis.chutney.engine.domain.execution.engine.step.Step;
import fr.enedis.chutney.engine.domain.execution.event.EndScenarioExecutionEvent;
import fr.enedis.chutney.engine.domain.execution.event.StartScenarioExecutionEvent;
import fr.enedis.chutney.engine.domain.execution.strategies.StepExecutionStrategies;
import fr.enedis.chutney.engine.domain.execution.strategies.StepExecutionStrategy;
import fr.enedis.chutney.engine.domain.execution.strategies.StepStrategyDefinition;
import fr.enedis.chutney.engine.domain.execution.strategies.StrategyProperties;
import fr.enedis.chutney.engine.domain.report.Reporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExecutionEngine
implements ExecutionEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionEngine.class);
    private final ExecutorService actionExecutor;
    private final StepDataEvaluator dataEvaluator;
    private final StepExecutionStrategies stepExecutionStrategies;
    private final DelegationService delegationService;
    private final Reporter reporter;

    public DefaultExecutionEngine(StepDataEvaluator dataEvaluator, StepExecutionStrategies stepExecutionStrategies, DelegationService delegationService, Reporter reporter, ExecutorService actionExecutor) {
        this.dataEvaluator = dataEvaluator;
        this.stepExecutionStrategies = stepExecutionStrategies != null ? stepExecutionStrategies : new StepExecutionStrategies();
        this.delegationService = delegationService;
        this.reporter = reporter;
        this.actionExecutor = actionExecutor;
    }

    @Override
    public Long execute(StepDefinition stepDefinition, Dataset dataset, ScenarioExecution execution, Environment environment) {
        AtomicReference<Step> rootStep = new AtomicReference<Step>(Step.nonExecutable(stepDefinition));
        this.reporter.createPublisher(execution.executionId, rootStep.get());
        this.actionExecutor.execute(() -> {
            ScenarioContextImpl scenarioContext = new ScenarioContextImpl();
            try {
                try {
                    scenarioContext.put("environment", environment.name());
                    scenarioContext.putAll(Optional.ofNullable(environment.variables()).orElse(Collections.emptyMap()));
                    scenarioContext.put("dataset", this.getDataSet(dataset, scenarioContext));
                    scenarioContext.putAll(this.evaluateDatasetConstants(dataset, scenarioContext));
                    rootStep.set(this.buildStep(stepDefinition));
                    RxBus.getInstance().post(new StartScenarioExecutionEvent(execution, (Step)rootStep.get()));
                    StepExecutionStrategy strategy = this.stepExecutionStrategies.buildStrategyFrom((Step)rootStep.get());
                    strategy.execute(execution, (Step)rootStep.get(), scenarioContext, this.stepExecutionStrategies);
                }
                catch (VirtualMachineError vme) {
                    throw vme;
                }
                catch (Throwable t) {
                    ((Step)rootStep.get()).failure(t);
                    LOGGER.warn("Intercepted exception in root step execution !", t);
                }
                this.executeFinallyActions(execution, rootStep, scenarioContext);
            }
            finally {
                RxBus.getInstance().post(new EndScenarioExecutionEvent(execution, (Step)rootStep.get()));
            }
        });
        return execution.executionId;
    }

    private List<Map<String, String>> getDataSet(Dataset dataset, ScenarioContext scenarioContext) {
        if (dataset.datatable.isEmpty() && !dataset.constants.isEmpty()) {
            Map<String, ?> evaluateDatasetConstants = this.evaluateDatasetConstants(dataset, scenarioContext);
            return List.of(evaluateDatasetConstants);
        }
        return dataset.datatable;
    }

    @Override
    public void shutdown() {
        this.actionExecutor.shutdown();
    }

    private Map<String, ?> evaluateDatasetConstants(Dataset dataset, ScenarioContext scenarioContext) {
        return dataset.constants.entrySet().stream().map(e -> Map.entry((String)e.getKey(), this.dataEvaluator.evaluate(e.getValue(), scenarioContext))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Optional<Step> initFinalRootStep(AtomicReference<Step> rootStep, List<FinallyAction> finallyActionsSnapshot) {
        try {
            Pair finalStepsWithDefinitions = finallyActionsSnapshot.stream().map(fa -> {
                StepDefinition definition = new FinallyActionMapper().toStepDefinition((FinallyAction)fa);
                return Pair.of(Collections.singletonList(definition), Collections.singletonList(this.buildStep(definition)));
            }).reduce(Pair.of(new ArrayList(), new ArrayList()), (p1, p2) -> {
                ((List)p1.getLeft()).addAll((Collection)p2.getLeft());
                ((List)p1.getRight()).addAll((Collection)p2.getRight());
                return p1;
            });
            StepDefinition finalRootStepDefinition = new StepDefinition("TearDown", null, "", new StepStrategyDefinition("soft-assert", new StrategyProperties()), Collections.emptyMap(), (List)finalStepsWithDefinitions.getLeft(), Collections.emptyMap(), Collections.emptyMap());
            return Optional.of(new Step(this.dataEvaluator, finalRootStepDefinition, this.delegationService.findExecutor(Optional.empty()), (List)finalStepsWithDefinitions.getRight()));
        }
        catch (RuntimeException e) {
            rootStep.get().failure(e);
            LOGGER.warn("Cannot init final root step !", (Throwable)e);
            return Optional.empty();
        }
    }

    private void executeFinallyActions(ScenarioExecution execution, AtomicReference<Step> rootStep, ScenarioContext scenarioContext) {
        if (!execution.finallyActions().isEmpty()) {
            ArrayList<FinallyAction> finallyActionsSnapshot = new ArrayList<FinallyAction>(execution.finallyActions());
            Optional<Step> finalRootStep = this.initFinalRootStep(rootStep, finallyActionsSnapshot);
            finalRootStep.ifPresent(frs -> {
                ((Step)rootStep.get()).addStepExecution((Step)frs);
                execution.initFinallyActionExecution();
                try {
                    StepExecutionStrategy strategy = this.stepExecutionStrategies.buildStrategyFrom((Step)frs);
                    strategy.execute(execution, (Step)frs, scenarioContext, this.stepExecutionStrategies);
                }
                catch (VirtualMachineError vme) {
                    throw vme;
                }
                catch (Throwable t) {
                    frs.failure(t);
                    LOGGER.warn("Teardown did not finish properly !", t);
                }
            });
        }
    }

    private Step buildStep(StepDefinition definition) {
        LOGGER.debug("Build : " + String.valueOf(definition));
        Optional<Target> target = definition.getTarget();
        StepExecutor executor = this.delegationService.findExecutor(target);
        List<Step> steps = definition.steps.stream().map(this::buildStep).collect(Collectors.toList());
        return new Step(this.dataEvaluator, definition, executor, steps);
    }
}

